package yangtz.cs.liu.campus.service.impl.student;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SchoolTeacher;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.service.ISysUserService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.persistence.entity.TaskEntityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import yangtz.cs.liu.activiti.service.IProcessService;
import yangtz.cs.liu.campus.domain.office.SchoolOfficePurchase;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.domain.student.SchoolStudentLeave;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherLeave;
import yangtz.cs.liu.campus.mapper.student.SchoolStudentLeaveMapper;
import yangtz.cs.liu.campus.mapper.teacher.SchoolTeacherLeaveMapper;
import yangtz.cs.liu.campus.mapper.teacher.SchoolTeacherMapper;
import yangtz.cs.liu.campus.service.student.ISchoolStudentLeaveService;
import yangtz.cs.liu.campus.vo.office.OfficeTodoListVO;
import yangtz.cs.liu.campus.vo.student.StudentLeaveVO;
import yangtz.cs.liu.campus.vo.teacher.TeacherLeaveVO;
import yangtz.cs.liu.campus.vo.teacher.TeacherOvertimeVO;
import yangtz.cs.liu.wechat.vo.common.WorkFlowVo;
import yangtz.cs.liu.wechat.vo.student.SchoolStudentLeaveVo;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.ruoyi.common.utils.StringUtils.substring;
import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

import static com.core.constant.ProcessCommon.PENDING;
import static com.core.constant.ProcessCommon.SUSPENDSTATE_PENDING;
import static com.core.constant.ProcessVariables.*;
import static com.ruoyi.common.utils.SecurityUtils.getUserId;
import static yangtz.cs.liu.campus.constant.GradeConstant.GRADELEADER;
import static yangtz.cs.liu.campus.constant.ProcessState.APPROVAL;

@Service
public class SchoolStudentLeaveServiceImpl extends ServiceImpl<SchoolStudentLeaveMapper, SchoolStudentLeave> implements ISchoolStudentLeaveService {

    @Autowired
    private SchoolStudentLeaveMapper schoolStudentLeaveMapper;

    @Autowired
    private SchoolTeacherLeaveMapper schoolTeacherLeaveMapper;

    @Autowired
    private  SchoolStudentLeaveServiceImpl schoolStudentLeaveService;

    @Resource
    private IdentityService identityService;

    @Autowired
    private RuntimeService runtimeService;

    @Autowired
    private HistoryService historyService;

    @Autowired
    private IProcessService processService;

    @Autowired
    private ISysUserService userService;

    @Autowired
    private TaskService taskService;

    @Override
    public List<StudentLeaveVO> queryList(String submitState, StudentLeaveVO studentLeave) {
        List<StudentLeaveVO> studentLeaveVOList = schoolStudentLeaveMapper.queryList(submitState, studentLeave);
        // 当前环节
        for (StudentLeaveVO leave : studentLeaveVOList) {
            if (StringUtils.isNotBlank(leave.getInstanceId())) {
                List<Task> taskList = taskService.createTaskQuery()
                        .processInstanceId(leave.getInstanceId())
                        .list();    // 例如请假会签，会同时拥有多个任务
                if (!CollectionUtils.isEmpty(taskList)) {
                    TaskEntityImpl task = (TaskEntityImpl) taskList.get(0);
                    leave.setTaskId(task.getId());
                    if (task.getSuspensionState() == 2) {
                        leave.setTaskName("已挂起");
                        leave.setSuspendState("2");
                    } else {
                        leave.setTaskName(task.getName());
                        leave.setSuspendState("1");
                    }
                } else {
                    // 已办结或者已撤销
                    leave.setTaskName("已结束");
                }
            } else {
                leave.setTaskName("未启动");
            }
        }
        return studentLeaveVOList;
    }


    /**
     * @author lyric
     * edit on 2022-10-28
     */
    @Override
    public int submitApply(SchoolStudentLeave schoolStudentLeave, String username, String key, Map<String, Object> variables) {
        String businessKey = schoolStudentLeave.getId().toString();
        identityService.setAuthenticatedUserId(username);

        //设置班主任
        variables.put(STUDENTHANDUSERID, schoolStudentLeave.getHandUserId());

        //设置级部主任
        variables.put(STUDENTHANDUSERID2, schoolStudentLeave.getHandUserId2());

        //设置销假人
        variables.put(STUDENTXIAOJIA,schoolStudentLeave.getHandUserId());
//
//        //设置处理人
//        variables.put(CHARGEUSERID, schoolStudentLeave.getHandUserId());
//        //设置销假人
//        variables.put(APPLYUSER, schoolStudentLeave.getApplyUserId());

        ProcessInstance processInstance = runtimeService.startProcessInstanceByKey(key, businessKey, variables);
        String instanceId = processInstance.getId();
        //与我们的业务表开始建立关系
        schoolStudentLeave.setInstanceId(instanceId);
        schoolStudentLeave.setState(APPROVAL);
        return schoolStudentLeaveMapper.updateById(schoolStudentLeave);
    }

//    /**
//     * @param entity
//     * @param userId
//     * @return
//     * @author lyric
//     * @date 2021-10-07
//     * 待办列表
//     * <p>
//     * 1.根据当前登录人查询出待办任务集合(这里查的不仅是处理人的,还有事用户组的也查出来了,可能之后需要做处理)
//     * 2.遍历集合,获取每一个业务对象转vo
//     * 3.分页返回
//     */
//    @Override
//    public List<StudentLeaveVO> findTodoTasks(String key, SchoolStudentLeave entity, String userId) {
//        List<StudentLeaveVO> list = new ArrayList<>();
//        //当前登录人待办任务集合
////        List<Task> taskList = processService.findTodoList(userId, key);
//        List<Task> taskList = processService.findAssigneeTasks(userId, key);
//        for (Task task : taskList) {
//            TaskEntityImpl taskImpl = (TaskEntityImpl) task;
//            //拿到当前任务id
//            String processInstanceId = taskImpl.getProcessInstanceId();
//            //拿到流程定义对象
//            ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
//            //业务id(我们当时新增的时候指定了businessKey为id)
//            String businessKey = processInstance.getBusinessKey();
//            //通过id查询出我们业务对象
//            SchoolStudentLeave schoolStudentLeave = schoolStudentLeaveMapper.selectById(new Long(businessKey));
//            if (StringUtils.isNull(schoolStudentLeave)) {
//                continue;
//            }
//            //转vo
//            StudentLeaveVO studentLeaveVO = new StudentLeaveVO();
//            BeanUtils.copyProperties(schoolStudentLeave, studentLeaveVO);
//            studentLeaveVO.setTaskId(taskImpl.getId());
//
//            if (SUSPENDSTATE_PENDING.equals(taskImpl.getSuspensionState())) {
//                //挂起
//                studentLeaveVO.setTaskName(PENDING);
//            } else {
//                studentLeaveVO.setTaskName(taskImpl.getName());
//            }
//            list.add(studentLeaveVO);
//        }
//        List<StudentLeaveVO> resList = list.stream().sorted(Comparator.comparing(StudentLeaveVO::getApplyTime).reversed()).collect(Collectors.toList());
//        return resList;
//    }

    /**
     * @param entity
     * @param userId
     * @return
     * @author lyric
     * @date 2021-10-07
     * 待办列表模糊查询
     * <p>
     * 1.根据当前登录人查询出待办任务集合(这里查的不仅是处理人的,还有事用户组的也查出来了,可能之后需要做处理)
     * 2.遍历集合,获取每一个业务对象转vo
     * 3.分页返回
     */
    @Override
    public List<StudentLeaveVO> findTodoTasks(String key, SchoolStudentLeave entity, String userId) {
        String parmaName = entity.getStudentName();
        String parmaClassName = entity.getClassName();
        List<StudentLeaveVO> list = new ArrayList<>();
        //当前登录人待办任务集合
//        List<Task> taskList = processService.findTodoList(userId, key);
        List<Task> taskList = processService.findAssigneeTasks(userId, key);
        for (Task task : taskList) {
            TaskEntityImpl taskImpl = (TaskEntityImpl) task;
            //拿到当前任务id
            String processInstanceId = taskImpl.getProcessInstanceId();
            //拿到流程定义对象
            ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            //业务id(我们当时新增的时候指定了businessKey为id)
            String businessKey = processInstance.getBusinessKey();
            //通过id查询出我们业务对象
            SchoolStudentLeave schoolStudentLeave = schoolStudentLeaveMapper.selectById(new Long(businessKey));
            //若查询参数不为空，且查询出的实体内学生名不包含模糊查询参数，直接下一次循环
            if (!StringUtils.isNull(parmaName) &&
                    !schoolStudentLeave.getStudentName().contains(parmaName)){
                continue;
            }
            if (!StringUtils.isNull(parmaClassName) &&
                    !schoolStudentLeave.getClassName().contains(parmaClassName)){
                continue;
            }
            if (StringUtils.isNull(schoolStudentLeave)) {
                continue;
            }
            //转vo
            StudentLeaveVO studentLeaveVO = new StudentLeaveVO();
            BeanUtils.copyProperties(schoolStudentLeave, studentLeaveVO);
            studentLeaveVO.setTaskId(taskImpl.getId());

            if (SUSPENDSTATE_PENDING.equals(taskImpl.getSuspensionState())) {
                //挂起
                studentLeaveVO.setTaskName(PENDING);
            } else {
                studentLeaveVO.setTaskName(taskImpl.getName());
            }
            list.add(studentLeaveVO);
        }
        List<StudentLeaveVO> resList = list.stream().sorted(Comparator.comparing(StudentLeaveVO::getApplyTime).reversed()).collect(Collectors.toList());
        return resList;
    }
    /**
     * @param key
     * @param entity
     * @param userId
     * @return 已办列表
     * @author lyric
     * @date 2021-10-10
     */
    @Override
    public List<StudentLeaveVO> findDoneTasks(String key, SchoolStudentLeave entity, String userId) {

        List<StudentLeaveVO> list = new ArrayList<>();

        //当前登录人完成的历史集合
        List<HistoricTaskInstance> hisList = processService.findDoneTasks(userId, key);

        for (HistoricTaskInstance instance : hisList) {
            //流程实例key
            String processInstanceId = instance.getProcessInstanceId();
            HistoricProcessInstance processInstance = historyService.createHistoricProcessInstanceQuery()
                    .processInstanceId(processInstanceId)
                    .singleResult();
            //业务id
            String businessKey = processInstance.getBusinessKey();
            //通过id查询出我们业务对象
            SchoolStudentLeave schoolStudentLeave = schoolStudentLeaveMapper.selectById(new Long(businessKey));
            if (StringUtils.isNull(schoolStudentLeave)) {
                continue;
            }
            //转vo
            StudentLeaveVO studentLeaveVO = new StudentLeaveVO();
            BeanUtils.copyProperties(schoolStudentLeave, studentLeaveVO);
            studentLeaveVO.setTaskName(instance.getName());
            list.add(studentLeaveVO);
        }
        return list;
    }

    /**
     * 班主任个人任务列表
     *
     * @param key
     * @param entity
     * @param userId
     * @return
     */
    @Override
    public List<StudentLeaveVO> findHeaderTasks(String key, SchoolStudentLeave entity, String userId) {
        List<StudentLeaveVO> list = new ArrayList<>();
        //当前登录人待办任务集合
        List<Task> taskList = processService.findAssigneeTasks(userId, key);

        for (Task task : taskList) {
            TaskEntityImpl taskImpl = (TaskEntityImpl) task;
            //拿到当前任务id
            String processInstanceId = taskImpl.getProcessInstanceId();
            //拿到流程定义对象
            ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            //业务id(我们当时新增的时候指定了businessKey为id)
            String businessKey = processInstance.getBusinessKey();
            //通过id查询出我们业务对象
            SchoolStudentLeave schoolStudentLeave = schoolStudentLeaveMapper.selectById(new Long(businessKey));
            if (StringUtils.isNull(schoolStudentLeave)) {
                continue;
            }
            if (!StringUtils.isNull(entity.getStudentName()) &&
                    !schoolStudentLeave.getStudentName().contains(entity.getStudentName())){
                continue;
            }
            if (!StringUtils.isNull(entity.getClassName()) &&
                    !schoolStudentLeave.getClassName().contains(entity.getClassName())){

            }
            if(!StringUtils.isNull(entity.getState()) &&
            !schoolStudentLeave.getState().equals(entity.getState())){
                continue;
            }
            //转vo
            StudentLeaveVO studentLeaveVO = new StudentLeaveVO();
            BeanUtils.copyProperties(schoolStudentLeave, studentLeaveVO);
            studentLeaveVO.setTaskId(taskImpl.getId());

            if (StringUtils.isNotBlank(schoolStudentLeave.getInstanceId())) {
                List<Task> tList = taskService.createTaskQuery()
                        .processInstanceId(schoolStudentLeave.getInstanceId())
                        .list();    // 例如请假会签，会同时拥有多个任务
                if (!CollectionUtils.isEmpty(tList)) {
                    TaskEntityImpl t = (TaskEntityImpl) tList.get(0);
                    /*leave.setTaskId(task.getId());*/
                    if (t.getSuspensionState() == 2) {
                        studentLeaveVO.setTaskName("已挂起");
                        studentLeaveVO.setSuspendState("2");
                    } else {
                        studentLeaveVO.setTaskName(task.getName());
                        studentLeaveVO.setSuspendState("1");
                    }
                } else {
                    // 已办结或者已撤销
                    studentLeaveVO.setTaskName("已结束");
                }
            } else {
                studentLeaveVO.setTaskName("未启动");
            }
            list.add(studentLeaveVO);
        }

        //当前登录人完成的历史集合
        List<HistoricTaskInstance> hisList = processService.findDoneTasks(userId, key);
        for (HistoricTaskInstance instance : hisList) {
            //流程实例key
            String processInstanceId = instance.getProcessInstanceId();
            HistoricProcessInstance processInstance = historyService.createHistoricProcessInstanceQuery()
                    .processInstanceId(processInstanceId)
                    .singleResult();
            //业务id
            String businessKey = processInstance.getBusinessKey();
            //通过id查询出我们业务对象
            SchoolStudentLeave schoolStudentLeave = schoolStudentLeaveMapper.selectById(new Long(businessKey));
            if (StringUtils.isNull(schoolStudentLeave)) {
                continue;
            }
            if (!StringUtils.isNull(entity.getStudentName()) &&
                    !schoolStudentLeave.getStudentName().contains(entity.getStudentName())){
                continue;
            }
            if (!StringUtils.isNull(entity.getClassName()) &&
                    !schoolStudentLeave.getClassName().contains(entity.getClassName())){

            }
            if(!StringUtils.isNull(entity.getState()) &&
                    !schoolStudentLeave.getState().equals(entity.getState())){
                continue;
            }
            //转vo
            StudentLeaveVO studentLeaveVO = new StudentLeaveVO();
            BeanUtils.copyProperties(schoolStudentLeave, studentLeaveVO);
            //studentLeaveVO.setTaskName(instance.getName());
            if (StringUtils.isNotBlank(schoolStudentLeave.getInstanceId())) {
                List<Task> tList = taskService.createTaskQuery()
                        .processInstanceId(schoolStudentLeave.getInstanceId())
                        .list();    // 例如请假会签，会同时拥有多个任务
                if (!CollectionUtils.isEmpty(tList)) {
                    TaskEntityImpl t = (TaskEntityImpl) tList.get(0);
                    studentLeaveVO.setTaskId(t.getId());
                    if (t.getSuspensionState() == 2) {
                        studentLeaveVO.setTaskName("已挂起");
                        studentLeaveVO.setSuspendState("2");
                    } else {
                        studentLeaveVO.setTaskName(t.getName());
                        studentLeaveVO.setSuspendState("1");
                    }
                } else {
                    // 已办结或者已撤销
                    studentLeaveVO.setTaskName("已结束");
                }
            } else {
                studentLeaveVO.setTaskName("未启动");
            }
            list.add(studentLeaveVO);
        }
        List<StudentLeaveVO> resList = list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(
                () -> new TreeSet<>(Comparator.comparing(StudentLeaveVO::getInstanceId))),ArrayList :: new));
        List<StudentLeaveVO> voList = resList.stream().sorted(Comparator.comparing(StudentLeaveVO::getApplyTime).reversed()).collect(Collectors.toList());
        return voList;
    }

    /**
     * @author lyric
     * @date 2021-10-11
     * 设置候选组
     */
    public void setCandidateUser(String key, Map<String, Object> variables) {
        List<SysUser> userList = userService.selectUserListByRoleKey(key);
        List<String> userIds = userList.stream().map(o -> o.getUserId().toString()).collect(Collectors.toList());
        String candidateUsers = String.join(",", userIds);
        variables.put(CHARGEUSERIDS, candidateUsers);
    }

    /**
     * @param taskId
     * @param schoolStudentLeave 销假
     * @author lyric
     * @date 2022/10/28 10:44
     */
    @Override
    public void cancelLeave(String taskId, SchoolStudentLeave schoolStudentLeave) {
        //结束任务
        taskService.complete(taskId);
        //修改实际开始时间,实际结束时间
        schoolStudentLeaveMapper.updateById(schoolStudentLeave);
    }

    /**班主任销假*/
    @Override
    public void cancel(String taskId, String instanceId, SchoolStudentLeave schoolStudentLeave) {
        LambdaQueryWrapper<SchoolStudentLeave> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolStudentLeave::getInstanceId, instanceId);
        SchoolStudentLeave leave = schoolStudentLeaveService.getOne(lqw);
        //结束任务
        taskService.complete(taskId);
        leave.setRevokeTime(schoolStudentLeave.getRevokeTime());
        //设置状态为已销假
        leave.setState("4");
        schoolStudentLeaveMapper.updateById(leave);
    }

    /**
     * 根据请假总时长判断用户是否选择对应节点的审批人
     * 请假3天以上，需要级部主任审批，3天以内只需要班主任审批即可
     */
    @Override
    public void judgeHandUser(SchoolStudentLeave schoolStudentLeave) {
        Double time = schoolStudentLeave.getTotalTime();
        if (time <= 3) {
            if (schoolStudentLeave.getHandUserId() == null) {
                throw new ServiceException("您还没有选择审批人");
            }
        }
        if (time > 3) {
            if (schoolStudentLeave.getHandUserId2() == null && schoolStudentLeave.getHandUserId() == null) {
                throw new ServiceException("您的请假天数超过三天，请选择级部主任和班主任");
            }
        }

    }

    /**
     * 获取学生姓名，所属班级，班主任，级部主任
     *
     * @param studentId
     * @return
     */
    @Override
    public SchoolStudentLeaveVo getInfo(Long studentId) {
        SchoolStudentLeaveVo info = schoolStudentLeaveMapper.getInfo(studentId);
        Long gradeId = info.getGradeId();
        List<SchoolTeacher> gradeLeader = schoolStudentLeaveMapper.getGradeLeader(gradeId, GRADELEADER);
        Map<Long, String> map = new HashMap<>();
        for (SchoolTeacher teacher : gradeLeader) {
            if (!teacher.getTeacherName().isEmpty()) {
                map.put(teacher.getId(), teacher.getTeacherName());
            }
        }
        info.setGradeLeaderList(map);
        return info;
    }

    /**
     * 代办已办
     */
    @Override
    public List<StudentLeaveVO> findTasks(String key, String userId) {
        List<StudentLeaveVO> list = new ArrayList<>();
        //当前登陆人代办任务集合
        List<Task> taskList = processService.findAssigneeTasks(userId, key);
        for (Task task : taskList) {
            TaskEntityImpl taskImpl = (TaskEntityImpl) task;
            //拿到当前任务id
            String processInstanceId = taskImpl.getProcessInstanceId();
            //拿到流程定义对象
            ProcessInstance processInstance = runtimeService.createProcessInstanceQuery()
                    .processInstanceId(processInstanceId)
                    .singleResult();
            String businessKey = processInstance.getBusinessKey();
            SchoolStudentLeave schoolStudentLeave = schoolStudentLeaveMapper.selectById(new Long(businessKey));
            if (StringUtils.isNull(schoolStudentLeave)) {
                continue;
            }
            StudentLeaveVO studentLeaveVO = new StudentLeaveVO();
            BeanUtils.copyProperties(schoolStudentLeave, studentLeaveVO);
            studentLeaveVO.setTaskId(taskImpl.getId());

            if (SUSPENDSTATE_PENDING.equals(taskImpl.getSuspensionState())) {
                //挂起
                studentLeaveVO.setTaskName(PENDING);
            } else {
                studentLeaveVO.setTaskName(taskImpl.getName());
            }
            list.add(studentLeaveVO);
        }
        //当前登录人完成的历史集合
        List<HistoricTaskInstance> hisList = processService.findDoneTasks(userId, key);
        for (HistoricTaskInstance instance : hisList) {
            //流程实例key
            String processInstanceId = instance.getProcessInstanceId();
            HistoricProcessInstance processInstance = historyService.createHistoricProcessInstanceQuery()
                    .processInstanceId(processInstanceId)
                    .singleResult();
            //业务id
            String businessKey = processInstance.getBusinessKey();
            //通过id查询出我们业务对象
            SchoolStudentLeave schoolStudentLeave = schoolStudentLeaveMapper.selectById(new Long(businessKey));
            if (StringUtils.isNull(schoolStudentLeave)) {
                continue;
            }
            //转vo
            StudentLeaveVO studentLeaveVO = new StudentLeaveVO();
            BeanUtils.copyProperties(schoolStudentLeave, studentLeaveVO);
            list.add(studentLeaveVO);
        }
        List<StudentLeaveVO> collect = list.stream().sorted(Comparator.comparing(StudentLeaveVO::getApplyTime).reversed()).collect(Collectors.toList());
        return collect;
    }


    @Override
    public WorkFlowVo stduntLeavFlows(Long id) {
        SchoolStudentLeave schoolStudentLeave = schoolStudentLeaveService.getById(id);
        String instanceId = schoolStudentLeave.getInstanceId();
        List<String> messages = schoolTeacherLeaveMapper.selectComment(instanceId);
        WorkFlowVo workFlowVo = new WorkFlowVo();
        List<String> newMessages = new ArrayList<>();
        List<String> handleUserName = new ArrayList<>();
        for (String message : messages) {
            String substring = substring(message, 1, 3);
            newMessages.add(substring);
        }
        if (schoolStudentLeave.getHandUserName() != null) {
            handleUserName.add(schoolStudentLeave.getHandUserName());
        }
        if (schoolStudentLeave.getHandUserName2() != null && schoolStudentLeave.getTotalTime() > 3) {
            handleUserName.add(schoolStudentLeave.getHandUserName2());
        }
        workFlowVo.setComment(newMessages);
        workFlowVo.setHandUserName(handleUserName);
        /*******************通过用户id查询用户的职务*****************************/
        return workFlowVo;
    }


    @Override
    public List<SchoolStudentLeave> gradeList(List<Long> idList, SchoolStudentLeave entity) {
        //查询出所有已提交的本级部下的学生的请假
        LambdaQueryWrapper<SchoolStudentLeave> lqw = new LambdaQueryWrapper<>();
        lqw
                .isNotNull(SchoolStudentLeave::getInstanceId)
                .like(isNotNull(entity.getStudentName()),SchoolStudentLeave::getStudentName,entity.getStudentName())
                .like(isNotNull(entity.getClassName()),SchoolStudentLeave::getClassName,entity.getClassName())
                .eq(isNotNull(entity.getState()),SchoolStudentLeave::getState,entity.getState())
                .in(SchoolStudentLeave::getStudentId,idList)
                .orderByDesc(SchoolStudentLeave::getApplyTime)
                ;
        return schoolStudentLeaveMapper.selectList(lqw);
    }

}
