package yangtz.cs.liu.campus.service.impl.student;

import java.util.ArrayList;
import java.util.List;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.mapper.SysDictDataMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteachingAchievements;
import yangtz.cs.liu.campus.mapper.student.SchoolStudentAwardMapper;
import yangtz.cs.liu.campus.domain.student.SchoolStudentAward;
import yangtz.cs.liu.campus.service.student.ISchoolStudentAwardService;
import yangtz.cs.liu.campus.vo.student.SchoolStudentAwardVo;

/**
 * 学生嘉奖Service业务层处理
 *
 * @author ruoyi
 * @date 2024-01-08
 */
@Service
public class SchoolStudentAwardServiceImpl extends ServiceImpl<SchoolStudentAwardMapper,SchoolStudentAward> implements ISchoolStudentAwardService
{
    @Autowired
    private SchoolStudentAwardMapper schoolStudentAwardMapper;
    @Autowired
    private SysDictDataMapper sysDictDataMapper;

    /**
     * 查询学生嘉奖
     *
     * @param id 学生嘉奖主键
     * @return 学生嘉奖
     */
    @Override
    public SchoolStudentAward selectSchoolStudentAwardById(Long id)
    {
        return schoolStudentAwardMapper.selectSchoolStudentAwardById(id);
    }

    /**
     * 查询学生嘉奖列表
     *
     * @param schoolStudentAward 学生嘉奖
     * @return 学生嘉奖
     */
    @Override
    public List<SchoolStudentAward> selectSchoolStudentAwardList(SchoolStudentAward schoolStudentAward)
    {
        return schoolStudentAwardMapper.selectSchoolStudentAwardList(schoolStudentAward);
    }

    /**
     * 新增学生嘉奖
     *
     * @param schoolStudentAward 学生嘉奖
     * @return 结果
     */
    @Override
    public int insertSchoolStudentAward(SchoolStudentAward schoolStudentAward)
    {
        schoolStudentAward.setCreateById(SecurityUtils.getUserId());
        schoolStudentAward.setCreateBy(SecurityUtils.getUsername());
        schoolStudentAward.setCreateTime(DateUtils.getNowDate());
        return schoolStudentAwardMapper.insertSchoolStudentAward(schoolStudentAward);
    }

    /**
     * 修改学生嘉奖
     *
     * @param schoolStudentAward 学生嘉奖
     * @return 结果
     */
    @Override
    public int updateSchoolStudentAward(SchoolStudentAward schoolStudentAward)
    {
        schoolStudentAward.setUpdateById(SecurityUtils.getUserId());
        schoolStudentAward.setUpdateBy(SecurityUtils.getUsername());
        schoolStudentAward.setUpdateTime(DateUtils.getNowDate());
        return schoolStudentAwardMapper.updateSchoolStudentAward(schoolStudentAward);
    }

    /**
     * 批量删除学生嘉奖
     *
     * @param ids 需要删除的学生嘉奖主键
     * @return 结果
     */
    @Override
    public int deleteSchoolStudentAwardByIds(Long[] ids)
    {
        return schoolStudentAwardMapper.deleteSchoolStudentAwardByIds(ids);
    }

    /**
     * 删除学生嘉奖信息
     *
     * @param id 学生嘉奖主键
     * @return 结果
     */
    @Override
    public int deleteSchoolStudentAwardById(Long id)
    {
        return schoolStudentAwardMapper.deleteSchoolStudentAwardById(id);
    }

    /**
     * 提交审核
     * @param schoolStudentAward
     * @return
     */
    @Override
    public int submit(SchoolStudentAward schoolStudentAward) {
        return schoolStudentAwardMapper.updateSchoolStudentAward(schoolStudentAward);
    }

    /**
     * 校验数据
     * @param list
     */
    @Override
    public void checkImport(List<SchoolStudentAwardVo> list) {
        //检验是否为空
        if (StringUtils.isNull(list) || list.size() == 0) {
            throw new ServiceException("导入数据不能为空");
        }
        // 准备记录日志数据
        int failureNum = 0;
        StringBuilder failureMsg = new StringBuilder();
        //查询学期字典键值
        List<SysDictData> semester = sysDictDataMapper.selectDictDataByType("semester_jsdzda");
        //查询年级字典键值
        List<SysDictData> grade = sysDictDataMapper.selectDictDataByType("grade_da");
        //查询班级类型字典键值
        List<SysDictData> type = sysDictDataMapper.selectDictDataByType("class_type_wj");
        //查询性别字典键值
        List<SysDictData> sex = sysDictDataMapper.selectDictDataByType("sys_user_sex");
        //查询嘉奖级别字典键值
        List<SysDictData> studentAwardRank = sysDictDataMapper.selectDictDataByType("student_award_rank");
        for (SchoolStudentAwardVo schoolStudentAwardVo : list) {
            if (StringUtils.isNull(schoolStudentAwardVo.getSchoolYear())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、学年为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAwardVo.getSemester())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、学期为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAwardVo.getYear())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、届别为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAwardVo.getGrade())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、年级为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAwardVo.getClassName())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、班级为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAwardVo.getClassType())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、班级类型为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAwardVo.getName())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、姓名为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAwardVo.getIdCard())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、身份证号为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAwardVo.getSex())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、性别为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAwardVo.getClassTeacher())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、班主任为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAwardVo.getDepartmentDirector())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、级部主任为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAwardVo.getAwardType())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、嘉奖类别为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAwardVo.getAwardRank())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、嘉奖级别为空,请您重新输入! ");
            } else if (StringUtils.isNull(schoolStudentAwardVo.getAwardTime())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、嘉奖时间为空或输入错误,请您重新输入! ");
            } else if (schoolStudentAwardVo.getIdCard().length() != 18 && schoolStudentAwardVo.getIdCard().length() != 15){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、身份证号输入错误,请您重新输入! ");
            }else {
                //判断学年输入是否正确
                String schoolYear = schoolStudentAwardVo.getSchoolYear();
                if (!schoolYear.contains("-")){
                    failureNum++;
                    failureMsg.append("<br/>" + failureNum + "、学年输入格式错误,请您重新输入! ");
                }else {
                    String[] split = schoolYear.split("-");
                    if (split.length != 2) {
                        failureNum++;
                        failureMsg.append("<br/>" + failureNum + "、学年输入格式错误,请您重新输入! ");
                    } else if (!(split[0].matches("\\d+") && split[1].matches("\\d+"))) {
                        failureNum++;
                        failureMsg.append("<br/>" + failureNum + "、学年输入格式错误,请您重新输入! ");
                    } else {
                        //判断学期是否正确
                        String semester1 = "";
                        for (SysDictData sysDictData : semester) {
                            if (schoolStudentAwardVo.getSemester().equals(sysDictData.getDictLabel())) {
                                semester1 = sysDictData.getDictValue();
                            }
                        }
                        if (StringUtils.isEmpty(semester1)) {
                            failureNum++;
                            failureMsg.append("<br/>" + failureNum + "、学期输入错误,请您重新输入! ");
                        } else {
                            schoolStudentAwardVo.setSemester(semester1);

                            //判断届别是否正确
                            if (!schoolStudentAwardVo.getYear().matches("\\d+")) {
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、届别输入错误,请您重新输入! ");
                            } else {
                                //判断年级是否正确
                                String grade1 = "";
                                for (SysDictData sysDictData : grade) {
                                    if (schoolStudentAwardVo.getGrade().equals(sysDictData.getDictLabel())) {
                                        grade1 = sysDictData.getDictValue();
                                    }
                                }
                                if (StringUtils.isEmpty(grade1)) {
                                    failureNum++;
                                    failureMsg.append("<br/>" + failureNum + "、年级输入错误,请您重新输入! ");
                                }else {
                                    schoolStudentAwardVo.setGrade(grade1);
                                    //判断班级是否正确
                                    String className = schoolStudentAwardVo.getClassName();
                                    //将所有中文逗号替换成英文逗号
                                    String newClassName = className.replaceAll("，", ",");
                                    String[] spl = newClassName.split(",");
                                    for (int i = 0; i < spl.length; i++) {
                                        if (!spl[i].matches("\\d+")){
                                            failureNum++;
                                            failureMsg.append("<br/>" + failureNum + "、班级输入错误,请您重新输入! ");
                                            break;
                                        }
                                    }
                                    schoolStudentAwardVo.setClassName(newClassName);

                                    //判断班级类型是否正确
                                    String classType1 = "";
                                    String classType = schoolStudentAwardVo.getClassType();
                                    //将所有中文逗号换成英文逗号
                                    String newClassType = classType.replaceAll("，", ",");
                                    String[] split1 = newClassType.split(",");
                                    for (String ctype : split1) {
                                        for (SysDictData sysDictData : type) {
                                            if (ctype.equals(sysDictData.getDictLabel())){
                                                classType1 += ctype;
                                            }
                                        }
                                    }
                                    if (StringUtils.isEmpty(classType1)){
                                        failureNum++;
                                        failureMsg.append("<br/>" + failureNum + "、班级类型输入错误,请您重新输入! ");
                                    }else {
                                        String idCard = "";
                                        if(schoolStudentAwardVo.getIdCard().length() == 18) {
                                            //校验前十七位是否为数字
                                            for (int i = 0; i < 17; i++) {
                                                if (!Character.isDigit(schoolStudentAwardVo.getIdCard().charAt(i))) {
                                                    failureNum++;
                                                    failureMsg.append("<br/>" + failureNum + "、身份证号输入错误,请您重新输入! ");
                                                    idCard += i;
                                                    break;
                                                }
                                            }
                                        }
                                        if (StringUtils.isEmpty(idCard)){
                                            //判断性别输入是否正确
                                            String sex1 = schoolStudentAwardVo.getSex();
                                            String sex2 = "";
                                            for (SysDictData sysDictData : sex) {
                                                if (sex1.equals(sysDictData.getDictLabel())){
                                                    sex2 = sysDictData.getDictValue();
                                                }
                                            }
                                            //判断嘉奖级别输入是否正确
                                            String awardRank = schoolStudentAwardVo.getAwardRank();
                                            String awardRank1 = "";
                                            for (SysDictData sysDictData : studentAwardRank) {
                                                if (awardRank.equals(sysDictData.getDictLabel())){
                                                    awardRank1 = sysDictData.getDictValue();
                                                }
                                            }
                                            if (StringUtils.isEmpty(sex2)){
                                                failureNum++;
                                                failureMsg.append("<br/>" + failureNum + "、性别输入错误,请您重新输入! ");
                                            }else if (StringUtils.isEmpty(awardRank1)){
                                                failureNum++;
                                                failureMsg.append("<br/>" + failureNum + "、嘉奖级别输入错误,请您重新输入! ");
                                            }else {
                                                schoolStudentAwardVo.setSex(sex2);
                                                schoolStudentAwardVo.setAwardRank(awardRank1);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "很抱歉，导入失败！共" + failureNum + "条数据格式不正确，错误如下：");
            throw new ServiceException(failureMsg.toString());
        }
    }

    /**
     * 导入数据
     * @param list
     * @return
     */
    @Override
    public String importExamDetail(List<SchoolStudentAwardVo> list) {
        StringBuilder successMsg = new StringBuilder();
        List<SchoolStudentAward> schoolStudentAwardList = new ArrayList<>();
        list.forEach(list1 ->{
            //转实体对象
            SchoolStudentAward schoolStudentAward = new SchoolStudentAward();
            BeanUtils.copyProperties(list1,schoolStudentAward);
            schoolStudentAwardList.add(schoolStudentAward);
        });
        if (schoolStudentAwardList.size() > 0){
            boolean b = saveBatch(schoolStudentAwardList);
            if (!b){
                throw new ServiceException("导入失败");
            }
        }
        successMsg.insert(0, "恭喜您，数据已导入成功！");
        return successMsg.toString();
    }

    /**
     * 查询已通过的学生嘉奖列表
     * @param schoolStudentAward
     * @return
     */
    @Override
    public List<SchoolStudentAward> selectSchoolStudentAwardListTg(SchoolStudentAward schoolStudentAward) {
        return schoolStudentAwardMapper.selectSchoolStudentAwardListTg(schoolStudentAward);
    }
}
