package yangtz.cs.liu.campus.service.impl.student;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.mapper.SysDictDataMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.mapper.student.SchoolStudentAchievementMapper;
import yangtz.cs.liu.campus.domain.student.SchoolStudentAchievement;
import yangtz.cs.liu.campus.service.student.ISchoolStudentAchievementService;
import yangtz.cs.liu.campus.vo.student.SchoolStudentAchievementVo;

/**
 * 学生成绩Service业务层处理
 *
 * @author ruoyi
 * @date 2024-01-08
 */
@Service
public class SchoolStudentAchievementServiceImpl extends ServiceImpl<SchoolStudentAchievementMapper,SchoolStudentAchievement> implements ISchoolStudentAchievementService
{
    @Autowired
    private SchoolStudentAchievementMapper schoolStudentAchievementMapper;
    @Autowired
    private SysDictDataMapper sysDictDataMapper;

    /**
     * 查询学生成绩
     *
     * @param id 学生成绩主键
     * @return 学生成绩
     */
    @Override
    public SchoolStudentAchievement selectSchoolStudentAchievementById(Long id)
    {
        return schoolStudentAchievementMapper.selectSchoolStudentAchievementById(id);
    }

    /**
     * 查询学生成绩列表
     *
     * @param schoolStudentAchievement 学生成绩
     * @return 学生成绩
     */
    @Override
    public List<SchoolStudentAchievement> selectSchoolStudentAchievementList(SchoolStudentAchievement schoolStudentAchievement)
    {
        return schoolStudentAchievementMapper.selectSchoolStudentAchievementList(schoolStudentAchievement);
    }

    /**
     * 新增学生成绩
     *
     * @param schoolStudentAchievement 学生成绩
     * @return 结果
     */
    @Override
    public int insertSchoolStudentAchievement(SchoolStudentAchievement schoolStudentAchievement)
    {
        schoolStudentAchievement.setCreateById(SecurityUtils.getUserId());
        schoolStudentAchievement.setCreateBy(SecurityUtils.getUsername());
        schoolStudentAchievement.setCreateTime(DateUtils.getNowDate());
        return schoolStudentAchievementMapper.insertSchoolStudentAchievement(schoolStudentAchievement);
    }

    /**
     * 修改学生成绩
     *
     * @param schoolStudentAchievement 学生成绩
     * @return 结果
     */
    @Override
    public int updateSchoolStudentAchievement(SchoolStudentAchievement schoolStudentAchievement)
    {
        schoolStudentAchievement.setUpdateById(SecurityUtils.getUserId());
        schoolStudentAchievement.setUpdateBy(SecurityUtils.getUsername());
        schoolStudentAchievement.setUpdateTime(DateUtils.getNowDate());
        return schoolStudentAchievementMapper.updateSchoolStudentAchievement(schoolStudentAchievement);
    }

    /**
     * 批量删除学生成绩
     *
     * @param ids 需要删除的学生成绩主键
     * @return 结果
     */
    @Override
    public int deleteSchoolStudentAchievementByIds(Long[] ids)
    {
        return schoolStudentAchievementMapper.deleteSchoolStudentAchievementByIds(ids);
    }

    /**
     * 删除学生成绩信息
     *
     * @param id 学生成绩主键
     * @return 结果
     */
    @Override
    public int deleteSchoolStudentAchievementById(Long id)
    {
        return schoolStudentAchievementMapper.deleteSchoolStudentAchievementById(id);
    }

    /**
     * 校验数据
     * @param list
     */
    @Override
    public void checkImport(List<SchoolStudentAchievementVo> list) {
        //检验是否为空
        if (StringUtils.isNull(list) || list.size() == 0) {
            throw new ServiceException("导入数据不能为空");
        }
        // 准备记录日志数据
        int failureNum = 0;
        StringBuilder failureMsg = new StringBuilder();
        //查询学期字典键值
        List<SysDictData> semester = sysDictDataMapper.selectDictDataByType("semester_jsdzda");
        //查询年级字典键值
        List<SysDictData> grade = sysDictDataMapper.selectDictDataByType("grade_da");
        //查询班级类型字典键值
        List<SysDictData> type = sysDictDataMapper.selectDictDataByType("class_type");
        List<SysDictData> examType = sysDictDataMapper.selectDictDataByType("exam_typeda");
        for (SchoolStudentAchievementVo schoolStudentAchievementVo : list) {
            if (StringUtils.isNull(schoolStudentAchievementVo.getSchoolYear())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、学年为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAchievementVo.getSemester())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、学期为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAchievementVo.getYear())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、届别为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAchievementVo.getGrade())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、年级为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAchievementVo.getClassName())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、班级为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAchievementVo.getClassType())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、班级类型为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAchievementVo.getName())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、姓名为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAchievementVo.getIdCard())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、身份证号为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAchievementVo.getExamType())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、考试类型为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolStudentAchievementVo.getClassTeacher())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、班主任为空,请您重新输入! ");
            } else {
                //判断学年输入是否正确
                String schoolYear = schoolStudentAchievementVo.getSchoolYear();
                if (!schoolYear.contains("-")){
                    failureNum++;
                    failureMsg.append("<br/>" + failureNum + "、学年输入格式错误,请您重新输入! ");
                }else {
                    String[] split = schoolYear.split("-");
                    if (split.length != 2) {
                        failureNum++;
                        failureMsg.append("<br/>" + failureNum + "、学年输入格式错误,请您重新输入! ");
                    } else if (!(split[0].matches("\\d+") && split[1].matches("\\d+"))) {
                        failureNum++;
                        failureMsg.append("<br/>" + failureNum + "、学年输入格式错误,请您重新输入! ");
                    } else {
                        //判断学期是否正确
                        String semester1 = "";
                        for (SysDictData sysDictData : semester) {
                            if (schoolStudentAchievementVo.getSemester().equals(sysDictData.getDictLabel())) {
                                semester1 = sysDictData.getDictValue();
                            }
                        }
                        if (StringUtils.isEmpty(semester1)) {
                            failureNum++;
                            failureMsg.append("<br/>" + failureNum + "、学期输入错误,请您重新输入! ");
                        } else {
                            schoolStudentAchievementVo.setSemester(semester1);

                            //判断届别是否正确
                            if (!schoolStudentAchievementVo.getYear().matches("\\d+")) {
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、届别输入错误,请您重新输入! ");
                            } else {
                                //判断年级是否正确
                                String grade1 = "";
                                for (SysDictData sysDictData : grade) {
                                    if (schoolStudentAchievementVo.getGrade().equals(sysDictData.getDictLabel())) {
                                        grade1 = sysDictData.getDictValue();
                                    }
                                }

                                if (StringUtils.isEmpty(grade1)) {
                                    failureNum++;
                                    failureMsg.append("<br/>" + failureNum + "、年级输入错误,请您重新输入! ");
                                } else {
                                    //判断班级是否正确
                                    String className = schoolStudentAchievementVo.getClassName();
                                    //将所有中文逗号替换成英文逗号
                                    String newClassName = className.replaceAll("，", ",");
                                    String[] spl = newClassName.split(",");
                                    for (int i = 0; i < spl.length; i++) {
                                        if (!spl[i].matches("\\d+")) {
                                            failureNum++;
                                            failureMsg.append("<br/>" + failureNum + "、班级输入错误,请您重新输入! ");
                                            break;
                                        }
                                    }
                                    schoolStudentAchievementVo.setClassName(newClassName);

                                    //判断班级类型是否正确
                                    String classType1 = "";
                                    String classType = schoolStudentAchievementVo.getClassType();
                                    //将所有中文逗号换成英文逗号
                                    String newClassType = classType.replaceAll("，", ",");
                                    String[] split1 = newClassType.split(",");
                                    for (String ctype : split1) {
                                        for (SysDictData sysDictData : type) {
                                            if (ctype.equals(sysDictData.getDictLabel())) {
                                                classType1 += ctype;
                                            }
                                        }
                                    }
                                    if (StringUtils.isEmpty(classType1)) {
                                        failureNum++;
                                        failureMsg.append("<br/>" + failureNum + "、班级类型输入错误,请您重新输入! ");
                                    } else {
                                        String idCard = "";
                                        if (schoolStudentAchievementVo.getIdCard().length() == 18) {
                                            //校验前十七位是否为数字
                                            for (int i = 0; i < 17; i++) {
                                                if (!Character.isDigit(schoolStudentAchievementVo.getIdCard().charAt(i))) {
                                                    failureNum++;
                                                    failureMsg.append("<br/>" + failureNum + "、身份证号输入错误,请您重新输入! ");
                                                    idCard += i;
                                                    break;
                                                }
                                            }
                                        }
                                        if (StringUtils.isEmpty(idCard)){
                                            //判断考试类型输入是否正确
                                            String examType1 = schoolStudentAchievementVo.getExamType();
                                            String examType2 = "";
                                            for (SysDictData sysDictData : examType) {
                                                if (examType1.equals(sysDictData.getDictLabel())){
                                                    examType2 = sysDictData.getDictValue();
                                                }
                                            }
                                            if (StringUtils.isEmpty(examType2)){
                                                failureNum++;
                                                failureMsg.append("<br/>" + failureNum + "、考试类型输入错误,请您重新输入! ");
                                            }else {
                                                schoolStudentAchievementVo.setExamType(examType2);
                                                //判断考试时间输入是否正确
                                                String examTime1 = schoolStudentAchievementVo.getExamTime1();
                                                try {
                                                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                                                    format.setLenient(false);
                                                    Date parse = format.parse(examTime1);
                                                    schoolStudentAchievementVo.setExamTime(parse);
                                                } catch (ParseException e) {
                                                    failureNum++;
                                                    failureMsg.append("<br/>" + failureNum + "、考试时间输入错误,请您重新输入! ");
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "很抱歉，导入失败！共" + failureNum + "条数据格式不正确，错误如下：");
            throw new ServiceException(failureMsg.toString());
        }
    }

    /**
     * 新增数据
     * @param list
     * @return
     */
    @Override
    public String importExamDetail(List<SchoolStudentAchievementVo> list) {
        StringBuilder successMsg = new StringBuilder();
        List<SchoolStudentAchievement> schoolStudentAchievements = new ArrayList<>();
        for (SchoolStudentAchievementVo schoolStudentAchievementVo : list) {
            //转实体对象
            SchoolStudentAchievement schoolStudentAchievement = new SchoolStudentAchievement();
            BeanUtils.copyProperties(schoolStudentAchievementVo,schoolStudentAchievement);
            schoolStudentAchievements.add(schoolStudentAchievement);
        }
        if (schoolStudentAchievements.size() > 0){
            boolean b = saveBatch(schoolStudentAchievements);
            if (!b){
                throw new ServiceException("导入失败");
            }
        }
        successMsg.insert(0, "恭喜您，数据已导入成功！");
        return successMsg.toString();
    }
}
