package yangtz.cs.liu.campus.service.impl.student;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.student.SchoolEducationRuleDetails;
import yangtz.cs.liu.campus.mapper.student.SchoolEducationRuleDetailsMapper;
import yangtz.cs.liu.campus.service.student.ISchoolEducationRuleDetailsService;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

@Service
public class SchoolEducationRuleDetailsServiceImpl extends ServiceImpl<SchoolEducationRuleDetailsMapper, SchoolEducationRuleDetails> implements ISchoolEducationRuleDetailsService {

    @Autowired
    private SchoolEducationRuleDetailsMapper schoolEducationRuleDetailsMapper;

    /**
     * 学校德育检查打分明细列表 列表
     *
     * @param schoolEducationRuleDetails
     * @return
     */
    @Override
    public List<SchoolEducationRuleDetails> queryList(SchoolEducationRuleDetails schoolEducationRuleDetails) {
        LambdaQueryWrapper<SchoolEducationRuleDetails> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolEducationRuleDetails::getRuleId, schoolEducationRuleDetails.getRuleId())
                .like(isNotBlank(schoolEducationRuleDetails.getContent()), SchoolEducationRuleDetails::getContent, schoolEducationRuleDetails.getContent())
                .orderByAsc(SchoolEducationRuleDetails::getSort)
        ;
        return schoolEducationRuleDetailsMapper.selectList(lqw);
    }
}
