package yangtz.cs.liu.campus.service.impl.schoolStudio;

import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolStudio.SchoolStudio;
import yangtz.cs.liu.campus.mapper.schoolStudio.SchoolStudioMapper;
import yangtz.cs.liu.campus.service.schoolStudio.ISchoolStudioService;

import java.util.List;

/**
 * 录播室管理Service业务层处理
 *
 * @author ruoyi
 * @date 2023-07-10
 */
@Service
public class SchoolStudioServiceImpl implements ISchoolStudioService
{
    @Autowired
    private SchoolStudioMapper schoolStudioMapper;

    /**
     * 查询录播室管理
     *
     * @param id 录播室管理主键
     * @return 录播室管理
     */
    @Override
    public SchoolStudio selectSchoolStudioById(Long id)
    {
        return schoolStudioMapper.selectSchoolStudioById(id);
    }

    /**
     * 查询录播室管理列表
     *
     * @param schoolStudio 录播室管理
     * @return 录播室管理
     */
    @Override
    public List<SchoolStudio> selectSchoolStudioList(SchoolStudio schoolStudio)
    {
        return schoolStudioMapper.selectSchoolStudioList(schoolStudio);
    }

    /**
     * 新增录播室管理
     *
     * @param schoolStudio 录播室管理
     * @return 结果
     */
    @Override
    public int insertSchoolStudio(SchoolStudio schoolStudio)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        schoolStudio.setCreateById(user.getUserId());
        schoolStudio.setCreateTime(DateUtils.getNowDate());
        return schoolStudioMapper.insertSchoolStudio(schoolStudio);
    }

    /**
     * 修改录播室管理
     *
     * @param schoolStudio 录播室管理
     * @return 结果
     */
    @Override
    public int updateSchoolStudio(SchoolStudio schoolStudio)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        schoolStudio.setUpdateById(user.getUserId());
        schoolStudio.setUpdateTime(DateUtils.getNowDate());
        return schoolStudioMapper.updateSchoolStudio(schoolStudio);
    }

    /**
     * 批量删除录播室管理
     *
     * @param ids 需要删除的录播室管理主键
     * @return 结果
     */
    @Override
    public int deleteSchoolStudioByIds(Long[] ids)
    {
        return schoolStudioMapper.deleteSchoolStudioByIds(ids);
    }
}
