package yangtz.cs.liu.campus.service.impl.schoolRewardsPunishments;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.domain.schoolRewardsPunishments.SchoolScAwards;
import yangtz.cs.liu.campus.mapper.schoolRewardsPunishments.SchoolScAwardsMapper;
import yangtz.cs.liu.campus.service.schoolRewardsPunishments.ISchoolScAwardsService;
import yangtz.cs.liu.campus.vo.schoolRewardsPunishments.SchoolScAwardsVo;

import java.util.ArrayList;
import java.util.List;

/**
 * 学校获奖Service业务层处理
 *
 * @author ruoyi
 * @date 2023-11-06
 */
@Service
public class SchoolScAwardsServiceImpl extends ServiceImpl<SchoolScAwardsMapper,SchoolScAwards> implements ISchoolScAwardsService
{
    @Autowired
    private SchoolScAwardsMapper schoolScAwardsMapper;

    /**
     * 查询学校获奖
     *
     * @param id 学校获奖主键
     * @return 学校获奖
     */
    @Override
    public SchoolScAwardsVo selectSchoolScAwardsById(Long id)
    {
        return schoolScAwardsMapper.selectSchoolScAwardsById(id);
    }

    /**
     * 查询学校获奖列表
     *
     * @param schoolScAwardsVo 学校获奖
     * @return 学校获奖
     */
    @Override
    public List<SchoolScAwardsVo> selectSchoolScAwardsList(SchoolScAwardsVo schoolScAwardsVo)
    {
        List<SchoolScAwardsVo> schoolScAwardsVos = schoolScAwardsMapper.selectSchoolScAwardsList(schoolScAwardsVo);
        //获取学校获奖所有附件
        List<SchoolAccessory> schoolAccessories = schoolScAwardsMapper.selectAccessoryList();
        for (SchoolScAwardsVo scAwardsVo : schoolScAwardsVos) {
            List<SchoolAccessory> schoolAccessoryList = new ArrayList<>();
            for (SchoolAccessory schoolAccessory : schoolAccessories) {
                if (schoolAccessory.getBusinessId().equals(scAwardsVo.getId())){
                    schoolAccessoryList.add(schoolAccessory);
                }
            }
            if (schoolAccessoryList.size() > 0){
                scAwardsVo.setSchoolAccessoryList(schoolAccessoryList);
            }
        }
        return schoolScAwardsVos;
    }

    /**
     * 查询学校获奖列表(查看已通过)
     *
     * @param schoolScAwardsVo 学校获奖
     * @return 学校获奖
     */
    @Override
    public List<SchoolScAwardsVo> selectSchoolScAwardsListTg(SchoolScAwardsVo schoolScAwardsVo)
    {
        List<SchoolScAwardsVo> schoolScAwardsVos = schoolScAwardsMapper.selectSchoolScAwardsListTg(schoolScAwardsVo);

        //获取学校获奖所有附件
        List<SchoolAccessory> schoolAccessories = schoolScAwardsMapper.selectAccessoryList();
        for (SchoolScAwardsVo scAwardsVo : schoolScAwardsVos) {
            List<SchoolAccessory> schoolAccessoryList = new ArrayList<>();
            for (SchoolAccessory schoolAccessory : schoolAccessories) {
                if (schoolAccessory.getBusinessId().equals(scAwardsVo.getId())){
                    schoolAccessoryList.add(schoolAccessory);
                }
            }
            if (schoolAccessoryList.size() > 0){
                scAwardsVo.setSchoolAccessoryList(schoolAccessoryList);
            }
        }
        return schoolScAwardsVos;
    }

    /**
     * 新增学校获奖
     *
     * @param schoolScAwardsVo 学校获奖
     * @return 结果
     */
    @Transactional
    @Override
    public int insertSchoolScAwards(SchoolScAwardsVo schoolScAwardsVo)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        schoolScAwardsVo.setApplyId(user.getUserId());
        schoolScAwardsVo.setApplyName(user.getUserName());
        schoolScAwardsVo.setApplyTime(DateUtils.getNowDate());
        schoolScAwardsVo.setCreateBy(user.getUserName());
        schoolScAwardsVo.setCreateTime(DateUtils.getNowDate());
        int i = schoolScAwardsMapper.insertSchoolScAwards(schoolScAwardsVo);
        insertSchoolAccessory(schoolScAwardsVo);
        return i;
    }

    /**
     * 修改学校获奖
     *
     * @param schoolScAwardsVo 学校获奖
     * @return 结果
     */
    @Transactional
    @Override
    public int updateSchoolScAwards(SchoolScAwardsVo schoolScAwardsVo)
    {
        schoolScAwardsVo.setUpdateBy(SecurityUtils.getUsername());
        schoolScAwardsVo.setUpdateTime(DateUtils.getNowDate());
        schoolScAwardsMapper.deleteSchoolAccessoryByBusinessId(schoolScAwardsVo.getId());
        insertSchoolAccessory(schoolScAwardsVo);
        return schoolScAwardsMapper.updateSchoolScAwards(schoolScAwardsVo);
    }

    /**
     * 批量删除学校获奖
     *
     * @param ids 需要删除的学校获奖主键
     * @return 结果
     */
    @Override
    public int deleteSchoolScAwardsByIds(Long[] ids)
    {
        //删除附件
        schoolScAwardsMapper.deleteSchoolAccessoryByBusinessIds(ids);
        return schoolScAwardsMapper.deleteSchoolScAwardsByIds(ids);
    }

    /**
     * 删除学校获奖信息
     *
     * @param id 学校获奖主键
     * @return 结果
     */
    @Override
    public int deleteSchoolScAwardsById(Long id)
    {
        return schoolScAwardsMapper.deleteSchoolScAwardsById(id);
    }

    /**
     * 提交
     * @param schoolScAwards
     * @return
     */
    @Override
    public int submit(SchoolScAwards schoolScAwards) {
        return schoolScAwardsMapper.updateById(schoolScAwards);
    }

    /**
     * 新增附件信息信息
     *
     * @param schoolScAwardsVo 学校获奖对象
     */
    public void insertSchoolAccessory(SchoolScAwardsVo schoolScAwardsVo)
    {
        List<SchoolAccessory> schoolAccessoryList = schoolScAwardsVo.getSchoolAccessoryList();
        Long id = schoolScAwardsVo.getId();
        if (StringUtils.isNotNull(schoolAccessoryList))
        {
            List<SchoolAccessory> list = new ArrayList<SchoolAccessory>();
            for (SchoolAccessory schoolAccessory : schoolAccessoryList)
            {
                schoolAccessory.setBusinessId(id);
                schoolAccessory.setModuleName("学校获奖");
                schoolAccessory.setAccessoryType("学校获奖附件");
                schoolAccessory.setCreateBy(SecurityUtils.getUsername());
                schoolAccessory.setCreateTime(DateUtils.getNowDate());
                list.add(schoolAccessory);
            }
            if (list.size() > 0)
            {
                schoolScAwardsMapper.batchSchoolAccessory(list);
            }
        }
    }
}
