package yangtz.cs.liu.campus.service.impl.schoolNewTeacherDzdn;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolGkAchievement;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteamAward;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteamAwardVo;
import yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn.SchoolGkAchievementMapper;
import yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn.SchoolXteamAwardMapper;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolGkAchievementService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXteamAwardService;

/**
 * 团队获奖Service业务层处理
 *
 * @author ruoyi
 * @date 2023-12-13
 */
@Service
public class SchoolXteamAwardServiceImpl  extends ServiceImpl<SchoolXteamAwardMapper, SchoolXteamAward> implements ISchoolXteamAwardService
{
    @Autowired
    private SchoolXteamAwardMapper schoolXteamAwardMapper;

    /**
     * 查询团队获奖
     *
     * @param id 团队获奖主键
     * @return 团队获奖
     */
    @Override
    public SchoolXteamAward selectSchoolXteamAwardById(Long id)
    {
        return schoolXteamAwardMapper.selectSchoolXteamAwardById(id);
    }

    /**
     * 查询团队获奖列表
     *
     * @param schoolXteamAwardVo 团队获奖
     * @return 团队获奖
     */
    @Override
    public List<SchoolXteamAward> selectSchoolXteamAwardList(SchoolXteamAwardVo schoolXteamAwardVo)
    {
        return schoolXteamAwardMapper.selectSchoolXteamAwardList(schoolXteamAwardVo);
    }

    @Override
    public List<SchoolXteamAwardVo> selectSchoolXteamAwardVoList(SchoolXteamAwardVo schoolXteamAwardVo)
    {
        return schoolXteamAwardMapper.selectSchoolXteamAwardVoList(schoolXteamAwardVo);
    }

    /**
     * 新增团队获奖
     *
     * @param schoolXteamAward 团队获奖
     * @return 结果
     */
    @Override
    public int insertSchoolXteamAward(SchoolXteamAward schoolXteamAward)
    {
        schoolXteamAward.setCreateTime(DateUtils.getNowDate());
        return schoolXteamAwardMapper.insertSchoolXteamAward(schoolXteamAward);
    }

    /**
     * 修改团队获奖
     *
     * @param schoolXteamAward 团队获奖
     * @return 结果
     */
    @Override
    public int updateSchoolXteamAward(SchoolXteamAward schoolXteamAward)
    {
        schoolXteamAward.setUpdateTime(DateUtils.getNowDate());
        return schoolXteamAwardMapper.updateSchoolXteamAward(schoolXteamAward);
    }

    /**
     * 批量删除团队获奖
     *
     * @param ids 需要删除的团队获奖主键
     * @return 结果
     */
    @Override
    public int deleteSchoolXteamAwardByIds(Long[] ids)
    {
        return schoolXteamAwardMapper.deleteSchoolXteamAwardByIds(ids);
    }

    /**
     * 删除团队获奖信息
     *
     * @param id 团队获奖主键
     * @return 结果
     */
    @Override
    public int deleteSchoolXteamAwardById(Long id)
    {
        return schoolXteamAwardMapper.deleteSchoolXteamAwardById(id);
    }
}
