package yangtz.cs.liu.campus.service.impl.schoolNewTeacherDzdn;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteacherAwards;
import yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn.SchoolXteacherAwardsMapper;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXteacherAwardsService;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXteacherAwardsVo;

/**
 * 教师获奖Service业务层处理
 *
 * @author ruoyi
 * @date 2023-12-06
 */
@Service
public class SchoolXteacherAwardsServiceImpl implements ISchoolXteacherAwardsService
{
    @Autowired
    private SchoolXteacherAwardsMapper schoolXteacherAwardsMapper;

    /**
     * 查询教师获奖
     *
     * @param id 教师获奖主键
     * @return 教师获奖
     */
    @Override
    public SchoolXteacherAwardsVo selectSchoolXteacherAwardsById(Long id)
    {
        return schoolXteacherAwardsMapper.selectSchoolXteacherAwardsById(id);
    }

    /**
     * 查询教师获奖列表
     *
     * @param schoolXteacherAwardsVo 教师获奖
     * @return 教师获奖
     */
    @Override
    public List<SchoolXteacherAwardsVo> selectSchoolXteacherAwardsList(SchoolXteacherAwardsVo schoolXteacherAwardsVo)
    {
        return schoolXteacherAwardsMapper.selectSchoolXteacherAwardsList(schoolXteacherAwardsVo);
    }

    /**
     * 新增教师获奖
     *
     * @param schoolXteacherAwards 教师获奖
     * @return 结果
     */
    @Override
    @Transactional
    public int insertSchoolXteacherAwards(SchoolXteacherAwards schoolXteacherAwards)
    {
        schoolXteacherAwards.setCreateBy(SecurityUtils.getUsername());
        schoolXteacherAwards.setCreateTime(DateUtils.getNowDate());
        return schoolXteacherAwardsMapper.insertSchoolXteacherAwards(schoolXteacherAwards);
    }

    /**
     * 修改教师获奖
     *
     * @param schoolXteacherAwards 教师获奖
     * @return 结果
     */
    @Override
    @Transactional
    public int updateSchoolXteacherAwards(SchoolXteacherAwards schoolXteacherAwards)
    {
        schoolXteacherAwards.setUpdateBy(SecurityUtils.getUsername());
        schoolXteacherAwards.setUpdateTime(DateUtils.getNowDate());
        return schoolXteacherAwardsMapper.updateSchoolXteacherAwards(schoolXteacherAwards);
    }

    /**
     * 批量删除教师获奖
     *
     * @param ids 需要删除的教师获奖主键
     * @return 结果
     */
    @Override
    public int deleteSchoolXteacherAwardsByIds(Long[] ids)
    {
        return schoolXteacherAwardsMapper.deleteSchoolXteacherAwardsByIds(ids);
    }

    /**
     * 删除教师获奖信息
     *
     * @param id 教师获奖主键
     * @return 结果
     */
    @Override
    public int deleteSchoolXteacherAwardsById(Long id)
    {
        return schoolXteacherAwardsMapper.deleteSchoolXteacherAwardsById(id);
    }

    /**
     * 审核
     * @param schoolXteacherAwards
     * @return
     */
    @Override
    public int audit(SchoolXteacherAwards schoolXteacherAwards) {
        return schoolXteacherAwardsMapper.updateSchoolXteacherAwards(schoolXteacherAwards);
    }
}
