package yangtz.cs.liu.campus.service.impl.schoolNewTeacherDzdn;

import java.util.ArrayList;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.mapper.SysDictDataMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolTeacherBasicInformation;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteachingAchievements;
import yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn.SchoolTeacherBasichlnformationMapper;
import yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn.SchoolXsyouthTeacherMapper;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXsyouthTeacher;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXsyouthTeacherService;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXsyouthTeacherDrVo;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXsyouthTeacherVo;

/**
 * 青年教师成长档案Service业务层处理
 *
 * @author ruoyi
 * @date 2024-01-29
 */
@Service
public class SchoolXsyouthTeacherServiceImpl extends ServiceImpl<SchoolXsyouthTeacherMapper,SchoolXsyouthTeacher> implements ISchoolXsyouthTeacherService
{
    @Autowired
    private SchoolXsyouthTeacherMapper schoolXsyouthTeacherMapper;
    @Autowired
    private SysDictDataMapper sysDictDataMapper;
    @Autowired
    private SchoolTeacherBasichlnformationMapper schoolTeacherBasichlnformationMapper;

    /**
     * 查询青年教师成长档案
     *
     * @param id 青年教师成长档案主键
     * @return 青年教师成长档案
     */
    @Override
    public SchoolXsyouthTeacher selectSchoolXsyouthTeacherById(Long id)
    {
        return schoolXsyouthTeacherMapper.selectSchoolXsyouthTeacherById(id);
    }

    /**
     * 查询青年教师成长档案列表
     *
     * @param schoolXsyouthTeacherVo 青年教师成长档案
     * @return 青年教师成长档案
     */
    @Override
    public List<SchoolXsyouthTeacher> selectSchoolXsyouthTeacherList(SchoolXsyouthTeacherVo schoolXsyouthTeacherVo)
    {
        return schoolXsyouthTeacherMapper.selectSchoolXsyouthTeacherList(schoolXsyouthTeacherVo);
    }

    /**
     * 新增青年教师成长档案
     *
     * @param schoolXsyouthTeacher 青年教师成长档案
     * @return 结果
     */
    @Override
    public int insertSchoolXsyouthTeacher(SchoolXsyouthTeacher schoolXsyouthTeacher)
    {
        //判断是否重复添加
        String idCard = schoolXsyouthTeacher.getIdCard();
//        LambdaQueryWrapper<SchoolTeacherBasicInformation> wrapper = new LambdaQueryWrapper<>();
//        wrapper.eq(SchoolTeacherBasicInformation::getIdCard,idCard);
//        SchoolTeacherBasicInformation schoolTeacherBasicInformation = schoolTeacherBasichlnformationMapper.selectOne(wrapper);
//        if (!schoolTeacherBasicInformation.getName().equals(schoolXsyouthTeacher.getName())){
//            throw new ServiceException("身份证号重复，请重新录入！");
//        }
        SchoolXsyouthTeacherVo schoolXsyouthTeacher1 = new SchoolXsyouthTeacherVo();
//        schoolXsyouthTeacher1.setName(schoolXsyouthTeacher.getName());
        schoolXsyouthTeacher1.setIdCard(idCard);
        List<SchoolXsyouthTeacher> schoolXsyouthTeachers = selectSchoolXsyouthTeacherList(schoolXsyouthTeacher1);
        if (schoolXsyouthTeachers.size() > 0){
            throw new ServiceException("已存在该教师！");
        }
        //判断青年教师培养期格式是否正确
        String incubationPeriod = schoolXsyouthTeacher.getIncubationPeriod();
        String[] split = incubationPeriod.split("-");
        if (!incubationPeriod.contains("-") || split.length != 2){
            throw new ServiceException("青年教师培养期输入格式错误！例如：2023-2024");
        }
        if (!(split[0].matches("\\d+") && split[1].matches("\\d+"))){
            throw new ServiceException("青年教师培养期输入格式错误！例如：2023-2024");
        }else {
            if (split[0].length() != 4 || split[1].length() != 4){
                throw new ServiceException("青年教师培养期输入格式错误！例如：2023-2024");
            }
        }
        //班级输入是否正确
        String className = schoolXsyouthTeacher.getClassName();
        String newClassName = className.replaceAll("，", ",");
        schoolXsyouthTeacher.setClassName(newClassName);
        schoolXsyouthTeacher.setCreateBy(SecurityUtils.getUsername());
        schoolXsyouthTeacher.setCreateTime(DateUtils.getNowDate());
        return schoolXsyouthTeacherMapper.insertSchoolXsyouthTeacher(schoolXsyouthTeacher);
    }

    /**
     * 修改青年教师成长档案
     *
     * @param schoolXsyouthTeacher 青年教师成长档案
     * @return 结果
     */
    @Override
    public int updateSchoolXsyouthTeacher(SchoolXsyouthTeacher schoolXsyouthTeacher)
    {
        //判断是否重复添加
        String idCard = schoolXsyouthTeacher.getIdCard();
//        LambdaQueryWrapper<SchoolTeacherBasicInformation> wrapper = new LambdaQueryWrapper<>();
//        wrapper.eq(SchoolTeacherBasicInformation::getIdCard,idCard);
//        SchoolTeacherBasicInformation schoolTeacherBasicInformation = schoolTeacherBasichlnformationMapper.selectOne(wrapper);
//        if (!schoolTeacherBasicInformation.getName().equals(schoolXsyouthTeacher.getName())){
//            throw new ServiceException("身份证号重复，请重新录入！");
//        }
        SchoolXsyouthTeacherVo schoolXsyouthTeacher1 = new SchoolXsyouthTeacherVo();
//        schoolXsyouthTeacher1.setName(schoolXsyouthTeacher.getName());
        schoolXsyouthTeacher1.setIdCard(idCard);
        List<SchoolXsyouthTeacher> schoolXsyouthTeachers = selectSchoolXsyouthTeacherList(schoolXsyouthTeacher1);
        if (schoolXsyouthTeachers.size() == 1){
            if (!schoolXsyouthTeachers.get(0).getId().equals(schoolXsyouthTeacher.getId())){
                throw new ServiceException("已存在该教师！");
            }
        }else {
            throw new ServiceException("系统错误，请联系管理员！");
        }
        //判断青年教师培养期格式是否正确
        String incubationPeriod = schoolXsyouthTeacher.getIncubationPeriod();
        String[] split = incubationPeriod.split("-");
        if (!incubationPeriod.contains("-") || split.length != 2){
            throw new ServiceException("青年教师培养期输入格式错误！例如：2023-2024");
        }
        if (!(split[0].matches("\\d+") && split[1].matches("\\d+"))){
            throw new ServiceException("青年教师培养期输入格式错误！例如：2023-2024");
        }else {
            if (split[0].length() != 4 || split[1].length() != 4){
                throw new ServiceException("青年教师培养期输入格式错误！例如：2023-2024");
            }
        }
        //班级输入是否正确
        String className = schoolXsyouthTeacher.getClassName();
        String newClassName = className.replaceAll("，", ",");
        schoolXsyouthTeacher.setClassName(newClassName);
        schoolXsyouthTeacher.setUpdateBy(SecurityUtils.getUsername());
        schoolXsyouthTeacher.setUpdateTime(DateUtils.getNowDate());
        return schoolXsyouthTeacherMapper.updateSchoolXsyouthTeacher(schoolXsyouthTeacher);
    }

    /**
     * 批量删除青年教师成长档案
     *
     * @param ids 需要删除的青年教师成长档案主键
     * @return 结果
     */
    @Override
    public int deleteSchoolXsyouthTeacherByIds(Long[] ids)
    {
        return schoolXsyouthTeacherMapper.deleteSchoolXsyouthTeacherByIds(ids);
    }

    /**
     * 删除青年教师成长档案信息
     *
     * @param id 青年教师成长档案主键
     * @return 结果
     */
    @Override
    public int deleteSchoolXsyouthTeacherById(Long id)
    {
        return schoolXsyouthTeacherMapper.deleteSchoolXsyouthTeacherById(id);
    }

    /**
     * 校验数据
     * @param list
     */
    @Override
    public void checkImport(List<SchoolXsyouthTeacherDrVo> list) {
        //检验是否为空
        if (StringUtils.isNull(list) || list.size() == 0) {
            throw new ServiceException("导入数据不能为空");
        }
        //查询学期字典键值
        List<SysDictData> semester = sysDictDataMapper.selectDictDataByType("semester_jsdzda");
        //查询年级字典键值
        List<SysDictData> grade = sysDictDataMapper.selectDictDataByType("grade_da");
        //查询学科字典键值
        List<SysDictData> sub = sysDictDataMapper.selectDictDataByType("sub_dzdn");
        // 准备记录日志数据
        int failureNum = 0;
        StringBuilder failureMsg = new StringBuilder();
        for (SchoolXsyouthTeacherDrVo schoolXsyouthTeacherDrVo : list) {
            if (StringUtils.isNull(schoolXsyouthTeacherDrVo.getSchoolYear())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、学年为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolXsyouthTeacherDrVo.getSemester())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、学期为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolXsyouthTeacherDrVo.getYear())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、届别为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolXsyouthTeacherDrVo.getGrade())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、年级为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolXsyouthTeacherDrVo.getSub())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、学科为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolXsyouthTeacherDrVo.getClassName())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、班级为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolXsyouthTeacherDrVo.getName())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、姓名为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolXsyouthTeacherDrVo.getIdCard())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、身份证号为空,请您重新输入! ");
            } else if (StringUtils.isEmpty(schoolXsyouthTeacherDrVo.getIncubationPeriod())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、青年教师培养期为空,请您重新输入! ");
            } else {
                //判断是否身份证号是否存在
                String idCard = schoolXsyouthTeacherDrVo.getIdCard();
                SchoolXsyouthTeacherVo schoolXsyouthTeacherVo = new SchoolXsyouthTeacherVo();
                schoolXsyouthTeacherVo.setIdCard(idCard);
                List<SchoolXsyouthTeacher> schoolXsyouthTeachers = schoolXsyouthTeacherMapper.selectSchoolXsyouthTeacherList(schoolXsyouthTeacherVo);
                if (schoolXsyouthTeachers.size() > 0){
                    failureNum++;
                    failureMsg.append("<br/>" + failureNum + "、身份证号为" + idCard + "的教师已存在,请您重新输入! ");
                }else {
                    //判断学年输入是否正确
                    String schoolYear = schoolXsyouthTeacherDrVo.getSchoolYear();
                    if (!schoolYear.contains("-")){
                        failureNum++;
                        failureMsg.append("<br/>" + failureNum + "、学年输入格式错误,请您重新输入! ");
                    }else {
                        String[] split = schoolYear.split("-");
                        if (split.length != 2){
                            failureNum++;
                            failureMsg.append("<br/>" + failureNum + "、学年输入格式错误,请您重新输入! ");
                        } else if (!(split[0].matches("\\d+") && split[1].matches("\\d+"))){
                            failureNum++;
                            failureMsg.append("<br/>" + failureNum + "、学年输入格式错误,请您重新输入! ");
                        }else {
                            //判断学期是否正确
                            String semester1 = "";
                            for (SysDictData sysDictData : semester) {
                                if (schoolXsyouthTeacherDrVo.getSemester().equals(sysDictData.getDictLabel())){
                                    semester1 = sysDictData.getDictValue();
                                }
                            }
                            if (StringUtils.isEmpty(semester1)){
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、学期输入错误,请您重新输入! ");
                            }else {
                                schoolXsyouthTeacherDrVo.setSemester(semester1);

                                //判断届别是否正确
                                if (!schoolXsyouthTeacherDrVo.getYear().matches("\\d+")){
                                    failureNum++;
                                    failureMsg.append("<br/>" + failureNum + "、届别输入错误,请您重新输入! ");
                                }else {
                                    //判断年级是否正确
                                    String grade1 = "";
                                    for (SysDictData sysDictData : grade) {
                                        if (schoolXsyouthTeacherDrVo.getGrade().equals(sysDictData.getDictLabel())){
                                            grade1 = sysDictData.getDictValue();
                                        }
                                    }

                                    //判断学科是否正确
                                    String sub1 = "";
                                    for (SysDictData sysDictData : sub) {
                                        if (schoolXsyouthTeacherDrVo.getSub().equals(sysDictData.getDictLabel())){
                                            sub1 = sysDictData.getDictValue();
                                        }
                                    }

                                    if (StringUtils.isEmpty(grade1)){
                                        failureNum++;
                                        failureMsg.append("<br/>" + failureNum + "、年级输入错误,请您重新输入! ");
                                    }else if (StringUtils.isEmpty(sub1)){
                                        failureNum++;
                                        failureMsg.append("<br/>" + failureNum + "、学科输入错误,请您重新输入! ");
                                    }else {
                                        schoolXsyouthTeacherDrVo.setGrade(grade1);
                                        schoolXsyouthTeacherDrVo.setSub(sub1);
                                        //判断班级是否正确
                                        String className = schoolXsyouthTeacherDrVo.getClassName();
                                        //将所有中文逗号替换成英文逗号
                                        String newClassName = className.replaceAll("，", ",");
                                        String[] spl = newClassName.split(",");
                                        for (int i = 0; i < spl.length; i++) {
                                            if (!spl[i].matches("\\d+")){
                                                failureNum++;
                                                failureMsg.append("<br/>" + failureNum + "、班级输入错误,请您重新输入! ");
                                                break;
                                            }
                                        }
                                        schoolXsyouthTeacherDrVo.setClassName(newClassName);

                                        //校验前十七位是否为数字
                                        for (int i = 0; i < 17; i++) {
                                            if (!Character.isDigit(schoolXsyouthTeacherDrVo.getIdCard().charAt(i))){
                                                failureNum++;
                                                failureMsg.append("<br/>" + failureNum + "、身份证号输入错误,请您重新输入! ");
                                                break;
                                            }
                                        }

                                        //判断青年教师培养期输入是否正确
                                        String incubationPeriod = schoolXsyouthTeacherDrVo.getIncubationPeriod();
                                        if (!incubationPeriod.contains("-")){
                                            failureNum++;
                                            failureMsg.append("<br/>" + failureNum + "、青年教师培养期输入格式错误,请您重新输入! ");
                                        }else {
                                            String[] split1 = incubationPeriod.split("-");
                                            if (split1.length != 2) {
                                                failureNum++;
                                                failureMsg.append("<br/>" + failureNum + "、青年教师培养期输入格式错误,请您重新输入! ");
                                            } else if (!(split1[0].matches("\\d+") && split1[1].matches("\\d+"))) {
                                                failureNum++;
                                                failureMsg.append("<br/>" + failureNum + "、青年教师培养期输入格式错误,请您重新输入! ");
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "很抱歉，导入失败！共" + failureNum + "条数据格式不正确，错误如下：");
            throw new ServiceException(failureMsg.toString());
        }
    }

    /**
     * 导入数据
     * @param list
     * @return
     */
    @Override
    public String importData(List<SchoolXsyouthTeacherDrVo> list) {
        StringBuilder successMsg = new StringBuilder();
        //批量导入年度考核数据
        List<SchoolXsyouthTeacher> list1 = new ArrayList<>();
        for (SchoolXsyouthTeacherDrVo schoolXsyouthTeacherDrVo : list) {
            //转实体对象
            SchoolXsyouthTeacher schoolXsyouthTeacher = new SchoolXsyouthTeacher();
            BeanUtils.copyProperties(schoolXsyouthTeacherDrVo,schoolXsyouthTeacher);
            list1.add(schoolXsyouthTeacher);
        }
        boolean b = saveBatch(list1);
        if (!b){
            throw new ServiceException("导入失败");
        }
        successMsg.insert(0, "恭喜您，数据已导入成功！");
        return successMsg.toString();
    }
}
