package yangtz.cs.liu.campus.service.impl.schoolNewTeacherDzdn;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXprojectResearch;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXteacherAwards;
import yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn.SchoolXprojectResearchMapper;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXprojectResearchService;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXprojectResearchVo;

import java.util.List;

/**
 * 课题研究Service业务层处理
 *
 * @author ruoyi
 * @date 2023-12-13
 */
@Service
public class SchoolXprojectResearchServiceImpl extends ServiceImpl<SchoolXprojectResearchMapper,SchoolXprojectResearch> implements ISchoolXprojectResearchService {

    @Autowired
    private SchoolXprojectResearchMapper schoolXprojectResearchMapper;

    /**
     * 查询课题研究
     *
     * @param id 课题研究主键
     * @return 课题研究
     */
    @Override
    public SchoolXprojectResearchVo selectSchoolXprojectResearchById(Long id)
    {
        return schoolXprojectResearchMapper.selectSchoolXprojectResearchById(id);
    }

    /**
     * 查询课题研究列表
     *
     * @param schoolXprojectResearchVo 课题研究
     * @return 课题研究
     */
    @Override
    public List<SchoolXprojectResearchVo> selectSchoolXprojectResearchList(SchoolXprojectResearchVo schoolXprojectResearchVo)
    {
        return schoolXprojectResearchMapper.selectSchoolXprojectResearchList(schoolXprojectResearchVo);
    }

    /**
     * 新增课题研究
     *
     * @param schoolXprojectResearch 课题研究
     * @return 结果
     */
    @Override
    public int insertSchoolXprojectResearch(SchoolXprojectResearch schoolXprojectResearch)
    {
        schoolXprojectResearch.setCreateBy(SecurityUtils.getUsername());
        schoolXprojectResearch.setCreateTime(DateUtils.getNowDate());
        return schoolXprojectResearchMapper.insertSchoolXprojectResearch(schoolXprojectResearch);
    }

    /**
     * 修改课题研究
     *
     * @param schoolXprojectResearch 课题研究
     * @return 结果
     */
    @Override
    public int updateSchoolXprojectResearch(SchoolXprojectResearch schoolXprojectResearch)
    {
        schoolXprojectResearch.setUpdateBy(SecurityUtils.getUsername());
        schoolXprojectResearch.setUpdateTime(DateUtils.getNowDate());
        return schoolXprojectResearchMapper.updateSchoolXprojectResearch(schoolXprojectResearch);
    }

    /**
     * 批量删除课题研究
     *
     * @param ids 需要删除的课题研究主键
     * @return 结果
     */
    @Override
    public int deleteSchoolXprojectResearchByIds(Long[] ids)
    {
        return schoolXprojectResearchMapper.deleteSchoolXprojectResearchByIds(ids);
    }

    /**
     * 删除课题研究信息
     *
     * @param id 课题研究主键
     * @return 结果
     */
    @Override
    public int deleteSchoolXprojectResearchById(Long id)
    {
        return schoolXprojectResearchMapper.deleteSchoolXprojectResearchById(id);
    }

    /**
     * 审核
     * @param schoolXprojectResearch
     * @return
     */
    @Override
    public int audit(SchoolXprojectResearch schoolXprojectResearch) {
        return schoolXprojectResearchMapper.updateSchoolXprojectResearch(schoolXprojectResearch);
    }
}
