package yangtz.cs.liu.campus.service.impl.schoolNewTeacherDzdn;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXlectureAwards;
import yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn.SchoolXlectureAwardsMapper;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXlectureAwardsService;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXlectureAwardsVo;

/**
 * 讲课获奖Service业务层处理
 *
 * @author ruoyi
 * @date 2023-12-06
 */
@Service
public class SchoolXlectureAwardsServiceImpl implements ISchoolXlectureAwardsService
{
    @Autowired
    private SchoolXlectureAwardsMapper schoolXlectureAwardsMapper;

    /**
     * 查询讲课获奖
     *
     * @param id 讲课获奖主键
     * @return 讲课获奖
     */
    @Override
    public SchoolXlectureAwardsVo selectSchoolXlectureAwardsById(Long id)
    {
        return schoolXlectureAwardsMapper.selectSchoolXlectureAwardsById(id);
    }

    /**
     * 查询讲课获奖列表
     *
     * @param schoolXlectureAwardsVo 讲课获奖
     * @return 讲课获奖
     */
    @Override
    public List<SchoolXlectureAwardsVo> selectSchoolXlectureAwardsList(SchoolXlectureAwardsVo schoolXlectureAwardsVo)
    {
        return schoolXlectureAwardsMapper.selectSchoolXlectureAwardsList(schoolXlectureAwardsVo);
    }

    /**
     * 新增讲课获奖
     *
     * @param schoolXlectureAwards 讲课获奖
     * @return 结果
     */
    @Override
    @Transactional
    public int insertSchoolXlectureAwards(SchoolXlectureAwards schoolXlectureAwards)
    {
        schoolXlectureAwards.setCreateBy(SecurityUtils.getUsername());
        schoolXlectureAwards.setCreateTime(DateUtils.getNowDate());
        return schoolXlectureAwardsMapper.insertSchoolXlectureAwards(schoolXlectureAwards);
    }

    /**
     * 修改讲课获奖
     *
     * @param schoolXlectureAwards 讲课获奖
     * @return 结果
     */
    @Override
    @Transactional
    public int updateSchoolXlectureAwards(SchoolXlectureAwards schoolXlectureAwards)
    {
        schoolXlectureAwards.setUpdateBy(SecurityUtils.getUsername());
        schoolXlectureAwards.setUpdateTime(DateUtils.getNowDate());
        return schoolXlectureAwardsMapper.updateSchoolXlectureAwards(schoolXlectureAwards);
    }

    /**
     * 批量删除讲课获奖
     *
     * @param ids 需要删除的讲课获奖主键
     * @return 结果
     */
    @Override
    public int deleteSchoolXlectureAwardsByIds(Long[] ids)
    {
        return schoolXlectureAwardsMapper.deleteSchoolXlectureAwardsByIds(ids);
    }

    /**
     * 删除讲课获奖信息
     *
     * @param id 讲课获奖主键
     * @return 结果
     */
    @Override
    public int deleteSchoolXlectureAwardsById(Long id)
    {
        return schoolXlectureAwardsMapper.deleteSchoolXlectureAwardsById(id);
    }

    /**
     * 审核
     * @param schoolXlectureAwards
     * @return
     */
    @Override
    public int audit(SchoolXlectureAwards schoolXlectureAwards) {
        return schoolXlectureAwardsMapper.updateSchoolXlectureAwards(schoolXlectureAwards);
    }
}
