package yangtz.cs.liu.campus.service.impl.schoolNewTeacherDzdn;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXcomprehensiveHonors;
import yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn.SchoolXcomprehensiveHonorsMapper;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXcomprehensiveHonorsService;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXcomprehensiveHonorsVo;

/**
 * 综合荣誉Service业务层处理
 *
 * @author ruoyi
 * @date 2023-12-06
 */
@Service
public class SchoolXcomprehensiveHonorsServiceImpl implements ISchoolXcomprehensiveHonorsService
{
    @Autowired
    private SchoolXcomprehensiveHonorsMapper schoolXcomprehensiveHonorsMapper;

    /**
     * 查询综合荣誉
     *
     * @param id 综合荣誉主键
     * @return 综合荣誉
     */
    @Override
    public SchoolXcomprehensiveHonorsVo selectSchoolXcomprehensiveHonorsById(Long id)
    {
        return schoolXcomprehensiveHonorsMapper.selectSchoolXcomprehensiveHonorsById(id);
    }

    /**
     * 查询综合荣誉列表
     *
     * @param schoolXcomprehensiveHonorsVo 综合荣誉
     * @return 综合荣誉
     */
    @Override
    public List<SchoolXcomprehensiveHonorsVo> selectSchoolXcomprehensiveHonorsList(SchoolXcomprehensiveHonorsVo schoolXcomprehensiveHonorsVo)
    {
        return schoolXcomprehensiveHonorsMapper.selectSchoolXcomprehensiveHonorsList(schoolXcomprehensiveHonorsVo);
    }

    /**
     * 新增综合荣誉
     *
     * @param schoolXcomprehensiveHonors 综合荣誉
     * @return 结果
     */
    @Override
    public int insertSchoolXcomprehensiveHonors(SchoolXcomprehensiveHonors schoolXcomprehensiveHonors)
    {
        schoolXcomprehensiveHonors.setCreateBy(SecurityUtils.getUsername());
        schoolXcomprehensiveHonors.setCreateTime(DateUtils.getNowDate());
        return schoolXcomprehensiveHonorsMapper.insertSchoolXcomprehensiveHonors(schoolXcomprehensiveHonors);
    }

    /**
     * 修改综合荣誉
     *
     * @param schoolXcomprehensiveHonors 综合荣誉
     * @return 结果
     */
    @Override
    public int updateSchoolXcomprehensiveHonors(SchoolXcomprehensiveHonors schoolXcomprehensiveHonors)
    {
        schoolXcomprehensiveHonors.setUpdateBy(SecurityUtils.getUsername());
        schoolXcomprehensiveHonors.setUpdateTime(DateUtils.getNowDate());
        return schoolXcomprehensiveHonorsMapper.updateSchoolXcomprehensiveHonors(schoolXcomprehensiveHonors);
    }

    /**
     * 批量删除综合荣誉
     *
     * @param ids 需要删除的综合荣誉主键
     * @return 结果
     */
    @Override
    public int deleteSchoolXcomprehensiveHonorsByIds(Long[] ids)
    {
        return schoolXcomprehensiveHonorsMapper.deleteSchoolXcomprehensiveHonorsByIds(ids);
    }

    /**
     * 删除综合荣誉信息
     *
     * @param id 综合荣誉主键
     * @return 结果
     */
    @Override
    public int deleteSchoolXcomprehensiveHonorsById(Long id)
    {
        return schoolXcomprehensiveHonorsMapper.deleteSchoolXcomprehensiveHonorsById(id);
    }

    /**
     * 审核
     * @param schoolXcomprehensiveHonors
     * @return
     */
    @Override
    public int audit(SchoolXcomprehensiveHonors schoolXcomprehensiveHonors) {
        return schoolXcomprehensiveHonorsMapper.updateSchoolXcomprehensiveHonors(schoolXcomprehensiveHonors);
    }
}
