package yangtz.cs.liu.campus.service.impl.schoolNewTeacherDzdn;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolXacademicWorks;
import yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn.SchoolXacademicWorksMapper;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXacademicWorksService;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXacademicWorksVo;

/**
 * 论文著作Service业务层处理
 *
 * @author ruoyi
 * @date 2023-12-06
 */
@Service
public class SchoolXacademicWorksServiceImpl implements ISchoolXacademicWorksService
{
    @Autowired
    private SchoolXacademicWorksMapper schoolXacademicWorksMapper;

    /**
     * 查询论文著作
     *
     * @param id 论文著作主键
     * @return 论文著作
     */
    @Override
    public SchoolXacademicWorksVo selectSchoolXacademicWorksById(Long id)
    {
        return schoolXacademicWorksMapper.selectSchoolXacademicWorksById(id);
    }

    /**
     * 查询论文著作列表
     *
     * @param schoolXacademicWorksVo 论文著作
     * @return 论文著作
     */
    @Override
    public List<SchoolXacademicWorksVo> selectSchoolXacademicWorksList(SchoolXacademicWorksVo schoolXacademicWorksVo)
    {
        return schoolXacademicWorksMapper.selectSchoolXacademicWorksList(schoolXacademicWorksVo);
    }

    /**
     * 新增论文著作
     *
     * @param schoolXacademicWorks 论文著作
     * @return 结果
     */
    @Override
    @Transactional
    public int insertSchoolXacademicWorks(SchoolXacademicWorks schoolXacademicWorks)
    {
        schoolXacademicWorks.setCreateBy(SecurityUtils.getUsername());
        schoolXacademicWorks.setCreateTime(DateUtils.getNowDate());
        return schoolXacademicWorksMapper.insertSchoolXacademicWorks(schoolXacademicWorks);
    }

    /**
     * 修改论文著作
     *
     * @param schoolXacademicWorks 论文著作
     * @return 结果
     */
    @Override
    @Transactional
    public int updateSchoolXacademicWorks(SchoolXacademicWorks schoolXacademicWorks)
    {
        schoolXacademicWorks.setUpdateBy(SecurityUtils.getUsername());
        schoolXacademicWorks.setUpdateTime(DateUtils.getNowDate());
        return schoolXacademicWorksMapper.updateSchoolXacademicWorks(schoolXacademicWorks);
    }

    /**
     * 批量删除论文著作
     *
     * @param ids 需要删除的论文著作主键
     * @return 结果
     */
    @Override
    public int deleteSchoolXacademicWorksByIds(Long[] ids)
    {
        return schoolXacademicWorksMapper.deleteSchoolXacademicWorksByIds(ids);
    }

    /**
     * 删除论文著作信息
     *
     * @param id 论文著作主键
     * @return 结果
     */
    @Override
    public int deleteSchoolXacademicWorksById(Long id)
    {
        return schoolXacademicWorksMapper.deleteSchoolXacademicWorksById(id);
    }

    /**
     * 审核
     * @param schoolXacademicWorks
     * @return
     */
    @Override
    public int audit(SchoolXacademicWorks schoolXacademicWorks) {
        return schoolXacademicWorksMapper.updateSchoolXacademicWorks(schoolXacademicWorks);
    }
}
