package yangtz.cs.liu.campus.service.impl.schoolNewTeacherDzdn;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.config.RuoYiConfig;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.DictUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.UnPackeUtil;
import com.ruoyi.common.utils.file.FileUploadUtils;
import com.ruoyi.common.utils.file.MimeTypeUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.mapper.SysDictDataMapper;
import com.ruoyi.system.service.ISysUserService;
import lombok.AllArgsConstructor;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import yangtz.cs.liu.campus.domain.fudao.FudaoStudent;
import yangtz.cs.liu.campus.domain.fudao.FudaoTeacher;
import yangtz.cs.liu.campus.domain.schoolAnnualAssessment.SchoolAnnualAssessment;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.*;
import yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn.SchoolTeacherBasichlnformationMapper;
import yangtz.cs.liu.campus.service.impl.fudao.FudaoStudentImpl;
import yangtz.cs.liu.campus.service.impl.fudao.FudaoTeacherImpl;
import yangtz.cs.liu.campus.service.impl.schoolAnnualAssessment.SchoolAnnualAssessmentServiceImpl;
import yangtz.cs.liu.campus.service.impl.teacherFiles.IdCardNumberUtils;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.SchoolTeacherBasichlnformationService;
import yangtz.cs.liu.campus.vo.fudao.FudaoStudentVo;
import yangtz.cs.liu.campus.vo.fudao.FudaoTeacherVo;
import yangtz.cs.liu.campus.vo.schoolAnnualAssessment.SchoolAnnualAssessmentVo;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.*;

import java.io.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import static com.core.constant.CompressType.ZIP_FILE;

@Service
public class SchoolTeacherBasichlnformationServicelmpl extends ServiceImpl<SchoolTeacherBasichlnformationMapper, SchoolTeacherBasicInformation> implements SchoolTeacherBasichlnformationService
{

    @Autowired
    private  SchoolTeacherBasichlnformationMapper teacherBasichlnformationMapper;


    @Autowired
    private SysDictDataMapper dictDataMapper;
    @Override
    public List<SchoolTeacherBasicInformationVo> list(SchoolTeacherBasicInformationVo information) throws Exception {
        //出生日期查询条件转换
        this.symbolConversion(information);
        this.wordDateConversion(information);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String format = sdf.format(new Date());
        List<SchoolTeacherBasicInformationVo> list = teacherBasichlnformationMapper.list(information);
        for (SchoolTeacherBasicInformationVo date :list){
            //1.计算年龄
            int ageFromIdCard = IdCardNumberUtils.getAgeFromIdCard(date.getIdCard());
            date.setAge(ageFromIdCard);
            //2.计算档案年龄
            if (null != date.getFileBirthDate()){
                int age = this.getAge(date.getFileBirthDate());
                date.setFileAge(age);
            }
            //3.到二中工作年限
            if (StringUtils.isNotNull(date.getToSecondMiddleSchoolTime())){
                int gl = this.workAge(sdf.parse(format),date.getToSecondMiddleSchoolTime());
                date.setToSecondAge(gl);
            }

        }
        return list;
    }


   public int  updateInformationById(SchoolTeacherBasicInformation information){
       return teacherBasichlnformationMapper.updateInformationById(information);
    }


    /**
     * 重新更新 新增方法
     * @param schoolTeacherBasicInformations
     * @return
     */
    @Transactional
    @Override
    public AjaxResult saveOrUpdateList(List<SchoolTeacherBasicInformation> schoolTeacherBasicInformations) {
        //1查询所有老师信息 //与统计 几百条

        String s = this.dataCheck(schoolTeacherBasicInformations);
        if (!StringUtils.isEmpty(s)){
            return AjaxResult.error(s);
        }
        Map<String,Long> mapList = new HashMap<>();
        List<SchoolIdCardQuerReq> schoolIdCardQuerReqs = teacherBasichlnformationMapper.selectByIdCardMap();
        for(SchoolIdCardQuerReq req :schoolIdCardQuerReqs){
            mapList.put(req.getIdCard(),req.getId());
        }

//
//        for (SchoolTeacherBasicInformation date : schoolTeacherBasicInformations){
////            //1.处理出生日期
////            String birthDayFromIdCard = IdCardNumberUtils.getBirthDayFromIdCard(date.getIdCard());
////            date.setBirthDate(birthDayFromIdCard);
////            //2.处理性别
////            Map<String, Object> sexFromIdCard = IdCardNumberUtils.getSexFromIdCard(date.getIdCard());
////            Integer sex = (Integer) sexFromIdCard.get(IdCardNumberUtils.SEX_BY_INT_MAP_KEY);
////            if (null == sex){
//////                return AjaxResult;
////            }
////            if (sex == 1){
////                date.setSex("0");
////            }else {
////                date.setSex("1");
////            }
//        }

        //2.讲数据存储到map中
        try {
            for (SchoolTeacherBasicInformation date :schoolTeacherBasicInformations){
                if ( null != (Long)mapList.get(date.getIdCard())){
                    //当前身份证号在数据库中存在 已更新的方式进行
                    date.setId(mapList.get(date.getIdCard()));
                    teacherBasichlnformationMapper.updateById(date);
                }else {
                    //新增
                    teacherBasichlnformationMapper.insert(date);
                }
            }
//            return true;
        }catch (Exception e){
            throw  new RuntimeException("新导用户信息失败:"+e.getMessage());
        }

        return AjaxResult.success("导入成功，共计:"+schoolTeacherBasicInformations.size()+"条;");
    }


    /**
     * 数据校验
     * @param
     * @return
     * @throws ParseException
     */
    public String dataCheck(List<SchoolTeacherBasicInformation> schoolTeacherBasicInformations){
                StringBuilder sb = new StringBuilder();
                 SchoolCheckVo schoolCheckVo = null;
                 Integer index = 0;
            for (SchoolTeacherBasicInformation date: schoolTeacherBasicInformations) {
                 index ++;

                //非空验证
                if (StringUtils.isEmpty(date.getName())) {
                    sb.append(index+ "、用户姓名不可为空");
                    sb.append("<br/>");
                }

                //身份证号
                if (StringUtils.isEmpty(date.getIdCard())) {
                    sb.append(index+ "、用户身份证号不可为空");
                    sb.append("<br/>");
                }
                //任教科目
                if (StringUtils.isEmpty(date.getTeachingSubject())) {
                    sb.append(index+ "、用户教学科不可为空");
                    sb.append("<br/>");
                }

                //手机号
                if (StringUtils.isEmpty(date.getTeachingSubject())) {
                    sb.append(index+ "、用户手机号不可为空");
                    sb.append("<br/>");
                }
//                //到二中工作日期
//                if (null == date.getToSecondMiddleSchoolTime()) {
//                    sb.append(index+ "、二中工作日期不可为空 || 数据填写不规范");
//                    sb.append("<br/>");
//                }
            }
                if (!StringUtils.isEmpty(sb.toString())){
                    return sb.toString();
                }
        for (SchoolTeacherBasicInformation date: schoolTeacherBasicInformations) {
            //1 档案出生日期验证
                if (null != date.getFileBirthDate()){
                    schoolCheckVo = this.checkeDateTime(date.getFileBirthDate());
                    if (schoolCheckVo.getFlag()){
                        date.setFileBirthDate(schoolCheckVo.getDate());
                    }else {
                        sb.append(date.getName()+"用户档案出生年月日格式错误");
                        sb.append("<br/>");
                    }
                }

                //2 入党时间验证
                if (null != date.getPartyMembershipTime()){
                    schoolCheckVo = this.checkeDateTime(date.getPartyMembershipTime());
                    if (schoolCheckVo.getFlag()){
                        date.setPartyMembershipTime(schoolCheckVo.getDate());
                    }else {
                        sb.append(date.getName()+"用户入党时间格式错误");
                        sb.append("<br/>");
                    }
                }

                //3 手机号数数量验证
                if (date.getDdPhone() ==null || date.getDdPhone().length() != 11){
                    sb.append(date.getName()+"用户手机号格式错误:"+date.getDdPhone() );
                    sb.append("<br/>");
                }
                //4 身份证验证
                //1.处理出生日期
                String birthDayFromIdCard = IdCardNumberUtils.getBirthDayFromIdCard(date.getIdCard());
                date.setBirthDate(birthDayFromIdCard);
                //2.处理性别
                Map<String, Object> sexFromIdCard = IdCardNumberUtils.getSexFromIdCard(date.getIdCard());
                Integer sex = (Integer) sexFromIdCard.get(IdCardNumberUtils.SEX_BY_INT_MAP_KEY);
                if (null == sex ){
                    sb.append(date.getName()+"用户身份证信息格式错误:"+date.getIdCard() );
                    sb.append("<br/>");
                }else {
                    if (sex == 1){
                        date.setSex("0");
                    }else {
                        date.setSex("1");
                    }
                }
                //5现职称
                 schoolCheckVo = checkeDicet("current_professional", date.getCurrentProfessionalTitle());
                if (schoolCheckVo !=null) {

                    if (schoolCheckVo.getFlag()) {
                        date.setCurrentProfessionalTitle(schoolCheckVo.getVal());
                    } else {
                        sb.append(date.getName() + "用户现职称录入不符合选择项:" + schoolCheckVo.getVal());
                        sb.append("<br/>");
                    }
                }
                //6 先职称取得时间
                if (null != date.getCurrentProfessionalTitleTime()){
                    schoolCheckVo = this.checkeDateTime(date.getCurrentProfessionalTitleTime());
                    if (schoolCheckVo.getFlag()){
                        date.setCurrentProfessionalTitleTime(schoolCheckVo.getDate());
                    }else {
                        sb.append(date.getName()+"用户现职称取得资格时间格式错误");
                        sb.append("<br/>");
                    }
                }

                 //7 先聘岗位
                schoolCheckVo = checkeDicet("current_position", date.getCurrentPosition());
                if (schoolCheckVo !=null) {

                    if (schoolCheckVo.getFlag()) {
                        date.setCurrentPosition(schoolCheckVo.getVal());
                    } else {
                        sb.append(date.getName() + "用户现聘岗位录入不符合选择项:" + schoolCheckVo.getVal());
                        sb.append("<br/>");
                    }
                }
                //任教学科
                schoolCheckVo = checkeDicet("teaching_subjects", date.getTeachingSubject());
                if (schoolCheckVo !=null) {

                    if (schoolCheckVo.getFlag()) {
                        date.setTeachingSubject(schoolCheckVo.getVal());
                    } else {
                        sb.append(date.getName() + "用户任教学科录入不符合选择项:" + schoolCheckVo.getVal());
                        sb.append("<br/>");
                    }
                }
                //政治面貌
                schoolCheckVo = checkeDicet("politics_tatusls", date.getPoliticalLandscape());
                if (schoolCheckVo !=null) {
                    if (schoolCheckVo.getFlag()) {
                        date.setPoliticalLandscape(schoolCheckVo.getVal());
                    } else {
                        sb.append(date.getName() + "用户政治面貌录入不符合选择项:" + schoolCheckVo.getVal());
                        sb.append("<br/>");
                    }
                }
                //现聘职称
                schoolCheckVo = checkeDicet("current_professional", date.getCurrentHiringProfessionalTitle());
                if (schoolCheckVo !=null) {
                    if (schoolCheckVo.getFlag()) {
                        date.setCurrentHiringProfessionalTitle(schoolCheckVo.getVal());
                    } else {
                        sb.append(date.getName() + "用户现聘职称录入不符合选择项:" + schoolCheckVo.getVal());
                        sb.append("<br/>");
                    }
                }

                //8 现岗位等级
                schoolCheckVo = checkeDicet("current_joblevel", date.getCurrentJobLevel());
                if (schoolCheckVo !=null) {
                    if (schoolCheckVo.getFlag()) {
                        date.setCurrentJobLevel(schoolCheckVo.getVal());
                    } else {
                        sb.append(date.getName() + "用户现岗位等级录入不符合选择项:" + schoolCheckVo.getVal());
                        sb.append("<br/>");
                    }
                }
                //9现岗位等级聘任时间
                if (null != date.getCurrentJobLevelAppointmentTime()){
                    schoolCheckVo = this.checkeDateTime(date.getCurrentJobLevelAppointmentTime());
                    if (schoolCheckVo.getFlag()){
                        date.setCurrentJobLevelAppointmentTime(schoolCheckVo.getDate());
                    }else {
                        sb.append(date.getName()+"用户现岗位等级聘任时间格式错误");
                        sb.append("<br/>");
                    }
                }

                //参加工作时间
                if (StringUtils.isNotEmpty(date.getWorkingHours())){
                    schoolCheckVo = this.checkeDateTime(DateUtils.parseDate(date.getWorkingHours()));
                    if (schoolCheckVo.getFlag()){
                        date.setWorkingHours(schoolCheckVo.getVal());
                    }else {
                        sb.append(date.getName()+"用户参加工作时间格式错误");
                        sb.append("<br/>");
                    }
                }

                //到二中工作时间
                if(StringUtils.isNotNull(date.getToSecondMiddleSchoolTime())){
                    schoolCheckVo = this.checkeDateTime(date.getToSecondMiddleSchoolTime());
                    if (schoolCheckVo.getFlag()){
                        date.setToSecondMiddleSchoolTime(schoolCheckVo.getDate());
                    }else {
                        sb.append(date.getName()+"用户到二中工作时间格式错误" );
                        sb.append("<br/>");
                    }
                }

                //在岗情况
                schoolCheckVo = checkeDicet("duty_situation", date.getOnDutySituation());
                if (schoolCheckVo !=null) {
                    if (schoolCheckVo.getFlag()) {
                        date.setOnDutySituation(schoolCheckVo.getVal());
                    } else {
                        sb.append(date.getName() + "用户 在岗情况录入不符合选择项:" + schoolCheckVo.getVal());
                        sb.append("<br/>");
                    }
                }
                //在编情况
                schoolCheckVo = checkeDicet("current_situation", date.getCurrentSituation());
                if (schoolCheckVo !=null) {
                    if (schoolCheckVo.getFlag()) {
                        date.setCurrentSituation(schoolCheckVo.getVal());
                    } else {
                        sb.append(date.getName() + "用户 在编情况录入不符合选择项:" + schoolCheckVo.getVal());
                        sb.append("<br/>");
                    }
                }
                //毕业时间1
                if (null != date.getGraduationTime1()){
                    schoolCheckVo = this.checkeDateTime(date.getGraduationTime1());

                    if (schoolCheckVo.getFlag()){
                        date.setGraduationTime1(schoolCheckVo.getDate());
                    }else {
                        sb.append(date.getName()+"用户 毕业时间1 格式错误");
                        sb.append("<br/>");
                    }
                }
                    //毕业时间2
                if (null != date.getGraduationTime2()){
                    schoolCheckVo = this.checkeDateTime(date.getGraduationTime2());
                    if (schoolCheckVo.getFlag()){
                        date.setGraduationTime2(schoolCheckVo.getDate());
                    }else {
                        sb.append(date.getName()+"用户 毕业时间2 格式错误");
                        sb.append("<br/>");
                    }
                }

                    //毕业时间3
                if (null != date.getGraduationTime3()){
                    schoolCheckVo = this.checkeDateTime(date.getGraduationTime3());
                    if (schoolCheckVo.getFlag()){
                        date.setGraduationTime3(schoolCheckVo.getDate());
                    }else {
                        sb.append(date.getName()+"用户 毕业时间3 格式错误");
                        sb.append("<br/>");
                    }
                }
            }
            return sb.toString();

    }


    /**
     * 校验时间
     * @param date
     * @return
     */
    public SchoolCheckVo checkeDateTime(Date date){
        SchoolCheckVo sc = new SchoolCheckVo();
        if (null == date){
            sc.setFlag(false);
            sc.setVal(null);
            return sc;
        }
        SimpleDateFormat sdf =  new SimpleDateFormat("yyyy-MM-dd");
        try {
            String format = sdf.format(date);
            sc.setFlag(true);
            sc.setVal(format);
            sc.setDate( DateUtils.parseDate(format));
        }catch (Exception e){
            sc.setFlag(false);
            sc.setVal(date.toString());
        }
        return sc;
    }

    /**
     * 校验字典数据
     * @param type 类型   vlaue 值  不会验证必填项
     * @return
     * @throws ParseException
     */
    public SchoolCheckVo checkeDicet(String type,String value){
        SchoolCheckVo sc = new SchoolCheckVo();
        if (StringUtils.isEmpty(value)){
            return null;
        }
        //解析值
        String val =  DictUtils.getDictValue(type, value, ",");
        if (StringUtils.isEmpty(val)){
            sc.setFlag(false);
            sc.setVal(value);
            return sc;
        }
        if (StringUtils.isEmpty(val)){
            sc.setFlag(false);
            sc.setVal(value);
        }else {
            sc.setFlag(true);
            sc.setVal(val);
        }

        return sc;
    }



    @Override
    public SchoolTeacherBasicInformationVo getByIds(Long id) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String format = sdf.format(new Date());
        SchoolTeacherBasicInformationVo schoolTeacherBasicInformation = teacherBasichlnformationMapper.selectById(id);
        //1.计算年龄
        int ageFromIdCard = IdCardNumberUtils.getAgeFromIdCard(schoolTeacherBasicInformation.getIdCard());
        schoolTeacherBasicInformation.setAge(ageFromIdCard);
        //2.计算档案年龄
        if (StringUtils.isNotNull(schoolTeacherBasicInformation.getFileBirthDate())){
            int age = this.getAge(schoolTeacherBasicInformation.getFileBirthDate());
            schoolTeacherBasicInformation.setFileAge(age);
        }
        //3.到二中工作年限
        if (StringUtils.isNotNull(schoolTeacherBasicInformation.getToSecondMiddleSchoolTime())){
            int nl = this.workAge(sdf.parse(format),schoolTeacherBasicInformation.getToSecondMiddleSchoolTime());
            schoolTeacherBasicInformation.setToSecondAge(nl);
        }

        //4. 工作年龄
        if (null != schoolTeacherBasicInformation.getLengthOfServiceTime()){
            int gl = this.workAge(sdf.parse(format),schoolTeacherBasicInformation.getLengthOfServiceTime());
            schoolTeacherBasicInformation.setSeniority(gl);
        }
        return schoolTeacherBasicInformation;
    }


    /**
     * 导入
     * @param
     * @return
     */
    @Override
    public List<SchoolTeacherBasicInformation> importExcel(MultipartFile file) {
        List<SchoolTeacherBasicInformation> list = new ArrayList<>();
        try {
            XSSFWorkbook xwb = new XSSFWorkbook(file.getInputStream());//导入.xlxs
            //HSSFWorkbook hwb = new HSSFWorkbook(file.getInputStream());//导入.xls
            //获取第一个sheet表，下标是从0开始的
            XSSFSheet sheet = xwb.getSheetAt(0);
            int sheetNum = xwb.getNumberOfSheets();//获取总共有几个sheet表
            int rowNum = sheet.getLastRowNum();   //获取excel最后有数据的一行为n，返回n-1.返回数据行的下标 从0开始
            for (int i = 2; i <= rowNum; i++) {
                SchoolTeacherBasicInformation vo = new SchoolTeacherBasicInformation();
                XSSFRow row = sheet.getRow(i); //获取excel第i行，下标从0开始,第一行的下标为0
                //XSSFCell cell = row.getCell(0);//获取第i行的第一个单元格
                //名称
                if (row.getCell(1) != null) {
                    row.getCell(1).setCellType(CellType.STRING);//设置第i行第一个单元格数据为String类型
                    String name = row.getCell(1).getStringCellValue(); //获取第一个单元格的值
                    vo.setName(name);
                }
                //身份证
                if (row.getCell(2) != null) {
                    row.getCell(2).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(2).getStringCellValue();  //获取String类型的值
                    vo.setIdCard(shelterAddress);
                }
                //档案出生日期
                if (row.getCell(3) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    CellType type = row.getCell(3).getCellType();
                    //1为公式类型
                            row.getCell(3).setCellType(CellType.STRING);
                            String shelterAddress = row.getCell(3).getStringCellValue(); //获取日期类型的值
                            vo.setFileBirthDate(DateUtils.parseDate(shelterAddress));
                }
                //籍贯
                if (row.getCell(4) != null) {
                    row.getCell(4).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(4).getStringCellValue();  //获取String类型的值
                    vo.setHometown(shelterAddress);
                }
                //民族
                if (row.getCell(5) != null) {
                    row.getCell(5).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(5).getStringCellValue();  //获取String类型的值
                    vo.setNation(shelterAddress);
                }
                //政治面貌
                if (row.getCell(6) != null) {
                    row.getCell(6).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(6).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("politics_tatusls", shelterAddress);
                    vo.setPoliticalLandscape(s);
                }
                //入党时间
                if (row.getCell(7) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    //1为公式类型
                            row.getCell(7).setCellType(CellType.STRING);
                            String setDate = row.getCell(7).getStringCellValue(); //获取日期类型的值
                            vo.setPartyMembershipTime(DateUtils.parseDate(setDate));
                }

                //任教学科
                if (row.getCell(8) != null) {
                    row.getCell(8).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(8).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("teaching_subjects", shelterAddress);
                    vo.setTeachingSubject(s);
                }
                //钉钉手机号
                if (row.getCell(9) != null) {
                    row.getCell(9).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(9).getStringCellValue();  //获取String类型的值
                    vo.setDdPhone(shelterAddress);
                }
                //现职称
                if (row.getCell(10) != null) {
                    row.getCell(10).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(10).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("current_professional", shelterAddress);
                    vo.setCurrentProfessionalTitle(s);
                }
                //现职称获取资格时间 currentProfessionalTitleTime
                if (row.getCell(11) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    //1为公式类型
                            row.getCell(11).setCellType(CellType.STRING);
                            String setDate = row.getCell(11).getStringCellValue(); //获取日期类型的值
                            vo.setCurrentProfessionalTitleTime(DateUtils.parseDate(setDate));
                }
                //现聘职称
                if (row.getCell(12) != null) {
                    row.getCell(12).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(12).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("current_professional", shelterAddress);
                    vo.setCurrentHiringProfessionalTitle(s);
                }
                //现职称聘用时间 currentHiringProfessionalTitleTime
                if (row.getCell(13) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    CellType type = row.getCell(13).getCellType();
                    //1为公式类型
                            row.getCell(13).setCellType(CellType.STRING);
                            String setDate = row.getCell(13).getStringCellValue(); //获取日期类型的值
                            vo.setCurrentHiringProfessionalTitleTime(DateUtils.parseDate(setDate));
                }

                //现聘岗位
                if (row.getCell(14) != null) {
                    row.getCell(14).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(14).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("current_position", shelterAddress);
                    vo.setCurrentJobLevel(s);
                }



                //现岗位等级
                if (row.getCell(15) != null) {
                    row.getCell(15).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(15).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("current_joblevel", shelterAddress);
                    vo.setCurrentJobLevel(s);
                }
                //现岗位聘用时间 currentJobLevelAppointmentTime
                if (row.getCell(16) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    //1为公式类型
                            row.getCell(16).setCellType(CellType.STRING);
                            String setDate = row.getCell(16).getStringCellValue(); //获取日期类型的值
                            vo.setCurrentJobLevelAppointmentTime(DateUtils.parseDate(setDate));
                }
                //职务
                if (row.getCell(17) != null) {
                    row.getCell(17).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(17).getStringCellValue();  //获取String类型的值
                    vo.setDuties(shelterAddress);
                }
                //教师资格种类
                if (row.getCell(18) != null) {
                    row.getCell(18).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(18).getStringCellValue();  //获取String类型的值
                    vo.setTeacherQualificationType(shelterAddress);
                }
                //教师资格证号码
                if (row.getCell(19) != null) {
                    row.getCell(19).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(19).getStringCellValue();  //获取String类型的值
                    vo.setTeacherQualificationCertificateNum(shelterAddress);
                }
                //参加工作时间
                if (row.getCell(20) != null) {
                    row.getCell(20).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(20).getStringCellValue();  //获取String类型的值
                    vo.setWorkingHours(shelterAddress);
                }
                //到二中工作时间
                if (row.getCell(21) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    //1为公式类型
                            row.getCell(21).setCellType(CellType.STRING);
                            String setDate = row.getCell(21).getStringCellValue(); //获取日期类型的值
                            vo.setToSecondMiddleSchoolTime(DateUtils.parseDate(setDate));
                }
                //在岗情况
                if (row.getCell(22) != null) {
                    row.getCell(22).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(22).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("duty_situation", shelterAddress);
                    vo.setCurrentJobLevel(s);
                }
                //在编情况
                if (row.getCell(23) != null) {
                    row.getCell(23).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(23).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("current_situation", shelterAddress);
                    vo.setCurrentJobLevel(s);
                }

                //毕业学院1
                if (row.getCell(24) != null) {
                    row.getCell(24).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(24).getStringCellValue();  //获取String类型的值
                    vo.setGraduationInstitution1(shelterAddress);
                }
                //专业1
                if (row.getCell(25) != null) {
                    row.getCell(25).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(25).getStringCellValue();  //获取String类型的值
                    vo.setMajor1(shelterAddress);
                }
                //毕业时间1
                if (row.getCell(26) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    //1为公式类型
                            row.getCell(26).setCellType(CellType.STRING);
                            String setDate = row.getCell(26).getStringCellValue(); //获取日期类型的值
                            vo.setGraduationTime1(DateUtils.parseDate(setDate));
                }
                //毕业学院2
                if (row.getCell(27) != null) {
                    row.getCell(27).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(27).getStringCellValue();  //获取String类型的值
                    vo.setGraduationInstitution2(shelterAddress);
                }
                //专业2
                if (row.getCell(28) != null) {
                    row.getCell(28).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(28).getStringCellValue();  //获取String类型的值
                    vo.setMajor2(shelterAddress);
                }
                //毕业时间2
                if (row.getCell(29) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    //1为公式类型
                            row.getCell(29).setCellType(CellType.STRING);
                            String setDate = row.getCell(29).getStringCellValue(); //获取日期类型的值
                            vo.setGraduationTime2(DateUtils.parseDate(setDate));
                }

                //毕业学院3
                if (row.getCell(30) != null) {
                    row.getCell(30).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(30).getStringCellValue();  //获取String类型的值
                    vo.setGraduationInstitution3(shelterAddress);
                }
                //专业3
                if (row.getCell(31) != null) {
                    row.getCell(31).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(31).getStringCellValue();  //获取String类型的值
                    vo.setMajor3(shelterAddress);
                }
                //毕业时间3
                if (row.getCell(32) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    //1为公式类型

                            row.getCell(32).setCellType(CellType.STRING);
                            String setDate = row.getCell(32).getStringCellValue(); //获取日期类型的值
                            vo.setGraduationTime3(DateUtils.parseDate(setDate));
                }
                //第一学历
                if (row.getCell(33) != null) {
                    row.getCell(33).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(33).getStringCellValue();  //获取String类型的值
                    vo.setFirstDegree(shelterAddress);
                }

                //最后学历
                if (row.getCell(34) != null) {
                    row.getCell(34).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(34).getStringCellValue();  //获取String类型的值
                    vo.setLastDegree(shelterAddress);
                }
                //学位
                if (row.getCell(35) != null) {
                    row.getCell(35).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(35).getStringCellValue();  //获取String类型的值
                    vo.setDegree(shelterAddress);
                }
                //工作经理
                if (row.getCell(36) != null) {
                    row.getCell(36).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(36).getStringCellValue();  //获取String类型的值
                    vo.setWorkExperience(shelterAddress);
                }
                //备注
                if (row.getCell(37) != null) {
                    row.getCell(37).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(37).getStringCellValue();  //获取String类型的值
                    vo.setRemark(shelterAddress);
                }
//                if (row.getCell(4) != null) {
//                    row.getCell(4).setCellType(CellType.NUMERIC);
//
//                    double capacity = row.getCell(4).getNumericCellValue();  //获取数值类型的值
//                    vo.setCapacity((int) capacity);
//                }
                list.add(vo);
            }

        } catch (IOException e) {
            e.printStackTrace();
            log.error(e.toString());
        } catch (IllegalStateException e) {
            e.printStackTrace();
            log.error(e.toString());
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.toString());
        }
        return list;

    }

    /**
     * 根据手机号查询身份证信息
     * @param userPhones
     * @return
     */
    @Override
    public List<String> selectIdCardsByDdPhone(List<String> userPhones) {
        return teacherBasichlnformationMapper.selectIdCardsByDdPhone(userPhones);
    }

    /**
     * 根据手机号查询学科
     * @param ddPhone
     * @return
     */
    @Override
    public String selectSubByDdPhone(String ddPhone) {
        return teacherBasichlnformationMapper.selectSubByDdPhone(ddPhone);
    }


    @Override
    public String importTeacherPicture(MultipartFile uploadFile) {
        StringBuilder failureMsg = new StringBuilder();
        /*解压到本地*/
        unpack(uploadFile);
        /*处理图片并匹配学生并添加到数据库中*/
        String os = System.getProperty("os.name");
        File file = null;
        //Windows操作系统
        if (os != null && os.toLowerCase().startsWith("windows")) {
            file = new File("C:\\uploadPicture");
        } else if (os != null && os.toLowerCase().startsWith("linux")) {//Linux操作系统
            file = new File("/uploadPicture");
        }
        File[] files = file.listFiles();
        judgeFiles(files);
        for (File f : files) {
            if (StringUtils.isNotNull(f)) {
                if (f.isDirectory()) {
                    File[] files1 = f.listFiles();
                    if (files1.length == 0 || StringUtils.isNull(files1)) {
                        throw new ServiceException("压缩包内文件夹里无头像信息，请检查");
                    }
                    for (File file1 : files1) {
                        saveUrlToObject(file1, failureMsg);
                        file1.delete();
                    }
                    f.delete();
                    continue;
                }
                //saveUrlToObject(f);
                /*将本地的文件删除*/
                f.delete();
            }
        }
        String s = "";
        if ("".equals(failureMsg.toString())) {
            s = "恭喜您，数据已全部导入成功！";
        } else {
            failureMsg.insert(0, "导入完成，其中不匹配的数据如下：");
            s = failureMsg.toString();
        }
        return s;
    }

    public void unpack(MultipartFile uploadFile) {
        boolean isZipPack = true;

        // 解压目录
        String packFileStr = "";

        String os = System.getProperty("os.name");
        File packFile = null;
        //Windows操作系统
        if (os != null && os.toLowerCase().startsWith("windows")) {
            packFileStr = "C:\\uploadPicture";
            packFile = new File(packFileStr);
        } else if (os != null && os.toLowerCase().startsWith("linux")) {//Linux操作系统
            packFileStr = "/uploadPicture";
            packFile = new File(packFileStr);
            packFile.setWritable(true, false);
        }

        //不存在则创建
        if (!packFile.exists()) {
            boolean mkdirs = packFile.mkdirs();
        } else {
            //存在则删除其中数据
            remove(packFile);
        }

        if (uploadFile == null) {
            throw new RuntimeException("请上传文件");
        }
        String contentType = uploadFile.getContentType();
        String filename = uploadFile.getOriginalFilename();
        String[] subFileName = filename.split("\\.");
        //将压缩包保存在指定路径
        String packFilePath = packFileStr + File.separator + filename;
        if (judgeIsZip(ZIP_FILE, contentType) || subFileName[1].equals("zip")) {
            //zip解压缩处理
        }
//        else if (RAR_FILE.equals(contentType)) {
//            //rar解压缩处理
//            isZipPack = false;
//        }
        else {
            throw new RuntimeException("上传的压缩包格式不正确,仅支持zip压缩文件!");
        }
        File file = new File(packFilePath);
        try {
            uploadFile.transferTo(file);
        } catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("压缩文件到:" + packFileStr + " 失败!");
        }
        if (isZipPack) {
            //zip压缩包
            UnPackeUtil.unPackZip(file, null, packFileStr);
            //删除系统对应文件夹中的zip文件
            file.delete();
        } else {
            //rar压缩包
//            RandomAccessFile randomAccessFile = null;
//            IInArchive inArchive = null;
//
//            randomAccessFile = new RandomAccessFile(packFilePath, "r");
//            inArchive = SevenZip.openInArchive(null, new RandomAccessFileInStream(randomAccessFile));
//
//            int[] in = new int[inArchive.getNumberOfItems()];
//            for (int i = 0; i < in.length; i++) {
//                in[i] = i;
//            }
//            inArchive.extract(in, false, new ExtractCallback(inArchive, "366", packFileStr));

        }
        //获取压缩包名称
        filename = filename.substring(0, filename.lastIndexOf("."));

        System.out.println("解压成功，解压目录：" + filename);
        //可以根据解压路径、压缩包名称、文件名称，取出对应文件进行操作
    }


    public File[] judgeFiles(File[] files) {
        if (files.length == 0 || StringUtils.isNull(files)) {
            throw new ServiceException("压缩包内容为空，请检查，支持的格式为：将老师头像照片放在某一文件夹内，将该文件夹压缩成zip格式的压缩包，然后再上传");
        }
        //定义需要删除的文件的索引
        List<File> files1 = new ArrayList<>();
        boolean hasPic = false;
        boolean hasFolder = false;
        //for (File f : files) {
        for (int i = 0; i < files.length; i++) {
            if (files[i].isDirectory()) {
                hasFolder = true;
                if (files[i].listFiles().length > 0 && StringUtils.isNotNull(files[i].listFiles())) {
                    files1 = Arrays.asList(files[i].listFiles());
                }
                for (File file1 : files[i].listFiles()) {
                    //遍历文件夹，看是否有图片格式的照片
                    String filename = file1.getName();
                    String[] split = filename.split("\\.");
                    if (split.length <= 1) {
                        throw new ServiceException("请检查压缩包,支持的格式为：将老师头像照片放在某一文件夹内，文件夹内不要嵌套文件夹，也不要有其他无关文件，将该文件夹压缩成zip格式的压缩包，然后再上传");
                    }
                    /*判断文件是否是jpg和png*/
                    if (split[1].equals("jpg") || split[1].equals("png") || split[1].equals("jpeg") || split[1].equals("bmp")) {
                        hasPic = true;
                    } else {
                        //文件夹内不是以上格式的删除掉
                        file1.delete();
                    }
                }

            } else {
                //不是文件夹的就删除
                files[i].delete();
                files[i] = null;
            }
        }

        //判断压缩格式是否合适，是否有文件夹
        if (!hasFolder) {
            throw new ServiceException("压缩包内无文件夹，请检查，支持的格式为：将老师头像照片放在某一文件夹内，将该文件夹压缩成zip格式的压缩包，然后再上传");
        }
        //files1为空，说明压缩包内文件夹里无任何文件
        if (StringUtils.isNull(files1) || files1.size() == 0) {
            throw new ServiceException("压缩包内的文件夹内无文件，请检查，支持的格式为：将老师头像照片放在某一文件夹内，将该文件夹压缩成zip格式的压缩包，然后再上传");
        }

        //判断文件夹内是否有需要的图片格式
        if (!hasPic) {
            throw new ServiceException("压缩包内文件夹里没有符合所要求的图片格式的老师头像照片，请检查，支持的图片格式：jpg、 png、 jpeg和bmp，暂不支持其它格式");
        }

        return files;
    }


    //删除指定文件夹下的所有内容
    public void remove(File file) {
        File[] files = file.listFiles();//将file子目录及子文件放进文件数组
        if (files != null) {//如果包含文件进行删除操作
            for (int i = 0; i < files.length; i++) {
                if (files[i].isFile()) {//删除子文件
                    files[i].delete();
                } else if (files[i].isDirectory()) {//通过递归方法删除子目录的文件
                    remove(files[i]);
                }
                files[i].delete();//删除子目录
            }
        }
    }

    public boolean judgeIsZip(String[] fileType, String contentType) {
        boolean flag = false;

        for (String i : fileType) {
            if (contentType.equals(i)) {
                flag = true;
            }
        }
        return flag;
    }



    @Transactional(rollbackFor = Exception.class)
    public void saveUrlToObject(File f, StringBuilder failureMsg) {
        String filename = f.getName();
        String[] split = filename.split("\\.");
        //可能是身份证号，可能是省学籍号
        String idCard = split[0];
        /*获取到对应学生的数据  ,先根据身份证查*/
        LambdaQueryWrapper<SchoolTeacherBasicInformation> lqw1 = new LambdaQueryWrapper<>();
        lqw1.eq(SchoolTeacherBasicInformation::getIdCard, idCard);
        List<SchoolTeacherBasicInformation> studentList1 = teacherBasichlnformationMapper.selectList(lqw1);
        if (StringUtils.isNull(studentList1) || studentList1.size() == 0) {
            failureMsg.append("     身份证号为" + idCard + "的老师不在，无法为该老师导入图片 "+"\\r\\n");
            failureMsg.append("\n");
        } else {
            boolean flag = false;
            if (split.length <= 1) {
                throw new ServiceException("请检查压缩包，压缩包内不要有文件夹；可将老师照片放到同一文件夹下，文件夹下不要有任何与老师照片无关的文件，将该文件夹压缩上传");
            }
            /*判断文件是否是jpg和png*/
            if (split[1].equals("jpg") || split[1].equals("png") || split[1].equals("jpeg") || split[1].equals("bmp")) {
                flag = true;
            } else {
                //throw new ServiceException("支持jpg、 png、 jpeg和bmp图片上传，暂不支持其它格式");
                failureMsg.append("     身份证号为" + idCard + "的图片格式有误，支持jpg、 png、 jpeg和bmp图片上传，暂不支持其它格式");
            }
            /*必须存在这个同学 并且 是图片类型才能进行下一步*/
            if (studentList1.size() != 0 && flag) {
                /*上传图片到服务器，获取地址*/
                /*将file文件转为MultipartFile*/
                MultipartFile cMultiFile = getMultipartFile(f);
                /*上传文件并获取url*/
                String url = uploadFile(cMultiFile);
                /*将路径添加到数据库中*/
                  for (SchoolTeacherBasicInformation date:studentList1){
                      date.setPhotoUrl(url);
                      date.setPhotoName(idCard);
                      teacherBasichlnformationMapper.updateById(date);
                  }
            } else {
                //不能抛异常，，，否则指定目录下会存在脏数据
                //throw new ServiceException("身份证号或省学籍号为" + idCard + "的学生不存在，无法导入图片，请检查");
                failureMsg.append("     身份证为" + idCard + "的老师不存在，无法为该老师导入图片");
                failureMsg.append("\n");

            }
        }

    }


    /*上传文件*/
    public String uploadFile(MultipartFile file) {
        try {
            // 上传文件路径
            String filePath = RuoYiConfig.getAvatarPath();
            // 上传并返回新文件名称
            String url = FileUploadUtils.upload(filePath, file, MimeTypeUtils.IMAGE_EXTENSION);
            //String url = serverConfig.getUrl() + fileName;

            //int i = url.indexOf("/profile");
            //String substring = url.substring(i);
            //System.out.println(substring);
            return url;
        } catch (Exception e) {
            throw new ServiceException("上传异常");
        }
    }



    /*File转为MultipartFile*/
    public static MultipartFile getMultipartFile(File file) {
        FileItem item = new DiskFileItemFactory().createItem("file"
                , MediaType.MULTIPART_FORM_DATA_VALUE
                , true
                , file.getName());
        try (InputStream input = new FileInputStream(file);
             OutputStream os = item.getOutputStream()) {
            // 流转移
            IOUtils.copy(input, os);
        } catch (Exception e) {
            throw new IllegalArgumentException("Invalid file: " + e, e);
        }

        return new CommonsMultipartFile(item);
    }


    //计算年龄
    private int getAge(Date birth) {
        Calendar cal = Calendar.getInstance();
        int thisYear = cal.get(Calendar.YEAR);
        int thisMonth = cal.get(Calendar.MONTH);

        cal.setTime(birth);
        int birthYear = cal.get(Calendar.YEAR);
        int birthMonth = cal.get(Calendar.MONTH);

        int age = thisYear - birthYear;

        // 未足月
        if (thisMonth <= birthMonth) {
            // 当月
            if (thisMonth == birthMonth) {

            } else {
                age--;
            }
        }
        return age;
    }

    //计算工龄
    public int workAge(Date nowTime, Date workTime) throws ParseException{
        int year = 0;
//当前时间的年月日
        Calendar cal = Calendar.getInstance();
        cal.setTime(nowTime);
        int nowYear = cal.get(Calendar.YEAR);
        int nowMonth = cal.get(Calendar.MONTH);
        int nowDay = cal.get(Calendar.DAY_OF_MONTH);
//开始工作时间的年月日
        cal.setTime(workTime);
        int workYear = cal.get(Calendar.YEAR);
        int workMonth = cal.get(Calendar.MONTH);
        int workDay = cal.get(Calendar.DAY_OF_MONTH);
//得到工龄
        year = nowYear - workYear; //得到年差
//若目前月数少于开始工作时间的月数，年差-1
        if (nowMonth < workMonth){
            year = year - 1;
        }else if (nowMonth == workMonth){
//当月数相等时，判断日数，若当月的日数小于开始工作时间的日数，年差-1
            if (nowDay < workDay){
                year = year - 1;
            }
        }
        return year;
    }

    /**
     * 出生年月条件转换
     * @param information
     */
    private void symbolConversion(SchoolTeacherBasicInformationVo information){
        String birthDate = information.getBirthDate();
        if (StringUtils.isEmpty(birthDate)){
            return;
        } else if (birthDate.contains(">=")) {
            String substring = birthDate.substring(2, birthDate.length());
            information.setBirthDategtd(substring);
            information.setBirthDate(null);
        } else if (birthDate.contains("<=")) {
            String substring = birthDate.substring(2, birthDate.length());
            information.setBirthDateltd(substring);
            information.setBirthDate(null);
        } else if (birthDate.contains("<")) {
            String substring = birthDate.substring(1, birthDate.length());
            information.setBirthDatelt(substring);
            information.setBirthDate(null);
        } else if (birthDate.contains(">")) {
            String substring = birthDate.substring(1, birthDate.length());
            information.setBirthDategt(substring);
            information.setBirthDate(null);
        } else if (birthDate.contains("=")) {
            String substring = birthDate.substring(1, birthDate.length());
            information.setBirthDate(substring);
        }
    }
    /**
     * 参加工作调整
     */

    private void wordDateConversion(SchoolTeacherBasicInformationVo information){
        String workingHours = information.getWorkingHours();
        if (StringUtils.isEmpty(workingHours)){
            return;
        } else if (workingHours.contains(">=")) {
            String substring = workingHours.substring(2, workingHours.length());
            information.setWorkingHoursgtd(substring);
            information.setWorkingHours(null);
        } else if (workingHours.contains("<=")) {
            String substring = workingHours.substring(2, workingHours.length());
            information.setWorkingHoursltd(substring);
            information.setWorkingHours(null);
        } else if (workingHours.contains("<")) {
            String substring = workingHours.substring(1, workingHours.length());
            information.setWorkingHourslt(substring);
            information.setWorkingHours(null);
        } else if (workingHours.contains(">")) {
            String substring = workingHours.substring(1, workingHours.length());
            information.setWorkingHoursgt(substring);
            information.setWorkingHours(null);
        } else if (workingHours.contains("=")) {
            String substring = workingHours.substring(1, workingHours.length());
            information.setWorkingHours(substring);
        }
    }


    @Autowired
    SchoolAworkloadServiceImpl schoolAworkloadService;

    @Autowired
    SchoolAclassTeacherAssessmentServiceImpl schoolAclassTeacherAssessmentService;

    @Autowired
    SchoolGkAchievementServiceImpl schoolGkAchievementService;
    @Autowired
    ISysUserService sysUserService;

    @Autowired
    SchoolXteachingAchievementsServiceImpl schoolXteachingAchievementsService;

    @Autowired
    SchoolXteacherAwardsServiceImpl schoolXteacherAwardsService;

    @Autowired
    SchoolXlectureAwardsServiceImpl schoolXlectureAwardsService;

    @Autowired
    SchoolXacademicWorksServiceImpl schoolXacademicWorksService;
    @Autowired
    FudaoTeacherImpl fudaoTeacherimpl;
    @Autowired
    FudaoStudentImpl fudaoStudentImpl;
    @Autowired
    SchoolAnnualAssessmentServiceImpl schoolAnnualAssessmentService;
    @Autowired
    SchoolXcomprehensiveHonorsServiceImpl schoolXcomprehensiveHonorsService;
    @Autowired
    SchoolXprojectResearchServiceImpl schoolXprojectResearchService;
    @Autowired
    SchoolXsyouthTeacherServiceImpl schoolXsyouthTeacherService;
    /**
     * 综合信息查询
     * @param req
     * @return
     */
    @Override
    public ComperhensiveVo comprehensive(ComprehensiveReq req) throws Exception {
        ComperhensiveVo comperhensiveVo = new ComperhensiveVo();
        //1.查询教师进本信息 判断是根据身份证还是姓名
        if (StringUtils.isNotEmpty(req.getName())){
            //根据姓名 查询存在多个 使用list接受返回第一个
            SchoolTeacherBasicInformationVo vo = new SchoolTeacherBasicInformationVo();
            vo.setName(req.getName());
            List<SchoolTeacherBasicInformationVo> list = this.list(vo);
            if (!list.isEmpty()){
                SchoolTeacherBasicInformationVo schoolTeacherBasicInformationVo = list.get(0);
                SchoolTeacherBasicInformationVo schoolTeacherBasicInformationVo1 = this.getByIds(schoolTeacherBasicInformationVo.getId());
                comperhensiveVo.setBasicInformation(schoolTeacherBasicInformationVo1);
            }else {
                throw new RuntimeException("教师信息未查到");
            }
        }else if (StringUtils.isNotEmpty(req.getIdCard())){
            //身份证
            SchoolTeacherBasicInformationVo vo = new SchoolTeacherBasicInformationVo();
            vo.setIdCard(req.getIdCard());
            List<SchoolTeacherBasicInformationVo> list = this.list(vo);
            if (!list.isEmpty()){
                SchoolTeacherBasicInformationVo schoolTeacherBasicInformationVo = list.get(0);
                SchoolTeacherBasicInformationVo schoolTeacherBasicInformationVo1 = this.getByIds(schoolTeacherBasicInformationVo.getId());
                comperhensiveVo.setBasicInformation(schoolTeacherBasicInformationVo1);
            }else {
                throw new RuntimeException("教师信息未查到");
            }
        }else {
            throw new RuntimeException("查询条件身份证/姓名，必须输入一项否则无法查询");
        }
        SchoolTeacherBasicInformationVo basicInformation = comperhensiveVo.getBasicInformation();
        if (null ==  basicInformation  ){
            return comperhensiveVo;
        }

        //2 工作量信息查询 使用身份证查询
        SchoolAworkloadVo schoolAworkload = new SchoolAworkloadVo();
        schoolAworkload.setIdCard(basicInformation.getIdCard());
        List<SchoolAworkloadVo> schoolAworkloadVos = schoolAworkloadService.selectSchoolAworkloadList(schoolAworkload);
        comperhensiveVo.setSchoolAworkload(schoolAworkloadVos);

        //3 班主任考核
        SchoolAclassTeacherAssessmentReq req1 = new SchoolAclassTeacherAssessmentReq();
        req1.setIdCard(basicInformation.getIdCard());
        List<SchoolAclassTeacherAssessmentVo> schoolAclassTeacherAssessmentVos = schoolAclassTeacherAssessmentService.selectSchoolAclassTeacherAssessmentList(req1);
        comperhensiveVo.setSchoolAclassTeacherAssessments(schoolAclassTeacherAssessmentVos);

        //查询老师信息
        SysUser sysUser = sysUserService.selectUserByPhone(basicInformation.getDdPhone(), "0");
        if (null == sysUser){
            throw  new RuntimeException("查询人员没有存在系统用户中，请查询该用户手机号"+basicInformation.getDdPhone()+"是否在系统中");
        }
        //4 专业考核
         // * 4.1高考成绩
        SchoolGkAchievementVo schoolGkAchievement = new SchoolGkAchievementVo();
        schoolGkAchievement.setUserId(sysUser.getUserId());
        schoolGkAchievement.setNoAuditState("0");
        List<SchoolGkAchievementVo> schoolGkAchievementVos = schoolGkAchievementService.selectSchoolGkAchievementVoList(schoolGkAchievement);
        comperhensiveVo.setSchoolGkAchievement(schoolGkAchievementVos);
         // *4.2 教学成绩
        SchoolXteachingAchievementsVo schoolXteachingAchievementsVo = new SchoolXteachingAchievementsVo();
//        schoolXteachingAchievementsVo.setUserId(sysUser.getUserId());
        schoolXteachingAchievementsVo.setIdCard(basicInformation.getIdCard());
        List<SchoolXteachingAchievementsVo> schoolXteachingAchievementsVos = schoolXteachingAchievementsService.selectSchoolXteachingAchievementsList(schoolXteachingAchievementsVo);
        comperhensiveVo.setSchoolXteachingAchievements(schoolXteachingAchievementsVos);
        List<SpecialityVo> specialityVos = new ArrayList<>();
        //* 4.3  综合成绩
        SchoolXcomprehensiveHonorsVo vo = new SchoolXcomprehensiveHonorsVo();
        vo.setUserId(sysUser.getUserId());
        vo.setNoAuditState("0");
        List<SchoolXcomprehensiveHonorsVo> schoolXcomprehensiveHonorsVos = schoolXcomprehensiveHonorsService.selectSchoolXcomprehensiveHonorsList(vo);
        for (SchoolXcomprehensiveHonorsVo date : schoolXcomprehensiveHonorsVos){
            SpecialityVo specialityVo = new SpecialityVo();
            specialityVo.setGrowthType("综合荣誉");
            specialityVo.setSub(date.getSub());
            specialityVo.setAwardtype(date.getAwardType());
            specialityVo.setAwardlevel(date.getAwardLevel());
            specialityVo.setAwardrank(date.getAwardRank());
            specialityVo.setResultName(date.getResultName());
            specialityVo.setUserId(date.getUserId());
            specialityVo.setUserName(date.getUserName());
            specialityVo.setOrg(date.getOrg());
            specialityVo.setAwardTime(date.getAwardTime());
            specialityVos.add(specialityVo);
        }

        // * 4.4 教师获奖
        SchoolXteacherAwardsVo schoolXteacherAwardsVo = new SchoolXteacherAwardsVo();
        schoolXteacherAwardsVo.setUserId(sysUser.getUserId());
        List<SchoolXteacherAwardsVo> schoolXteacherAwardsVos = schoolXteacherAwardsService.selectSchoolXteacherAwardsList(schoolXteacherAwardsVo);

        for (SchoolXteacherAwardsVo date : schoolXteacherAwardsVos){
            SpecialityVo specialityVo = new SpecialityVo();
            specialityVo.setGrowthType("教学获奖");
            specialityVo.setSub(date.getSub());
            specialityVo.setAwardtype(date.getAwardType());
            specialityVo.setAwardlevel(date.getAwardLevel());
            specialityVo.setAwardrank(date.getAwardRank());
            specialityVo.setResultName(date.getResultName());
            specialityVo.setUserId(date.getUserId());
            specialityVo.setUserName(date.getUserName());
            specialityVo.setOrg(date.getOrg());
            specialityVo.setAwardTime(date.getAwardTime());
            specialityVos.add(specialityVo);

        }
            // * 4.5 讲课获奖
        SchoolXlectureAwardsVo schoolXlectureAwardsVo = new SchoolXlectureAwardsVo();
        schoolXlectureAwardsVo.setAuditState("0");
        schoolXlectureAwardsVo.setUserId(sysUser.getUserId());
        List<SchoolXlectureAwardsVo> schoolXlectureAwardsVos = schoolXlectureAwardsService.selectSchoolXlectureAwardsList(schoolXlectureAwardsVo);
        for (SchoolXlectureAwardsVo date : schoolXlectureAwardsVos){
            SpecialityVo specialityVo = new SpecialityVo();
            specialityVo.setGrowthType("成长类型");
            specialityVo.setSub(date.getSub());
            specialityVo.setAwardtype(date.getAwardType());
            specialityVo.setAwardlevel(date.getAwardLevel());
            specialityVo.setAwardrank(date.getAwardRank());
            specialityVo.setResultName(date.getResultName());
            specialityVo.setUserId(date.getUserId());
            specialityVo.setUserName(date.getUserName());
            specialityVo.setOrg(date.getOrg());
            specialityVo.setAwardTime(date.getAwardTime());
            specialityVos.add(specialityVo);

        }

           // * 4.6 论文论著
        SchoolXacademicWorksVo schoolXacademicWorksVo = new SchoolXacademicWorksVo();
        schoolXacademicWorksVo.setUserId(sysUser.getUserId());
        schoolXacademicWorksVo.setAuditState("0");
        List<SchoolXacademicWorksVo> schoolXacademicWorksVos = schoolXacademicWorksService.selectSchoolXacademicWorksList(schoolXacademicWorksVo);
        for (SchoolXacademicWorksVo date : schoolXacademicWorksVos){
            SpecialityVo specialityVo = new SpecialityVo();
            specialityVo.setGrowthType("论文论著");
            specialityVo.setSub(date.getSub());
            specialityVo.setAwardtype(date.getAwardType());
            specialityVo.setAwardlevel(date.getAwardLevel());
            specialityVo.setAwardrank(date.getAwardRank());
            specialityVo.setResultName(date.getResultName());
            specialityVo.setUserId(date.getUserId());
            specialityVo.setUserName(date.getUserName());
            specialityVo.setOrg(date.getOrg());
            specialityVo.setAwardTime(date.getAwardTime());
            specialityVos.add(specialityVo);
        }
        // * 4.7课题研究
        SchoolXprojectResearchVo schoolXprojectResearchVo = new SchoolXprojectResearchVo();
        schoolXprojectResearchVo.setUserId(sysUser.getUserId());
        schoolXprojectResearchVo.setAuditState("0");
        List<SchoolXprojectResearchVo> schoolXprojectResearchVos = schoolXprojectResearchService.selectSchoolXprojectResearchList(schoolXprojectResearchVo);
        for (SchoolXprojectResearchVo date : schoolXprojectResearchVos){
            SpecialityVo specialityVo = new SpecialityVo();
            specialityVo.setGrowthType("课题研究");
            specialityVo.setSub(date.getSub());
            specialityVo.setAwardtype(date.getAwardType());
            specialityVo.setAwardlevel(date.getAwardLevel());
            specialityVo.setAwardrank(date.getAwardRank());
            specialityVo.setResultName(date.getResultName());
            specialityVo.setUserId(date.getUserId());
            specialityVo.setUserName(date.getUserName());
            specialityVo.setOrg(date.getOrg());
            specialityVo.setAwardTime(date.getAwardTime());
            specialityVos.add(specialityVo);
        }
        comperhensiveVo.setSpecialityVos(specialityVos);
        //5 辅导教师获奖
        FudaoTeacherVo fudaoTeacher = new FudaoTeacherVo();
        fudaoTeacher.setUserid(sysUser.getUserId());
        List<FudaoTeacherVo> querylist = fudaoTeacherimpl.querylist(fudaoTeacher);
        comperhensiveVo.setFudaoTeacher(querylist);

        //6 辅导学生获奖
        FudaoStudentVo fudaoStudent = new FudaoStudentVo();
        fudaoStudent.setUserid(sysUser.getUserId());
        List<FudaoStudentVo> querylist1 = fudaoStudentImpl.querylist(fudaoStudent);
        comperhensiveVo.setFudaoStudent(querylist1);

        //7 年度考核
        SchoolAnnualAssessmentVo schoolAnnualAssessment = new SchoolAnnualAssessmentVo();
        schoolAnnualAssessment.setIdCard(basicInformation.getIdCard());
        List<SchoolAnnualAssessment> schoolAnnualAssessments = schoolAnnualAssessmentService.selectSchoolAnnualAssessmentList(schoolAnnualAssessment);
        comperhensiveVo.setSchoolAnnualAssessment(schoolAnnualAssessments);

        //8 青年教师成长档案
//        //判断根据名字还是身份证号查询信息
//        if (StringUtils.isNotEmpty(req.getName())){
//            List<SchoolXsyouthTeacher> list = new ArrayList<>();
//            SchoolXsyouthTeacherVo schoolXsyouthTeacherVo = new SchoolXsyouthTeacherVo();
//            schoolXsyouthTeacherVo.setName(req.getName());
//            List<SchoolXsyouthTeacher> schoolXsyouthTeachers = schoolXsyouthTeacherService.selectSchoolXsyouthTeacherList(schoolXsyouthTeacherVo);
//            SchoolXsyouthTeacher schoolXsyouthTeacher = schoolXsyouthTeachers.get(0);
//            list.add(schoolXsyouthTeacher);
//            comperhensiveVo.setSchoolXsyouthTeachers(list);
//        }else if (StringUtils.isNotEmpty(req.getIdCard())){
//            List<SchoolXsyouthTeacher> list = new ArrayList<>();
//            SchoolXsyouthTeacherVo schoolXsyouthTeacherVo = new SchoolXsyouthTeacherVo();
//            schoolXsyouthTeacherVo.setIdCard(req.getIdCard());
//            List<SchoolXsyouthTeacher> schoolXsyouthTeachers = schoolXsyouthTeacherService.selectSchoolXsyouthTeacherList(schoolXsyouthTeacherVo);
//            SchoolXsyouthTeacher schoolXsyouthTeacher = schoolXsyouthTeachers.get(0);
//            list.add(schoolXsyouthTeacher);
//            comperhensiveVo.setSchoolXsyouthTeachers(list);
//        }
        List<SchoolXsyouthTeacher> list = new ArrayList<>();
        SchoolXsyouthTeacherVo schoolXsyouthTeacherVo = new SchoolXsyouthTeacherVo();
        schoolXsyouthTeacherVo.setIdCard(basicInformation.getIdCard());
        List<SchoolXsyouthTeacher> schoolXsyouthTeachers = schoolXsyouthTeacherService.selectSchoolXsyouthTeacherList(schoolXsyouthTeacherVo);
        if (schoolXsyouthTeachers.size() > 0){
            SchoolXsyouthTeacher schoolXsyouthTeacher = schoolXsyouthTeachers.get(0);
            list.add(schoolXsyouthTeacher);
        }
        comperhensiveVo.setSchoolXsyouthTeachers(list);
        return comperhensiveVo;
    }
    public ComperhensiveVo comprehensiveByPhoneNumber(String phoneNumber) throws Exception {
        ComperhensiveVo comperhensiveVo = new ComperhensiveVo();
        //1.查询教师进本信息 判断是根据身份证还是姓名
        if (StringUtils.isNotEmpty(phoneNumber)){
            //根据姓名 查询存在多个 使用list接受返回第一个
            SchoolTeacherBasicInformationVo vo = new SchoolTeacherBasicInformationVo();
            vo.setDdPhone(phoneNumber);
            List<SchoolTeacherBasicInformationVo> list = this.list(vo);
            if (!list.isEmpty()){
                SchoolTeacherBasicInformationVo schoolTeacherBasicInformationVo = list.get(0);
                SchoolTeacherBasicInformationVo schoolTeacherBasicInformationVo1 = this.getByIds(schoolTeacherBasicInformationVo.getId());
                comperhensiveVo.setBasicInformation(schoolTeacherBasicInformationVo1);
            }else {
                throw new RuntimeException("当前教师信息未查到,请您检查教师基本信息是否录入");
            }
        }else {
            throw new RuntimeException("当前教师手机号未传入,请检查您的手机号是完善");
        }

        SchoolTeacherBasicInformationVo basicInformation = comperhensiveVo.getBasicInformation();
        if (null ==  basicInformation  ){
            return comperhensiveVo;
        }

        //2 工作量信息查询 使用身份证查询
        SchoolAworkloadVo schoolAworkload = new SchoolAworkloadVo();
        schoolAworkload.setIdCard(basicInformation.getIdCard());
        List<SchoolAworkloadVo> schoolAworkloadVos = schoolAworkloadService.selectSchoolAworkloadList(schoolAworkload);
        comperhensiveVo.setSchoolAworkload(schoolAworkloadVos);

        //3 班主任考核
        SchoolAclassTeacherAssessmentReq req1 = new SchoolAclassTeacherAssessmentReq();
        req1.setIdCard(basicInformation.getIdCard());
        List<SchoolAclassTeacherAssessmentVo> schoolAclassTeacherAssessmentVos = schoolAclassTeacherAssessmentService.selectSchoolAclassTeacherAssessmentList(req1);
        comperhensiveVo.setSchoolAclassTeacherAssessments(schoolAclassTeacherAssessmentVos);

        //查询老师信息
        SysUser sysUser = sysUserService.selectUserByPhone(basicInformation.getDdPhone(), "0");
        if (null == sysUser){
            throw  new RuntimeException("查询人员没有存在系统用户中，请查询该用户手机号"+basicInformation.getDdPhone()+"是否在系统中");
        }
        //4 专业考核
         // * 4.1高考成绩
        SchoolGkAchievementVo schoolGkAchievement = new SchoolGkAchievementVo();
        schoolGkAchievement.setUserId(sysUser.getUserId());
        List<SchoolGkAchievementVo> schoolGkAchievementVos = schoolGkAchievementService.selectSchoolGkAchievementVoList(schoolGkAchievement);
        comperhensiveVo.setSchoolGkAchievement(schoolGkAchievementVos);
         // *4.2 教学成绩
        SchoolXteachingAchievementsVo schoolXteachingAchievementsVo = new SchoolXteachingAchievementsVo();
        schoolXteachingAchievementsVo.setIdCard(basicInformation.getIdCard());
        List<SchoolXteachingAchievementsVo> schoolXteachingAchievementsVos = schoolXteachingAchievementsService.selectSchoolXteachingAchievementsList(schoolXteachingAchievementsVo);
        comperhensiveVo.setSchoolXteachingAchievements(schoolXteachingAchievementsVos);
        List<SpecialityVo> specialityVos = new ArrayList<>();
        //* 4.3  综合成绩
        SchoolXcomprehensiveHonorsVo vo = new SchoolXcomprehensiveHonorsVo();
        vo.setUserId(sysUser.getUserId());
        List<SchoolXcomprehensiveHonorsVo> schoolXcomprehensiveHonorsVos = schoolXcomprehensiveHonorsService.selectSchoolXcomprehensiveHonorsList(vo);
        for (SchoolXcomprehensiveHonorsVo date : schoolXcomprehensiveHonorsVos){
            SpecialityVo specialityVo = new SpecialityVo();
            specialityVo.setGrowthType("综合荣誉");
            specialityVo.setSub(date.getSub());
            specialityVo.setAwardtype(date.getAwardType());
            specialityVo.setAwardlevel(date.getAwardLevel());
            specialityVo.setAwardrank(date.getAwardRank());
            specialityVo.setResultName(date.getResultName());
            specialityVo.setUserId(date.getUserId());
            specialityVo.setUserName(date.getUserName());
            specialityVo.setOrg(date.getOrg());
            specialityVo.setAwardTime(date.getAwardTime());
            specialityVos.add(specialityVo);
        }

        // * 4.4 教师获奖
        SchoolXteacherAwardsVo schoolXteacherAwardsVo = new SchoolXteacherAwardsVo();
        schoolXteacherAwardsVo.setUserId(sysUser.getUserId());
        List<SchoolXteacherAwardsVo> schoolXteacherAwardsVos = schoolXteacherAwardsService.selectSchoolXteacherAwardsList(schoolXteacherAwardsVo);

        for (SchoolXteacherAwardsVo date : schoolXteacherAwardsVos){
            SpecialityVo specialityVo = new SpecialityVo();
            specialityVo.setGrowthType("教学获奖");
            specialityVo.setSub(date.getSub());
            specialityVo.setAwardtype(date.getAwardType());
            specialityVo.setAwardlevel(date.getAwardLevel());
            specialityVo.setAwardrank(date.getAwardRank());
            specialityVo.setResultName(date.getResultName());
            specialityVo.setUserId(date.getUserId());
            specialityVo.setUserName(date.getUserName());
            specialityVo.setOrg(date.getOrg());
            specialityVo.setAwardTime(date.getAwardTime());
            specialityVos.add(specialityVo);

        }
            // * 4.5 讲课获奖
        SchoolXlectureAwardsVo schoolXlectureAwardsVo = new SchoolXlectureAwardsVo();
        schoolXlectureAwardsVo.setUserId(sysUser.getUserId());
        List<SchoolXlectureAwardsVo> schoolXlectureAwardsVos = schoolXlectureAwardsService.selectSchoolXlectureAwardsList(schoolXlectureAwardsVo);
        for (SchoolXlectureAwardsVo date : schoolXlectureAwardsVos){
            SpecialityVo specialityVo = new SpecialityVo();
            specialityVo.setGrowthType("成长类型");
            specialityVo.setSub(date.getSub());
            specialityVo.setAwardtype(date.getAwardType());
            specialityVo.setAwardlevel(date.getAwardLevel());
            specialityVo.setAwardrank(date.getAwardRank());
            specialityVo.setResultName(date.getResultName());
            specialityVo.setUserId(date.getUserId());
            specialityVo.setUserName(date.getUserName());
            specialityVo.setOrg(date.getOrg());
            specialityVo.setAwardTime(date.getAwardTime());
            specialityVos.add(specialityVo);

        }

           // * 4.6 论文论著
        SchoolXacademicWorksVo schoolXacademicWorksVo = new SchoolXacademicWorksVo();
        schoolXacademicWorksVo.setUserId(sysUser.getUserId());
        List<SchoolXacademicWorksVo> schoolXacademicWorksVos = schoolXacademicWorksService.selectSchoolXacademicWorksList(schoolXacademicWorksVo);
        for (SchoolXacademicWorksVo date : schoolXacademicWorksVos){
            SpecialityVo specialityVo = new SpecialityVo();
            specialityVo.setGrowthType("论文论著");
            specialityVo.setSub(date.getSub());
            specialityVo.setAwardtype(date.getAwardType());
            specialityVo.setAwardlevel(date.getAwardLevel());
            specialityVo.setAwardrank(date.getAwardRank());
            specialityVo.setResultName(date.getResultName());
            specialityVo.setUserId(date.getUserId());
            specialityVo.setUserName(date.getUserName());
            specialityVo.setOrg(date.getOrg());
            specialityVo.setAwardTime(date.getAwardTime());
            specialityVos.add(specialityVo);
        }
        // * 4.7课题研究
        SchoolXprojectResearchVo schoolXprojectResearchVo = new SchoolXprojectResearchVo();
        schoolXprojectResearchVo.setUserId(sysUser.getUserId());
        List<SchoolXprojectResearchVo> schoolXprojectResearchVos = schoolXprojectResearchService.selectSchoolXprojectResearchList(schoolXprojectResearchVo);
        for (SchoolXprojectResearchVo date : schoolXprojectResearchVos){
            SpecialityVo specialityVo = new SpecialityVo();
            specialityVo.setGrowthType("课题研究");
            specialityVo.setSub(date.getSub());
            specialityVo.setAwardtype(date.getAwardType());
            specialityVo.setAwardlevel(date.getAwardLevel());
            specialityVo.setAwardrank(date.getAwardRank());
            specialityVo.setResultName(date.getResultName());
            specialityVo.setUserId(date.getUserId());
            specialityVo.setUserName(date.getUserName());
            specialityVo.setOrg(date.getOrg());
            specialityVo.setAwardTime(date.getAwardTime());
            specialityVos.add(specialityVo);
        }
        comperhensiveVo.setSpecialityVos(specialityVos);
        //5 辅导教师获奖
        FudaoTeacherVo fudaoTeacher = new FudaoTeacherVo();
        fudaoTeacher.setUserid(sysUser.getUserId());
        List<FudaoTeacherVo> querylist = fudaoTeacherimpl.querylist(fudaoTeacher);
        comperhensiveVo.setFudaoTeacher(querylist);

        //6 辅导学生获奖
        FudaoStudentVo fudaoStudent = new FudaoStudentVo();
        fudaoStudent.setUserid(sysUser.getUserId());
        List<FudaoStudentVo> querylist1 = fudaoStudentImpl.querylist(fudaoStudent);
        comperhensiveVo.setFudaoStudent(querylist1);

        //7 年度考核
        SchoolAnnualAssessmentVo schoolAnnualAssessment = new SchoolAnnualAssessmentVo();
        schoolAnnualAssessment.setIdCard(basicInformation.getIdCard());
        List<SchoolAnnualAssessment> schoolAnnualAssessments = schoolAnnualAssessmentService.selectSchoolAnnualAssessmentList(schoolAnnualAssessment);
        comperhensiveVo.setSchoolAnnualAssessment(schoolAnnualAssessments);

        //8 青年教师成长档案
        List<SchoolXsyouthTeacher> list = new ArrayList<>();
        SchoolXsyouthTeacherVo schoolXsyouthTeacherVo = new SchoolXsyouthTeacherVo();
        schoolXsyouthTeacherVo.setIdCard(basicInformation.getIdCard());
        List<SchoolXsyouthTeacher> list1 = schoolXsyouthTeacherService.selectSchoolXsyouthTeacherList(schoolXsyouthTeacherVo);
        if (list1.size() > 0){
            SchoolXsyouthTeacher schoolXsyouthTeacher = list1.get(0);
            list.add(schoolXsyouthTeacher);
        }
        comperhensiveVo.setSchoolXsyouthTeachers(list);
        return comperhensiveVo;
    }
}
