package yangtz.cs.liu.campus.service.impl.schoolNewTeacherDzdn;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolGkAchievement;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolGkAchievementVo;
import yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn.SchoolGkAchievementMapper;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolGkAchievementService;

/**
 * 高考成绩Service业务层处理
 *
 * @author ruoyi
 * @date 2023-12-13
 */
@Service
public class SchoolGkAchievementServiceImpl extends ServiceImpl<SchoolGkAchievementMapper, SchoolGkAchievement> implements ISchoolGkAchievementService
{
    @Autowired
    private SchoolGkAchievementMapper schoolGkAchievementMapper;

    /**
     * 查询高考成绩
     *
     * @param id 高考成绩主键
     * @return 高考成绩
     */
    @Override
    public SchoolGkAchievement selectSchoolGkAchievementById(Long id)
    {
        return schoolGkAchievementMapper.selectSchoolGkAchievementById(id);
    }

    /**
     * 查询高考成绩列表
     *
     * @param schoolGkAchievementVo 高考成绩
     * @return 高考成绩
     */
    @Override
    public List<SchoolGkAchievementVo> selectSchoolGkAchievementVoList(SchoolGkAchievementVo schoolGkAchievementVo)
    {
        return schoolGkAchievementMapper.selectSchoolGkAchievementVoList(schoolGkAchievementVo);
    }
    @Override
    public List<SchoolGkAchievement> selectSchoolGkAchievementList(SchoolGkAchievementVo schoolGkAchievementVo)
    {
        return schoolGkAchievementMapper.selectSchoolGkAchievementList(schoolGkAchievementVo);
    }
    /**
     * 新增高考成绩
     *
     * @param schoolGkAchievement 高考成绩
     * @return 结果
     */
    @Override
    public int insertSchoolGkAchievement(SchoolGkAchievement schoolGkAchievement)
    {
        schoolGkAchievement.setCreateTime(DateUtils.getNowDate());
        return schoolGkAchievementMapper.insertSchoolGkAchievement(schoolGkAchievement);
    }

    /**
     * 修改高考成绩
     *
     * @param schoolGkAchievement 高考成绩
     * @return 结果
     */
    @Override
    public int updateSchoolGkAchievement(SchoolGkAchievement schoolGkAchievement)
    {
        schoolGkAchievement.setUpdateTime(DateUtils.getNowDate());
        return schoolGkAchievementMapper.updateSchoolGkAchievement(schoolGkAchievement);
    }

    /**
     * 批量删除高考成绩
     *
     * @param ids 需要删除的高考成绩主键
     * @return 结果
     */
    @Override
    public int deleteSchoolGkAchievementByIds(Long[] ids)
    {
        return schoolGkAchievementMapper.deleteSchoolGkAchievementByIds(ids);
    }

    /**
     * 删除高考成绩信息
     *
     * @param id 高考成绩主键
     * @return 结果
     */
    @Override
    public int deleteSchoolGkAchievementById(Long id)
    {
        return schoolGkAchievementMapper.deleteSchoolGkAchievementById(id);
    }
}
