package yangtz.cs.liu.campus.service.impl.schoolNewTeacherDzdn;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.DictUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolAworkload;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolAworkloadExport;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolAworkloadVo;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolCheckVo;
import yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn.SchoolAworkloadMapper;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolAworkloadService;

/**
 * 工作量信息Service业务层处理
 *
 * @author ruoyi
 * @date 2023-12-11
 */
@Service
public class SchoolAworkloadServiceImpl  extends ServiceImpl<SchoolAworkloadMapper, SchoolAworkload> implements ISchoolAworkloadService
{
    @Autowired
    private SchoolAworkloadMapper schoolAworkloadMapper;

    @Autowired
    private ISchoolAworkloadService iSchoolAworkloadService;

    /**
     * 查询工作量信息
     *
     * @param id 工作量信息主键
     * @return 工作量信息
     */
    @Override
    public SchoolAworkload selectSchoolAworkloadById(Long id)
    {
        SchoolAworkload date = schoolAworkloadMapper.selectSchoolAworkloadById(id);
//        date.setAmountTo(date.getEarlyReading().add(date.getRequiredCourses()).add(date.getEveningSelfStudy()));
        return date;
    }

    /**
     * 新增并校验
     * @return
     */
    @Override
    public AjaxResult saveAndChecked(List<SchoolAworkload> list) {
        String s = this.dataCheck(list);
        if (!StringUtils.isEmpty(s)){
            return AjaxResult.error(s);
        }
        //1.插入数据
        boolean b = iSchoolAworkloadService.saveBatch(list);
        return AjaxResult.success("导入数据:"+list.size());
    }

     public  String dataCheck(List<SchoolAworkload> list){
         StringBuffer sb = new StringBuffer();
         Integer index = 0;
         SchoolCheckVo schoolCheckVo = null;
          for (SchoolAworkload date: list) {
              index++;
              //非空验证
              //学年
              if (StringUtils.isEmpty(date.getSchoolYear())) {
                  sb.append(index+ "、学年字段不能为空");
                  sb.append("<br/>");
              }

              //学期
              if (StringUtils.isEmpty(date.getSemester())) {
                  sb.append(index+ "、学期字段不能为空");
                  sb.append("<br/>");
              }

              //届别
              if (StringUtils.isEmpty(date.getYear())) {
                  sb.append(index+ "、届别字段不能为空");
                  sb.append("<br/>");
              }

              //年级
              if (StringUtils.isEmpty(date.getGrade())) {
                  sb.append(index+ "、年级字段不能为空");
                  sb.append("<br/>");
              }
              //姓名
              if (StringUtils.isEmpty(date.getName())) {
                  sb.append(index+ "、姓名字段不能为空");
                  sb.append("<br/>");
              }
              //学科
              if (StringUtils.isEmpty(date.getSub())) {
                  sb.append(index+ "、学科字段不能为空");
                  sb.append("<br/>");
              }
              //身份证号
              if (StringUtils.isEmpty(date.getIdCard())) {
                  sb.append(index+ "、身份证号不能为空");
                  sb.append("<br/>");
              }
              //聘任岗位
              if (StringUtils.isEmpty(date.getAppointmentPost())) {
                  sb.append(index+ "、聘任岗位不能为空");
                  sb.append("<br/>");
              }

              //班级
              if (StringUtils.isEmpty(date.getClassName())) {
                  sb.append(index+ "、班级不能为空");
                  sb.append("<br/>");
              }
              //班级类型
              if (StringUtils.isEmpty(date.getClassType())) {
                  sb.append(index+ "、班级类型不能为空");
                  sb.append("<br/>");
              }
//              //早读
//              if (date.getEarlyReading() == null) {
//                  sb.append(index+ "、早读不能为空");
//                  sb.append("<br/>");
//              }
//              //正课
//              if (date.getRequiredCourses() == null) {
//                  sb.append(index+ "、正课不能为空");
//                  sb.append("<br/>");
//              }
//              //晚自习
//              if (date.getEveningSelfStudy() == null) {
//                  sb.append(index+ "、晚自习不能为空");
//                  sb.append("<br/>");
//              }

              //周课时量
              if (date.getWeeklyClassHours() == null) {
                  sb.append(index+ "、周课时量不能为空");
                  sb.append("<br/>");
              }

              //证明人
              if (StringUtils.isEmpty(date.getUserName())) {
                  sb.append(index+ "、证明人不能为空");
                  sb.append("<br/>");
              }
          }
              if (!StringUtils.isEmpty(sb.toString())){
                  return sb.toString();
              }
              //格式验证
         for (SchoolAworkload date: list) {

              //学年
              schoolCheckVo = checkeDicet("yearda", date.getSchoolYear());
              if (schoolCheckVo !=null){
              if (schoolCheckVo.getFlag()){
                  date.setSchoolYear(schoolCheckVo.getVal());
              }else {
                  sb.append(date.getName()+"用户 学年 录入不符合选择项:"+schoolCheckVo.getVal() );
                  sb.append("<br/>");
              }

           }

              //学期
              schoolCheckVo = checkeDicet("semester_jsdzda", date.getSemester());
              if (schoolCheckVo !=null) {
                  if (schoolCheckVo.getFlag()) {
                      date.setSemester(schoolCheckVo.getVal());
                  } else {
                      sb.append(date.getName() + "用户 学期 录入不符合选择项:" + schoolCheckVo.getVal());
                      sb.append("<br/>");
                  }
              }
              //届别
              schoolCheckVo = checkeDicet("rankda", date.getYear());
              if (schoolCheckVo !=null) {
                  if (schoolCheckVo.getFlag()) {
                      date.setYear(schoolCheckVo.getVal());
                  } else {
                      sb.append(date.getName() + "用户 届别 录入不符合选择项:" + schoolCheckVo.getVal());
                      sb.append("<br/>");
                  }
              }
              //年级
              schoolCheckVo = checkeDicet("grade_da", date.getGrade());
              if (schoolCheckVo !=null) {
                  if (schoolCheckVo.getFlag()) {
                      date.setGrade(schoolCheckVo.getVal());
                  } else {
                      sb.append(date.getName() + "用户 年级 录入不符合选择项:" + schoolCheckVo.getVal());
                      sb.append("<br/>");
                  }
              }
              //学科
              schoolCheckVo = checkeDicet("teaching_subjects", date.getSub());
              if (schoolCheckVo !=null) {
                  if (schoolCheckVo.getFlag()) {
                      date.setSub(schoolCheckVo.getVal());
                  } else {
                      sb.append(date.getName() + "用户 学科 录入不符合选择项:" + schoolCheckVo.getVal());
                      sb.append("<br/>");
                  }
              }
              //身份证号
              if (date.getIdCard().length() != 18){
                  sb.append(date.getName()+"用户 身份证号 录入信息错误");
                  sb.append("<br/>");
              }

              //聘任岗位
              schoolCheckVo = checkeDicet("appointment_positions", date.getAppointmentPost());
              if (schoolCheckVo !=null) {
                  if (schoolCheckVo.getFlag()) {
                      date.setAppointmentPost(schoolCheckVo.getVal());
                  } else {
                      sb.append(date.getName() + "用户 聘任岗位 录入不符合选择项:" + schoolCheckVo.getVal());
                      sb.append("<br/>");
                  }
              }
              //聘任情况
              schoolCheckVo = checkeDicet("appointment_situation", date.getAppointmentSituation());
              if (schoolCheckVo !=null) {
                  if (schoolCheckVo.getFlag()) {
                      date.setAppointmentPost(schoolCheckVo.getVal());
                  } else {
                      sb.append(date.getName() + "用户 聘任情况 录入不符合选择项:" + schoolCheckVo.getVal());
                      sb.append("<br/>");
                  }
              }
          }
         return  sb.toString();
    }


    /**
     * 校验时间
     * @param date
     * @return
     */
    public SchoolCheckVo checkeDateTime(Date date){
        SchoolCheckVo sc = new SchoolCheckVo();
        if (null == date){
            sc.setFlag(false);
            sc.setVal(null);
            return sc;
        }
        SimpleDateFormat sdf =  new SimpleDateFormat("yyyy-MM-dd");
        try {
            String format = sdf.format(date);
            sc.setFlag(true);
            sc.setVal(format);
            sc.setDate( DateUtils.parseDate(format));
        }catch (Exception e){
            sc.setFlag(false);
            sc.setVal(date.toString());
        }
        return sc;
    }

    /**
     * 校验字典数据
     * @param type 类型   vlaue 值
     * @return
     * @throws ParseException
     */
    public SchoolCheckVo checkeDicet(String type,String value){
        SchoolCheckVo sc = new SchoolCheckVo();
        if (StringUtils.isEmpty(value)){
            return null;
        }
        if (StringUtils.isEmpty(value)){
                sc.setFlag(false);
                sc.setVal(value);
                return sc;
            }
            //解析值
            String val =  DictUtils.getDictValue(type, value, ",");
            if (StringUtils.isEmpty(val)){
                sc.setFlag(false);
                sc.setVal(value);
                return sc;
            }

            if (StringUtils.isEmpty(val)){
                sc.setFlag(false);
                sc.setVal(value);
            }else {
                sc.setFlag(true);
                sc.setVal(val);
            }
            return sc;
    }
    /**
     * 查询工作量信息列表
     *
     * @param schoolAworkloadVo 工作量信息
     * @return 工作量信息
     */
    @Override
    public List<SchoolAworkloadVo> selectSchoolAworkloadList(SchoolAworkloadVo schoolAworkloadVo)
    {
        List<SchoolAworkloadVo> schoolAworkloadVos = schoolAworkloadMapper.selectSchoolAworkloadList(schoolAworkloadVo);
//        //计算合计
//        for (SchoolAworkloadVo date : schoolAworkloadVos){
//            date.setAmountTo(date.getEarlyReading().add(date.getRequiredCourses()).add(date.getEveningSelfStudy()));
//        }
        return schoolAworkloadVos;
    }


    @Override
    public List<SchoolAworkloadExport> selectAworkloadList(SchoolAworkloadVo schoolAworkloadVo)
    {
        List<SchoolAworkloadExport> schoolAworkloadVos = schoolAworkloadMapper.selectAworkloadList(schoolAworkloadVo);
//        //计算合计
//        for (SchoolAworkloadExport date : schoolAworkloadVos){
//            date.setAmountTo(date.getEarlyReading().add(date.getRequiredCourses()).add(date.getEveningSelfStudy()));
//        }
        return schoolAworkloadVos;
    }


    /**
     * 新增工作量信息
     *
     * @param schoolAworkload 工作量信息
     * @return 结果
     */
    @Override
    public int insertSchoolAworkload(SchoolAworkload schoolAworkload)
    {
        schoolAworkload.setCreateTime(DateUtils.getNowDate());
        return schoolAworkloadMapper.insertSchoolAworkload(schoolAworkload);
    }

    /**
     * 修改工作量信息
     *
     * @param schoolAworkload 工作量信息
     * @return 结果
     */
    @Override
    public int updateSchoolAworkload(SchoolAworkload schoolAworkload)
    {
        schoolAworkload.setUpdateTime(DateUtils.getNowDate());
        return schoolAworkloadMapper.updateSchoolAworkload(schoolAworkload);
    }

    /**
     * 批量删除工作量信息
     *
     * @param ids 需要删除的工作量信息主键
     * @return 结果
     */
    @Override
    public int deleteSchoolAworkloadByIds(Long[] ids)
    {
        return schoolAworkloadMapper.deleteSchoolAworkloadByIds(ids);
    }

    /**
     * 删除工作量信息信息
     *
     * @param id 工作量信息主键
     * @return 结果
     */
    @Override
    public int deleteSchoolAworkloadById(Long id)
    {
        return schoolAworkloadMapper.deleteSchoolAworkloadById(id);
    }
}
