package yangtz.cs.liu.campus.service.impl.schoolNewTeacherDzdn;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.List;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.DictUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.*;
import yangtz.cs.liu.campus.mapper.schoolNewTeacherDzdn.SchoolAclassTeacherAssessmentMapper;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolAclassTeacherAssessmentService;

/**
 * 班主任考核Service业务层处理
 *
 * @author ruoyi
 * @date 2023-12-12
 */
@Service
public class SchoolAclassTeacherAssessmentServiceImpl extends ServiceImpl<SchoolAclassTeacherAssessmentMapper, SchoolAclassTeacherAssessment> implements ISchoolAclassTeacherAssessmentService
{
    @Autowired
    private SchoolAclassTeacherAssessmentMapper schoolAclassTeacherAssessmentMapper;

    @Autowired
    ISchoolAclassTeacherAssessmentService schoolAclassTeacherAssessmentService;

    /**
     * 查询班主任考核
     *
     * @param id 班主任考核主键
     * @return 班主任考核
     */
    @Override
    public SchoolAclassTeacherAssessment selectSchoolAclassTeacherAssessmentById(Long id)
    {
        return schoolAclassTeacherAssessmentMapper.selectSchoolAclassTeacherAssessmentById(id);
    }

    /**
     * 校验数据
     * @param detailList
     * @return
     */
    @Override
    public AjaxResult saveCheckedDate(List<SchoolAclassTeacherAssessment> detailList) {
        String s = this.dataCheck(detailList);
        if (!StringUtils.isEmpty(s)){
            return AjaxResult.error(s);
        }
        boolean b = schoolAclassTeacherAssessmentService.saveBatch(detailList);
        return AjaxResult.success("导入数据:"+detailList.size()+"条");
    }
    public  String dataCheck(List<SchoolAclassTeacherAssessment> list){
        StringBuffer sb = new StringBuffer();
        SchoolCheckVo schoolCheckVo = null;
        Integer index =0;
        for (SchoolAclassTeacherAssessment date :list) {
            index++;
            //非空验证
            //学年
            if (StringUtils.isEmpty(date.getSchoolYear())) {
                sb.append(index+"、学年 字段不能为空");
                sb.append("<br/>");
            }

            //学期
            if (StringUtils.isEmpty(date.getSemester())) {
                sb.append(index+"、学期字段不能为空");
                sb.append("<br/>");
            }

            //届别
            if (StringUtils.isEmpty(date.getYear())) {
                sb.append(index+"、届别字段不能为空");
                sb.append("<br/>");
            }

            //年纪
            if (StringUtils.isEmpty(date.getGrade())) {
                sb.append(index+"、年级字段不能为空");
                sb.append("<br/>");
            }
            //教师姓名
            if (StringUtils.isEmpty(date.getTeacherName())) {
                sb.append(index+"、教师姓名字段不能为空");
                sb.append("<br/>");
            }
            //班级
            if (StringUtils.isEmpty(date.getClassName())) {
                sb.append(index+"、班级字段不能为空");
                sb.append("<br/>");
            }
            //身份证号
            if (StringUtils.isEmpty(date.getIdCard())) {
                sb.append(index+"、身份证号字段不能为空");
                sb.append("<br/>");
            }
            //德育考核成绩
            if (date.getMoralEduCheckAchievement() == null) {
                sb.append(index+"、德育考核成绩字段不能为空");
                sb.append("<br/>");
            }

            //智育考核成绩
            if (date.getIntellEduCheckAchievement() == null) {
                sb.append(index+"、智育考核成绩字段不能为空");
                sb.append("<br/>");
            }

            //总考核成绩
            if (date.getTotalCheckAchievement() == null) {
                sb.append(index+"、总考核成绩字段不能为空");
                sb.append("<br/>");
            }
            //班级类型
            if (StringUtils.isEmpty(date.getClassType())) {
                sb.append(index+"、班级类型字段不能为空");
                sb.append("<br/>");
            }
            //学科
            if (StringUtils.isEmpty(date.getSub())) {
                sb.append(index+"、学科字段不能为空");
                sb.append("<br/>");
            }
            //考核结果
            if (StringUtils.isEmpty(date.getAssessmentResults())) {
                sb.append(index+"、考核结果字段不能为空");
                sb.append("<br/>");
            }
        }
            if (!StringUtils.isEmpty(sb.toString())){
                return sb.toString();
            }

        for (SchoolAclassTeacherAssessment date :list) {
            //类型验证
            //学年
            schoolCheckVo = checkeDicet("yearda", date.getSchoolYear());
            if (schoolCheckVo !=null){
                if (schoolCheckVo.getFlag()){
                    date.setSchoolYear(schoolCheckVo.getVal());
                }else {
                    sb.append(date.getTeacherName()+"用户 学年 录入不符合选择项:"+schoolCheckVo.getVal() );
                    sb.append("<br/>");
                }
            }
            //学期
            schoolCheckVo = checkeDicet("semester_jsdzda", date.getSemester());
            if (schoolCheckVo !=null) {
                if (schoolCheckVo.getFlag()) {
                    date.setSemester(schoolCheckVo.getVal());
                } else {
                    sb.append(date.getTeacherName() + "用户 学期 录入不符合选择项:" + schoolCheckVo.getVal());
                    sb.append("<br/>");
                }
            }
            //届别
            schoolCheckVo = checkeDicet("rankda", date.getYear());
            if (schoolCheckVo !=null) {
                if (schoolCheckVo.getFlag()) {
                    date.setYear(schoolCheckVo.getVal());
                } else {
                    sb.append(date.getTeacherName() + "用户 届别 录入不符合选择项:" + schoolCheckVo.getVal());
                    sb.append("<br/>");
                }
            }
            //年级
            schoolCheckVo = checkeDicet("grade_da", date.getGrade());
            if (schoolCheckVo !=null) {
                if (schoolCheckVo.getFlag()) {
                    date.setGrade(schoolCheckVo.getVal());
                } else {
                    sb.append(date.getTeacherName() + "用户 年级 录入不符合选择项:" + schoolCheckVo.getVal());
                    sb.append("<br/>");
                }
            }
            //学科
            schoolCheckVo = checkeDicet("teaching_subjects", date.getSub());
            if (schoolCheckVo !=null) {
                if (schoolCheckVo.getFlag()) {
                    date.setSub(schoolCheckVo.getVal());
                } else {
                    sb.append(date.getTeacherName() + "用户 学科 录入不符合选择项:" + schoolCheckVo.getVal());
                    sb.append("<br/>");
                }
            }
            //身份证号
            if (date.getIdCard().length() != 18){
                sb.append(date.getTeacherName()+"用户 身份证号 录入信息错误");
                sb.append("<br/>");
            }

            //班级类型
            schoolCheckVo = checkeDicet("class_type", date.getClassType());
            if (schoolCheckVo !=null) {
                if (schoolCheckVo.getFlag()) {
                    date.setClassType(schoolCheckVo.getVal());
                } else {
                    sb.append(date.getTeacherName() + "用户 班级类型 录入不符合选择项:" + schoolCheckVo.getVal());
                    sb.append("<br/>");
                }
            }

            //考核结果
            schoolCheckVo = checkeDicet("assessment_results", date.getAssessmentResults());
            if (schoolCheckVo !=null) {
                if (schoolCheckVo.getFlag()) {
                    date.setAssessmentResults(schoolCheckVo.getVal());
                } else {
                    sb.append(date.getTeacherName() + "用户 考核结果 录入不符合选择项:" + schoolCheckVo.getVal());
                    sb.append("<br/>");
                }
            }
        }

        return sb.toString();

    }

    /**
     * 校验字典数据
     * @param type 类型   vlaue 值
     * @return
     * @throws ParseException
     */
    public SchoolCheckVo checkeDicet(String type, String value){
        SchoolCheckVo sc = new SchoolCheckVo();
        if (StringUtils.isEmpty(value)){
            return null;
        }
        if (StringUtils.isEmpty(value)){
            sc.setFlag(false);
            sc.setVal(value);
            return sc;
        }
        //解析值
        String val =  DictUtils.getDictValue(type, value, ",");
        if (StringUtils.isEmpty(val)){
            sc.setFlag(false);
            sc.setVal(value);
            return sc;
        }

        if (StringUtils.isEmpty(val)){
            sc.setFlag(false);
            sc.setVal(value);
        }else {
            sc.setFlag(true);
            sc.setVal(val);
        }
        return sc;
    }


    /**
     * 查询班主任考核列表
     *
     * @param
     * @return 班主任考核
     */
    @Override
    public List<SchoolAclassTeacherAssessmentVo> selectSchoolAclassTeacherAssessmentList(SchoolAclassTeacherAssessmentReq req)
    {
        //查询条件状
        // 智育考核成绩
        String intellEduCheckAchievement = req.getIntellEduCheckAchievement();
        if (StringUtils.isNotEmpty(intellEduCheckAchievement)){
            this.symbolConversion(req);
        }
        //德育考核成绩
        String moralEduCheckAchievement = req.getMoralEduCheckAchievement();
        if (StringUtils.isNotEmpty(moralEduCheckAchievement)){
            this.wordDateConversion(req);
        }
        return schoolAclassTeacherAssessmentMapper.selectSchoolAclassTeacherAssessmentList(req);
    }


    @Override
    public List<SchoolAclassTeacherAssessment> selectSchoolList(SchoolAclassTeacherAssessmentReq req)
    {
        //查询条件状
        // 智育考核成绩
        String intellEduCheckAchievement = req.getIntellEduCheckAchievement();
        if (StringUtils.isNotEmpty(intellEduCheckAchievement)){
            this.symbolConversion(req);
        }
        //德育考核成绩
        String moralEduCheckAchievement = req.getMoralEduCheckAchievement();
        if (StringUtils.isNotEmpty(moralEduCheckAchievement)){
            this.wordDateConversion(req);
        }
        return schoolAclassTeacherAssessmentMapper.selectSchoolList(req);
    }



    /**
     * 新增班主任考核
     *
     * @param schoolAclassTeacherAssessment 班主任考核
     * @return 结果
     */
    @Override
    public int insertSchoolAclassTeacherAssessment(SchoolAclassTeacherAssessment schoolAclassTeacherAssessment)
    {
        schoolAclassTeacherAssessment.setCreateTime(DateUtils.getNowDate());
        return schoolAclassTeacherAssessmentMapper.insertSchoolAclassTeacherAssessment(schoolAclassTeacherAssessment);
    }

    /**
     * 修改班主任考核
     *
     * @param schoolAclassTeacherAssessment 班主任考核
     * @return 结果
     */
    @Override
    public int updateSchoolAclassTeacherAssessment(SchoolAclassTeacherAssessment schoolAclassTeacherAssessment)
    {
        schoolAclassTeacherAssessment.setUpdateTime(DateUtils.getNowDate());
        return schoolAclassTeacherAssessmentMapper.updateSchoolAclassTeacherAssessment(schoolAclassTeacherAssessment);
    }

    /**
     * 批量删除班主任考核
     *
     * @param ids 需要删除的班主任考核主键
     * @return 结果
     */
    @Override
    public int deleteSchoolAclassTeacherAssessmentByIds(Long[] ids)
    {
        return schoolAclassTeacherAssessmentMapper.deleteSchoolAclassTeacherAssessmentByIds(ids);
    }

    /**
     * 删除班主任考核信息
     *
     * @param id 班主任考核主键
     * @return 结果
     */
    @Override
    public int deleteSchoolAclassTeacherAssessmentById(Long id)
    {
        return schoolAclassTeacherAssessmentMapper.deleteSchoolAclassTeacherAssessmentById(id);
    }

    /**
     * 智育考核成绩
     * @param
     */
    private void symbolConversion(SchoolAclassTeacherAssessmentReq req){
        //智育考核成绩
        String intellEduCheckAchievement = req.getIntellEduCheckAchievement();
        if (intellEduCheckAchievement.contains(">=")) {
            String substring = intellEduCheckAchievement.substring(2, intellEduCheckAchievement.length());
            req.setIntellEduCheckAchievementgtd(new BigDecimal(substring));
            req.setIntellEduCheckAchievement(null);
        } else if (intellEduCheckAchievement.contains("<=")) {
            String substring = intellEduCheckAchievement.substring(2, intellEduCheckAchievement.length());
            req.setIntellEduCheckAchievementltd(new BigDecimal(substring));
            req.setIntellEduCheckAchievement(null);
        } else if (intellEduCheckAchievement.contains("<")) {
            String substring = intellEduCheckAchievement.substring(1, intellEduCheckAchievement.length());
            req.setIntellEduCheckAchievementlt(new BigDecimal(substring));
            req.setIntellEduCheckAchievement(null);
        } else if (intellEduCheckAchievement.contains(">")) {
            String substring = intellEduCheckAchievement.substring(1, intellEduCheckAchievement.length());
            req.setIntellEduCheckAchievementgt(new BigDecimal(substring));
            req.setIntellEduCheckAchievement(null);
        } else if (intellEduCheckAchievement.contains("=")) {
            String substring = intellEduCheckAchievement.substring(1, intellEduCheckAchievement.length());
            req.setIntellEduCheckAchievement(substring);
        }
    }
    /**
     * 参加工作调整
     */

    private void wordDateConversion(SchoolAclassTeacherAssessmentReq req) {
        String moralEduCheckAchievement = req.getMoralEduCheckAchievement();
        if (moralEduCheckAchievement.contains(">=")) {
            String substring = moralEduCheckAchievement.substring(2, moralEduCheckAchievement.length());
            req.setMoralEduCheckAchievementgtd(new BigDecimal(substring));
            req.setMoralEduCheckAchievement(null);
        } else if (moralEduCheckAchievement.contains("<=")) {
            String substring = moralEduCheckAchievement.substring(2, moralEduCheckAchievement.length());
            req.setMoralEduCheckAchievementltd(new BigDecimal(substring));
            req.setMoralEduCheckAchievement(null);
        } else if (moralEduCheckAchievement.contains("<")) {
            String substring = moralEduCheckAchievement.substring(1, moralEduCheckAchievement.length());
            req.setMoralEduCheckAchievementlt(new BigDecimal(substring));
            req.setMoralEduCheckAchievement(null);
        } else if (moralEduCheckAchievement.contains(">")) {
            String substring = moralEduCheckAchievement.substring(1, moralEduCheckAchievement.length());
            req.setMoralEduCheckAchievementgt(new BigDecimal(substring));
            req.setMoralEduCheckAchievement(null);
        } else if (moralEduCheckAchievement.contains("=")) {
            String substring = moralEduCheckAchievement.substring(1, moralEduCheckAchievement.length());
            req.setMoralEduCheckAchievement(substring);
        }


    }

}
