package yangtz.cs.liu.campus.service.impl.schoolLab;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.system.mapper.SysUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLab;
import yangtz.cs.liu.campus.mapper.schoolLab.SchoolLabClassYearMapper;
import yangtz.cs.liu.campus.mapper.schoolLab.SchoolLabMapper;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolLabService;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabClassYearVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolTeacherExperimentApplyVo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 实验室Service业务层处理
 *
 * @author ruoyi
 * @date 2023-08-29
 */
@Service
public class SchoolLabServiceImpl extends ServiceImpl<SchoolLabMapper,SchoolLab> implements ISchoolLabService
{

    @Autowired
    private SchoolLabMapper schoolLabMapper;
    @Autowired
    private SysUserMapper sysUserMapper;

    @Autowired
    private SchoolLabClassYearMapper schoolLabClassYearMapper;
    /**
     * 查询实验室
     *
     * @param id 实验室主键
     * @return 实验室
     */
    @Override
    public SchoolLabVo selectSchoolLabById(Long id)
    {
        return schoolLabMapper.selectSchoolLabById(id);
    }

    /**
     * 查询实验室列表
     *
     * @param schoolLabVo 实验室
     * @return 实验室
     */
    @Override
    public List<SchoolLabVo> selectSchoolLabList(SchoolLabVo schoolLabVo,Long userId)
    {
        SysUser user = null;
        List<SchoolLabVo> list = new ArrayList<>();
        //获取当前登录用户
        if (null == userId){
            user =  SecurityUtils.getLoginUser().getUser();
        }else {
            user = sysUserMapper.selectUserById(userId);
        }
        //获取用户角色集合
        List<SysRole> roles = user.getRoles();

        List<String> labSubs = new ArrayList<>();

        if (user.isAdmin()){
            return schoolLabMapper.selectSchoolLabList(schoolLabVo);
        }

        for (SysRole role : roles) {
            if (role.getRoleKey().equals("admin")){
                return schoolLabMapper.selectSchoolLabList(schoolLabVo);
            }
            switch (role.getRoleKey()){
                case "phy_lab_admin":
                    labSubs.add("1");
                    break;
                case "che_lab_admin":
                    labSubs.add("2");
                    break;
                case "bio_lab_admin":
                    labSubs.add("3");
                    break;
                default:break;
            }
        }
        if (labSubs.size() > 0){
            schoolLabVo.setLabSubs(labSubs);
        }
        return schoolLabMapper.selectSchoolLabList(schoolLabVo);
    }

    /**
     * 新增实验室
     *
     * @param schoolLab 实验室
     * @return 结果
     */
    @Override
    public int insertSchoolLab(SchoolLab schoolLab)
    {
        schoolLab.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolLab.setCreateTime(DateUtils.getNowDate());
        return schoolLabMapper.insertSchoolLab(schoolLab);
    }

    /**
     * 修改实验室
     *
     * @param schoolLab 实验室
     * @return 结果
     */
    @Override
    public int updateSchoolLab(SchoolLab schoolLab)
    {
        schoolLab.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolLab.setUpdateTime(DateUtils.getNowDate());
        return schoolLabMapper.updateSchoolLab(schoolLab);
    }

    /**
     * 批量删除实验室
     *
     * @param ids 需要删除的实验室主键
     * @return 结果
     */
    @Override
    public int deleteSchoolLabByIds(Long[] ids)
    {
        return schoolLabMapper.deleteSchoolLabByIds(ids);
    }

    /**
     * 删除实验室信息
     *
     * @param id 实验室主键
     * @return 结果
     */
    @Override
    public int deleteSchoolLabById(Long id)
    {
        return schoolLabMapper.deleteSchoolLabById(id);
    }

    /**
     * 获取实验室管理员
     */
    @Override
    public List<Map<String, String>> getLabAdmin() {
        List<Map<String, String>> list = new ArrayList<>();
        //获取当前登录用户
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取用户角色集合
        List<SysRole> roles = user.getRoles();
        for (SysRole role : roles) {
            if (role.getRoleKey().equals("admin")){
                return schoolLabMapper.getLabAdminAll();
            }else if (role.getRoleKey().equals("phy_lab_admin")){
                list.add(schoolLabMapper.getLabAdmin(role.getRoleKey(), user.getUserId()));
            }else if (role.getRoleKey().equals("che_lab_admin")){
                list.add(schoolLabMapper.getLabAdmin(role.getRoleKey(),user.getUserId()));
            }else if (role.getRoleKey().equals("bio_lab_admin")){
                list.add(schoolLabMapper.getLabAdmin(role.getRoleKey(),user.getUserId()));
            }
        }
        if (user.isAdmin()){
            return schoolLabMapper.getLabAdminAll();
        }
        if (list.size() <= 0){
            throw new ServiceException("未查询到您实验室管理员信息");
        }
        return list;
    }

    /**
     * 获取学科
     * @return
     */
    @Override
    public List<Map<String, String>> getSub() {
        List<Map<String, String>> list = new ArrayList<>();
        //获取当前登录用户
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取用户角色集合
        List<SysRole> roles = user.getRoles();
        for (SysRole role : roles) {
            if (role.getRoleKey().equals("admin")){
                return schoolLabMapper.getSubAll();
            }else if (role.getRoleKey().equals("phy_lab_admin")){
                list.add(schoolLabMapper.getSub("1"));
            }else if (role.getRoleKey().equals("che_lab_admin")){
                list.add(schoolLabMapper.getSub("2"));
            }else if (role.getRoleKey().equals("bio_lab_admin")){
                list.add(schoolLabMapper.getSub("3"));
            }
        }
        if (user.isAdmin()){
            return schoolLabMapper.getSubAll();
        }
        if (list.size() <= 0){
            throw new ServiceException("为查询到您管理的学科信息");
        }
        return list;
    }
}
