package yangtz.cs.liu.campus.service.impl.schoolLab;

import com.ruoyi.framework.util.UserInfoUtil;
import com.ruoyi.system.mapper.SysUserMapper;
import com.ruoyi.system.service.ISysUserService;
import java.text.SimpleDateFormat;
import java.util.*;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolExperimentPlan;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLab;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabClassYearRelation;
import yangtz.cs.liu.campus.mapper.schoolClass.SchoolClassMapper;
import yangtz.cs.liu.campus.mapper.schoolLab.*;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabClassYear;
import yangtz.cs.liu.campus.mapper.schoolgrade.SchoolGradeMapper;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolExperimentPlanService;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolLabClassYearService;
import yangtz.cs.liu.campus.vo.schoolLab.ClassSituationVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolExperimentPlanVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabClassYearVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabVo;
import yangtz.cs.liu.campus.vo.schoolLab.*;

/**
 * 年级实验室预约Service业务层处理
 *
 * @author ruoyi
 * @date 2023-08-29
 */
@Service
public class SchoolLabClassYearServiceImpl extends ServiceImpl<SchoolLabClassYearMapper,SchoolLabClassYear> implements ISchoolLabClassYearService
{

    @Autowired
    private SchoolLabClassYearMapper schoolLabClassYearMapper;
    @Autowired
    private ISchoolExperimentPlanService schoolExperimentPlanService;
    @Autowired
    private SchoolExperimentPlanMapper schoolExperimentPlanMapper;
    @Autowired
    private SchoolLabMapper schoolLabMapper;
    @Autowired
    private SchoolLabClassYearRelationMapper relationMapper;
    @Autowired
    private SchoolClassMapper schoolClassMapper;

    @Autowired
    private SchoolTeacherLabApplyMapper schoolTeacherLabApplyMapper;
    @Autowired
    private SchoolTeacherExperimentApplyMapper teacherExperimentApplyMapper;

    @Autowired
    private SysUserMapper sysUserMapper;

    @Autowired
    private SchoolGradeMapper schoolGradeMapper;


    @Autowired
    private UserInfoUtil userInfoUtil;


    public String getSub(){
        String sub = null;
        Long userId = userInfoUtil.getMpLoginUser().getUserId();
        SysUser sysUser = sysUserMapper.selectUserById(userId);
        for (SysRole role : sysUser.getRoles()) {
            if (role.getRoleKey().equals("phy_lab_admin")){
                sub = "1";
            }else if (role.getRoleKey().equals("che_lab_admin")){
                sub = "2";
            }else if (role.getRoleKey().equals("bio_lab_admin")){
                sub = "3";
            }
        }
        return sub ;
    }

    /**
     * 查询年级实验室预约
     *
     * @param id 年级实验室预约主键
     * @return 年级实验室预约
     */
    @Override
    public SchoolLabClassYearVo selectSchoolLabClassYearById(Long id)
    {
        SchoolLabClassYearVo schoolLabClassYearVo = schoolLabClassYearMapper.selectSchoolLabClassYearById(id);

        LambdaQueryWrapper<SchoolLabClassYearRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolLabClassYearRelation::getLabClassYearId,schoolLabClassYearVo.getId());
        List<SchoolLabClassYearRelation> relations = relationMapper.selectList(wrapper);
        schoolLabClassYearVo.setSchoolLabClassYearRelationList(relations);
        return schoolLabClassYearVo;
    }

    @Override
    public List<String> convertMentor(List<String> id) {
        List<String> list = new ArrayList<>();
        for (String date :id){
            switch (date){
                case "6":
                    list.add("3");
                    break;
                case "8":
                    list.add("1");
                    break;
                case "9":
                    list.add("2");
                    break;
            }
        }
        return list;
    }

    /**
     * 查询年级实验室预约列表
     *
     * @param schoolLabClassYearVo 年级实验室预约
     * @return 年级实验室预约
     */
    @Override
    public List<SchoolLabClassYearVo> selectSchoolLabClassYearList(SchoolLabClassYearVo schoolLabClassYearVo)
    {
        return schoolLabClassYearMapper.selectSchoolLabClassYearList(schoolLabClassYearVo);
    }

    /**
     * 查询年级实验室预约列表(管理员)
     *
     * @param schoolLabClassYearVo 年级实验室预约
     * @return 年级实验室预约
     */
    @Override
    public List<SchoolLabClassYearVo> selectLabClassYearListAdmin(SchoolLabClassYearVo schoolLabClassYearVo)
    {
        return schoolLabClassYearMapper.selectLabClassYearListAdmin(schoolLabClassYearVo);
    }

    /**
     * 新增年级实验室预约
     *
     * @param schoolLabClassYear 年级实验室预约
     * @return 结果
     */
    @Transactional
    @Override
    public int insertSchoolLabClassYear(SchoolLabClassYear schoolLabClassYear)
    {
        schoolLabClassYear.setCreateTime(DateUtils.getNowDate());
        schoolLabClassYear.setDeclareState("0");
        int rows = schoolLabClassYearMapper.insertSchoolLabClassYear(schoolLabClassYear);
        insertSchoolLabClassYearRelation(schoolLabClassYear);
        return rows;
    }


    @Override
    public List<String> getYearList() {
        return schoolGradeMapper.getYearList();
    }

    /**
     * 新增年级实验室预约和实验室关系信息
     *
     * @param schoolLabClassYear 年级实验室预约对象
     */
    public void insertSchoolLabClassYearRelation(SchoolLabClassYear schoolLabClassYear)
    {
        List<SchoolLabClassYearRelation> schoolLabClassYearRelationList = schoolLabClassYear.getSchoolLabClassYearRelationList();
        Long id = schoolLabClassYear.getId();
        if (StringUtils.isNotNull(schoolLabClassYearRelationList))
        {
            List<SchoolLabClassYearRelation> list = new ArrayList<SchoolLabClassYearRelation>();
            for (SchoolLabClassYearRelation schoolLabClassYearRelation : schoolLabClassYearRelationList)
            {
                schoolLabClassYearRelation.setLabClassYearId(id);
                list.add(schoolLabClassYearRelation);
            }
            if (list.size() > 0)
            {
                schoolLabClassYearMapper.batchSchoolLabClassYearRelation(list);
            }
        }
    }

    /**
     * 修改年级实验室预约
     *
     * @param schoolLabClassYear 年级实验室预约
     * @return 结果
     */
    @Transactional
    @Override
    public int updateSchoolLabClassYear(SchoolLabClassYear schoolLabClassYear)
    {
        schoolLabClassYear.setUpdateTime(DateUtils.getNowDate());
        schoolLabClassYearMapper.deleteSchoolLabClassYearRelationByLabClassYearId(schoolLabClassYear.getId());
        insertSchoolLabClassYearRelation(schoolLabClassYear);
        return schoolLabClassYearMapper.updateSchoolLabClassYear(schoolLabClassYear);
    }

    /**
     * 批量删除年级实验室预约
     *
     * @param ids 需要删除的年级实验室预约主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSchoolLabClassYearByIds(Long[] ids)
    {
        return schoolLabClassYearMapper.deleteSchoolLabClassYearByIds(ids);
    }

    /**
     * 删除年级实验室预约信息
     *
     * @param id 年级实验室预约主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSchoolLabClassYearById(Long id)
    {
        return schoolLabClassYearMapper.deleteSchoolLabClassYearById(id);
    }

    /**
     * 实验室管理-年级实验室预约列表
     * @param schoolLabClassYearVo
     * @return
     */
    @Override
    public List<SchoolLabClassYearVo> getLabClassYear(SchoolLabClassYearVo schoolLabClassYearVo) {
            SysUser user = null;
        if (schoolLabClassYearVo.getUserId() == null){
            //获取当前登录用户
             user = SecurityUtils.getLoginUser().getUser();
        }else {
            user = sysUserMapper.selectUserById(schoolLabClassYearVo.getUserId());
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        //获取用户角色集合
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()){
            List<SchoolLabClassYearVo> labClassYear = schoolLabClassYearMapper.getLabClassYear(schoolLabClassYearVo);
            labClassYear.forEach(list1 -> {
                String semester = "";
                if (list1.getSemester().equals("1")){
                    semester = "上学期";
                }else {
                    semester = "下学期";
                }
                list1.setSchoolYearSemester(list1.getSchoolYear() + semester);
                list1.setPlannedTime(format.format(list1.getPlannedStartTime()) + "至" + format.format(list1.getPlannedEndTime()));
                if (list1.getDeclareState().equals("3") || list1.getDeclareState().equals("2")){
                    LambdaQueryWrapper<SchoolLabClassYearRelation> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(SchoolLabClassYearRelation::getLabClassYearId,list1.getId());
                    List<SchoolLabClassYearRelation> relations = relationMapper.selectList(wrapper);
                    list1.setSchoolLabClassYearRelationList(relations);
                }
            });
            return labClassYear;
        }
        List<String> labSubs = new ArrayList<>();
        for (SysRole role : roles) {
            if (role.getRoleKey().equals("admin")){
                List<SchoolLabClassYearVo> labClassYear = schoolLabClassYearMapper.getLabClassYear(schoolLabClassYearVo);
                labClassYear.forEach(list1 -> {
                    String semester = "";
                    if (list1.getSemester().equals("1")){
                        semester = "上学期";
                    }else {
                        semester = "下学期";
                    }
                    list1.setSchoolYearSemester(list1.getSchoolYear() + semester);
                    list1.setPlannedTime(format.format(list1.getPlannedStartTime()) + "至" + format.format(list1.getPlannedEndTime()));
                    if (list1.getDeclareState().equals("3") || list1.getDeclareState().equals("2")){
                        LambdaQueryWrapper<SchoolLabClassYearRelation> wrapper = new LambdaQueryWrapper<>();
                        wrapper.eq(SchoolLabClassYearRelation::getLabClassYearId,list1.getId());
                        List<SchoolLabClassYearRelation> relations = relationMapper.selectList(wrapper);
                        list1.setSchoolLabClassYearRelationList(relations);
                    }
                });
                return labClassYear;
            }
            switch (role.getRoleKey()){
                case "phy_lab_admin":
                    labSubs.add("1");
                    break;
                case "che_lab_admin":
                    labSubs.add("2");
                    break;
                case "bio_lab_admin":
                    labSubs.add("3");
                    break;
                default:break;
            }
        }
        if (labSubs.size() > 0){
            schoolLabClassYearVo.setSubs(labSubs);
        }

        List<SchoolLabClassYearVo> labClassYear = schoolLabClassYearMapper.getLabClassYear(schoolLabClassYearVo);
        labClassYear.forEach(list1 -> {
            String semester = "";
            if (list1.getSemester().equals("1")){
                semester = "上学期";
            }else {
                semester = "下学期";
            }
            list1.setSchoolYearSemester(list1.getSchoolYear() + semester);
            list1.setPlannedTime(format.format(list1.getPlannedStartTime()) + "至" + format.format(list1.getPlannedEndTime()));
            if (list1.getDeclareState().equals("3") || list1.getDeclareState().equals("2")){
                LambdaQueryWrapper<SchoolLabClassYearRelation> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(SchoolLabClassYearRelation::getLabClassYearId,list1.getId());
                List<SchoolLabClassYearRelation> relations = relationMapper.selectList(wrapper);
                list1.setSchoolLabClassYearRelationList(relations);
            }
        });
        return labClassYear;
    }

    /**
     * 实验室管理-年级实验室-分配实验室
     * @param schoolLabClassYearVo
     * @return
     */
    @Override
    @Transactional
    public int updateLabClassYear(SchoolLabClassYearVo schoolLabClassYearVo) {
        List<SchoolLabClassYearRelation> schoolLabClassYearRelationList = schoolLabClassYearVo.getSchoolLabClassYearRelationList();
        Long id = schoolLabClassYearVo.getId();
        if (schoolLabClassYearRelationList.size() <= 0){
            throw new ServiceException("您未选择实验室");
        }
        List<SchoolLabClassYearRelation> list = new ArrayList<SchoolLabClassYearRelation>();
        for (SchoolLabClassYearRelation schoolLabClassYearRelation : schoolLabClassYearRelationList)
        {
            schoolLabClassYearRelation.setLabClassYearId(id);
            //判断是否选择教室
            if (schoolLabClassYearRelation.getLabId() == -1L){
                schoolLabClassYearRelation.setLabName("教室");
            }else {
                //根据实验是id 查询实验室名称
                SchoolLabVo schoolLabVo = schoolLabMapper.selectSchoolLabById(
                        schoolLabClassYearRelation.getLabId());
                schoolLabClassYearRelation.setLabName(schoolLabVo.getLabName());
            }

            list.add(schoolLabClassYearRelation);
        }
        if (list.size() > 0)
        {
            schoolLabClassYearMapper.deleteSchoolLabClassYearRelationByLabClassYearId(id);
            SchoolLabClassYearVo schoolLabClassYearVo2 = schoolLabClassYearMapper.selectSchoolLabClassYearById(id);
            //判断用户选择的实验室是否正在使用
            SchoolLabClassYearVo schoolLabClassYearVo1 = new SchoolLabClassYearVo();
            schoolLabClassYearVo1.setPlannedStartTime(schoolLabClassYearVo.getPlannedStartTime());
            schoolLabClassYearVo1.setPlannedEndTime(schoolLabClassYearVo.getPlannedEndTime());
            schoolLabClassYearVo1.setSub(schoolLabClassYearVo2.getSub());
            List<Map<String, Object>> labList = getLabList(schoolLabClassYearVo1);
            for (SchoolLabClassYearRelation relation : list) {
                for (Map<String, Object> map : labList) {
                    if (relation.getLabId().equals(Long.parseLong(String.valueOf(map.get("labId"))))){
                        if ("使用中".equals(String.valueOf(map.get("useState")))){
                            throw new ServiceException("您选择的" + map.get("labName") + "实验室正在使用，请重新选择!");
                        }
                    }
                }
            }
            schoolLabClassYearMapper.batchSchoolLabClassYearRelation(list);
        }
        SchoolLabClassYear schoolLabClassYear = new SchoolLabClassYear();
        BeanUtils.copyProperties(schoolLabClassYearVo,schoolLabClassYear);
        return schoolLabClassYearMapper.updateSchoolLabClassYear(schoolLabClassYear);
    }

    /**
     * 获取实验室
     * @return
     */
    @Override
    public List<Map<String, Object>> getLabList(SchoolLabClassYearVo schoolLabClassYearVo) {
        //计划开始时间
        Date plannedStartTime = schoolLabClassYearVo.getPlannedStartTime();
        //计划结束时间
        Date plannedEndTime = schoolLabClassYearVo.getPlannedEndTime();
        List<Map<String, Object>> list = new ArrayList<>();

        LambdaQueryWrapper<SchoolLab> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(SchoolLab::getLabSub,schoolLabClassYearVo.getSub());
        List<SchoolLab> schoolLabs = schoolLabMapper.selectList(wrapper);

        List<String> declareStates = new ArrayList<>();
        declareStates.add("2");
        declareStates.add("3");

        //查询所有已保存已分配实验室的年级实验室预约
        SchoolLabClassYearVo labClassYearVo = new SchoolLabClassYearVo();
        labClassYearVo.setDeclareStates(declareStates);
        List<SchoolLabClassYearVo> schoolLabClassYears = schoolLabClassYearMapper.selectSchoolLabClassYearList(labClassYearVo);

        //查询所有已保存已分配实验室的教师个人实验申请
        SchoolTeacherExperimentApplyVo teacherExperimentApplyVo = new SchoolTeacherExperimentApplyVo();
        teacherExperimentApplyVo.setDeclareStates(declareStates);
        List<SchoolTeacherExperimentApplyVo> teacherExperimentApplyVoList = teacherExperimentApplyMapper.selectSchoolTeacherExperimentApplyList(teacherExperimentApplyVo);

        //在时间范围内的年级实验室预约id集合
        List<Long> labClassYearIds = new ArrayList<>();

        //在时间范围内的教师个人实验申请id集合
        List<Long> teacherExperimentIds = new ArrayList<>();

        //筛选在计划时间范围内的年级实验室预约
        for (SchoolLabClassYearVo schoolLabClassYear : schoolLabClassYears) {
            //开始时间
            Date startTime = schoolLabClassYear.getPlannedStartTime(); //2024-01-01     2023-10-01
            //结束时间
            Date endTime = schoolLabClassYear.getPlannedEndTime();//2024-01-31          2023-10-31
            if ((startTime.after(plannedStartTime) && startTime.before(plannedEndTime)) || (endTime.after(plannedStartTime) && endTime.before(plannedEndTime))
             || (plannedStartTime.after(startTime) && plannedStartTime.before(endTime)) || (plannedEndTime.after(startTime) && plannedEndTime.before(endTime)) ){
                labClassYearIds.add(schoolLabClassYear.getId());
            }
            if (startTime.equals(plannedStartTime) && endTime.equals(plannedEndTime)){
                labClassYearIds.add(schoolLabClassYear.getId());
            }
        }

        //筛选在计划时间范围内的教师个人实验申请
        for (SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo : teacherExperimentApplyVoList) {
            //开始时间
            Date startTime = schoolTeacherExperimentApplyVo.getPlannedStartTime();
            //结束时间
            Date endTime = schoolTeacherExperimentApplyVo.getPlannedEndTime();
            if ((startTime.after(plannedStartTime) && startTime.before(plannedEndTime)) || (endTime.after(plannedStartTime) && endTime.before(plannedEndTime))){
                teacherExperimentIds.add(schoolTeacherExperimentApplyVo.getId());
            }
            if (startTime.equals(plannedStartTime) && endTime.equals(plannedEndTime)){
                teacherExperimentIds.add(schoolTeacherExperimentApplyVo.getId());
            }

        }

        List<Long> labIds = new ArrayList<>();

        if (labClassYearIds.size() > 0){
            //根据年级实验室预约主键id查询实验室id
            List<Long> seletLabId = schoolLabClassYearMapper.seletLabId(labClassYearIds);
            if (seletLabId.size() > 0){
                labIds.addAll(seletLabId);
            }
        }
        if (teacherExperimentIds.size() > 0){
            //根据教师个人实验申请主键id查询实验室id
            List<Long> labIds1 = schoolLabClassYearMapper.seletLabIds(teacherExperimentIds);
            if (labIds1.size() > 0){
                labIds.addAll(labIds1);
            }
        }
        if (labIds.size() > 0){
            for (SchoolLab schoolLab : schoolLabs) {
                Map<String, Object> map = new HashMap<>();
                map.put("labId",schoolLab.getId());
                map.put("labName",schoolLab.getLabName());
                for (Long labId : labIds) {
                    if (schoolLab.getId().equals(labId)){
                        map.put("useState","使用中");
                        break;
                    }else {
                        map.put("useState","空闲");
                    }
                }
                list.add(map);
            }
            Map<String, Object> map = new HashMap<>();
            map.put("labId",-1);
            map.put("labName","教室");
            map.put("useState","空闲");
            list.add(map);
            return list;
        }
        for (SchoolLab schoolLab : schoolLabs) {
            Map<String, Object> map = new HashMap<>();
            map.put("labId",schoolLab.getId());
            map.put("labName",schoolLab.getLabName());
            map.put("useState","空闲");
            list.add(map);
        }
        Map<String, Object> map = new HashMap<>();
        map.put("labId",-1);
        map.put("labName","教室");
        map.put("useState","空闲");
        list.add(map);
        return list;
    }

    /**
     * 实验室管理-年级实验室预约查看详情
     * @param id
     * @return
     */
    @Override
    public SchoolLabClassYearVo getLabClassYearById(Long id) {
        return schoolLabClassYearMapper.getLabClassYearById(id);
    }

    /**
     * 教师-实验室安排列表
     * @param schoolLabClassYearVo
     * @return
     */
    @Override
    public List<SchoolLabClassYearVo> getTeacherLabList(SchoolLabClassYearVo schoolLabClassYearVo) {
        return schoolLabClassYearMapper.getTeacherLabList(schoolLabClassYearVo);
    }

    /**
     * xwh-新增年级预约
     * @param schoolLabClassYear
     * @return
     */
    @Override
    @Transactional
    public int insertSchoolLabClassYearVo(SchoolLabClassYear schoolLabClassYear) {
        int rows = 0;
        //判断计划时间在不在选择的实验计划的时间范围内
        Long experimentPlanId = schoolLabClassYear.getExperimentPlanId();

        SysUser user = SecurityUtils.getLoginUser().getUser();
        schoolLabClassYear.setApplyId(user.getUserId());
        schoolLabClassYear.setApplyName(user.getUserName());
        schoolLabClassYear.setApplyTime(DateUtils.getNowDate());
        schoolLabClassYear.setCreateBy(user.getUserName());
        schoolLabClassYear.setCreateTime(DateUtils.getNowDate());
        rows = schoolLabClassYearMapper.insertSchoolLabClassYear(schoolLabClassYear);

//        SchoolExperimentPlanVo schoolExperimentPlanVo = schoolExperimentPlanService.selectSchoolExperimentPlanById(experimentPlanId);
//        //实验计划开始时间
//        String plannedStartTime = schoolExperimentPlanVo.getPlannedStartTime();
//        //实验计划结束时间
//        String plannedEndTime = schoolExperimentPlanVo.getPlannedEndTime();
//        //年级实验室预约计划开始时间
//        String startTime = DateUtils.formatDate(schoolLabClassYear.getPlannedStartTime());
//        //年级实验室预约计划结束时间
//        String endTime = DateUtils.formatDate(schoolLabClassYear.getPlannedEndTime());

//        int plannedStartMonth = Integer.parseInt(plannedStartTime.substring(5));
//        int plannedEndMonth = Integer.parseInt(plannedEndTime.substring(5));
//
//        int startMonth = Integer.parseInt(startTime.substring(5,7));
//        int endMonth = Integer.parseInt(endTime.substring(5,7));
//
//        if ((startMonth >= plannedStartMonth && startMonth <= plannedEndMonth) && (endMonth >= plannedStartMonth && endMonth <= plannedEndMonth)){
//            SysUser user = SecurityUtils.getLoginUser().getUser();
//            schoolLabClassYear.setApplyId(user.getUserId());
//            schoolLabClassYear.setApplyName(user.getUserName());
//            schoolLabClassYear.setApplyTime(DateUtils.getNowDate());
//            schoolLabClassYear.setCreateBy(user.getUserName());
//            schoolLabClassYear.setCreateTime(DateUtils.getNowDate());
//            rows = schoolLabClassYearMapper.insertSchoolLabClassYear(schoolLabClassYear);
//        }else {
//            throw new ServiceException("请选择实验计划范围内的时间");
//        }

        //修改对应实验计划，预约状态改为已预约
        SchoolExperimentPlan schoolExperimentPlan = new SchoolExperimentPlan();
        schoolExperimentPlan.setId(experimentPlanId);
        schoolExperimentPlan.setIsAppointment("1");
        schoolExperimentPlanMapper.updateById(schoolExperimentPlan);
        return rows;
    }

    /**
     * xwh-修改年级预约
     * @param schoolLabClassYear
     * @return
     */
    @Override
    @Transactional
    public int updateSchoolLabClassYearVo(SchoolLabClassYear schoolLabClassYear) {
        int rows = 0;

        schoolLabClassYear.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolLabClassYear.setUpdateTime(DateUtils.getNowDate());
        rows = schoolLabClassYearMapper.updateSchoolLabClassYear(schoolLabClassYear);

//        //判断计划时间在不在选择的实验计划的时间范围内
//        Long experimentPlanId = schoolLabClassYear.getExperimentPlanId();
//        SchoolExperimentPlanVo schoolExperimentPlanVo = schoolExperimentPlanService.selectSchoolExperimentPlanById(experimentPlanId);
//        //实验计划开始时间
//        String plannedStartTime = schoolExperimentPlanVo.getPlannedStartTime();
//        //实验计划结束时间
//        String plannedEndTime = schoolExperimentPlanVo.getPlannedEndTime();
//        //年级实验室预约计划开始时间
//        String startTime = DateUtils.formatDate(schoolLabClassYear.getPlannedStartTime());
//        //年级实验室预约计划结束时间
//        String endTime = DateUtils.formatDate(schoolLabClassYear.getPlannedEndTime());
//
//        int plannedStartMonth = Integer.parseInt(plannedStartTime.substring(5));
//        int plannedEndMonth = Integer.parseInt(plannedEndTime.substring(5));
//
//        int startMonth = Integer.parseInt(startTime.substring(5,7));
//        int endMonth = Integer.parseInt(endTime.substring(5,7));
//
//        if ((startMonth >= plannedStartMonth && startMonth <= plannedEndMonth) && (endMonth >= plannedStartMonth && endMonth <= plannedEndMonth)){
//            schoolLabClassYear.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
//            schoolLabClassYear.setUpdateTime(DateUtils.getNowDate());
//            rows = schoolLabClassYearMapper.updateSchoolLabClassYear(schoolLabClassYear);
//        }else {
//            throw new ServiceException("请选择实验计划范围内的时间");
//        }
        return rows;
    }

    /**
     * 获取班级统计
     * @param classSituationVo
     * @return
     */
    @Override
    public  List<ClassSituationVo>  classSituation(ClassSituationVo classSituationVo) {
        //1.获取列表获取本级部今年所有的计划
        List<ClassSituationVo> schoolLabClassYears = schoolLabClassYearMapper.classSituation(classSituationVo);
        //2.统计完成情况，拼接信息
        for(ClassSituationVo data :schoolLabClassYears){
            Long classId = data.getClassId();
            //查询班级信息
            SchoolClass schoolClass = schoolClassMapper.selectById(classId);
            data.setGradeId(schoolClass.getGradeId());
            data.setClassName(schoolClass.getClassName());
            data.setSchoolYear(schoolClass.getSchoolYear().toString());
            data.setSemester(classSituationVo.getSemester());
            //查询完成情况
            Integer counts = schoolTeacherLabApplyMapper.selectCompletedQuantity(classSituationVo);
            data.setComplete(counts);
            data.setIncomplete(data.getCount()-counts);
            Integer count = data.getCount();
            Integer bb =  counts / count * 100;
            data.setProportion(bb);
        }
        return schoolLabClassYears;
    }

    /**
     *实验室完成情况
     * @param classSituationVo
     * @return
     */
    @Override
    public List<ClassSituationVo> getexperimentList(ClassSituationVo classSituationVo) {
        //1.获取列表获取本级部今年所有的计划
        List<ClassSituationVo> schoolLab = schoolLabClassYearMapper.getexperimentList(classSituationVo);
        for (ClassSituationVo date :schoolLab){
            SchoolLabClassYearVo schoolLabClassYearsVo =  new SchoolLabClassYearVo();
            schoolLabClassYearsVo.setExperimentPlanId(date.getId());
            List<SchoolLabClassYearVo> schoolLabClassYear = schoolLabClassYearMapper.selectSchoolLabClassYearList(
                    schoolLabClassYearsVo);
            if (schoolLabClassYear.isEmpty()){
                //未申请计划完成为0
                date.setComplete(0);
                date.setIncomplete(date.getCount());
                date.setProportion(0);
                continue;
            }
            classSituationVo.setId(schoolLabClassYear.get(0).getId());
            //1.已完成数量
            Integer counts = schoolTeacherLabApplyMapper.selectCompletedQuantity(classSituationVo);
            date.setComplete(counts);
            date.setIncomplete(date.getCount() - counts);
            Integer bb =  counts / date.getCount() * 100;
            date.setProportion(bb);
        }
        return schoolLab;
    }
}
