package yangtz.cs.liu.campus.service.impl.schoolInfo;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolInfo.SchoolInfoAcquisition;
import yangtz.cs.liu.campus.mapper.schoolInfo.SchoolInfoAcquisitionMapper;
import yangtz.cs.liu.campus.service.schoolInfo.ISchoolInfoAcquisitionService;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;

@Service
public class SchoolInfoAcquisitionServiceImpl extends ServiceImpl<SchoolInfoAcquisitionMapper, SchoolInfoAcquisition> implements ISchoolInfoAcquisitionService {

    @Autowired
    private SchoolInfoAcquisitionMapper acquisitionMapper;

    @Override
    public List<SchoolInfoAcquisition> queryList(SchoolInfoAcquisition acquisition) {
        LambdaQueryWrapper<SchoolInfoAcquisition> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotNull(acquisition.getInfoName()), SchoolInfoAcquisition::getInfoName,acquisition.getInfoName())
                .eq(isNotNull(acquisition.getInfoType()), SchoolInfoAcquisition::getInfoType,acquisition.getInfoType())
                .orderByDesc(SchoolInfoAcquisition::getCreateTime)
                ;
        return acquisitionMapper.selectList(lqw);
    }
}
