package yangtz.cs.liu.campus.service.impl.schoolDcwj;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjAn;
import yangtz.cs.liu.campus.mapper.schoolDcwj.SchoolDcwjAnMapper;
import yangtz.cs.liu.campus.service.schoolDcwj.ISchoolDcwjAnService;

/**
 * 回答结果Service业务层处理
 * 
 * @author wengxiulin
 * @date 2023-03-01
 */
@Service
public class SchoolDcwjAnServiceImpl extends ServiceImpl<SchoolDcwjAnMapper, SchoolDcwjAn> implements ISchoolDcwjAnService
{
    @Autowired
    private SchoolDcwjAnMapper schoolDcwjAnMapper;

    /**
     * 查询回答结果
     * 
     * @param id 回答结果主键
     * @return 回答结果
     */
    @Override
    public SchoolDcwjAn selectSchoolDcwjAnById(Long id)
    {
        return schoolDcwjAnMapper.selectSchoolDcwjAnById(id);
    }

    /**
     * 查询回答结果列表
     * 
     * @param schoolDcwjAn 回答结果
     * @return 回答结果
     */
    @Override
    public List<SchoolDcwjAn> selectSchoolDcwjAnList(SchoolDcwjAn schoolDcwjAn)
    {
        return schoolDcwjAnMapper.selectSchoolDcwjAnList(schoolDcwjAn);
    }

    /**
     * 新增回答结果
     * 
     * @param schoolDcwjAn 回答结果
     * @return 结果
     */
    @Override
    public int insertSchoolDcwjAn(SchoolDcwjAn schoolDcwjAn)
    {
        schoolDcwjAn.setCreateTime(DateUtils.getNowDate());
        return schoolDcwjAnMapper.insertSchoolDcwjAn(schoolDcwjAn);
    }

    /**
     * 修改回答结果
     * 
     * @param schoolDcwjAn 回答结果
     * @return 结果
     */
    @Override
    public int updateSchoolDcwjAn(SchoolDcwjAn schoolDcwjAn)
    {
        schoolDcwjAn.setUpdateTime(DateUtils.getNowDate());
        return schoolDcwjAnMapper.updateSchoolDcwjAn(schoolDcwjAn);
    }

    /**
     * 批量删除回答结果
     * 
     * @param ids 需要删除的回答结果主键
     * @return 结果
     */
    @Override
    public int deleteSchoolDcwjAnByIds(Long[] ids)
    {
        return schoolDcwjAnMapper.deleteSchoolDcwjAnByIds(ids);
    }

    /**
     * 删除回答结果信息
     * 
     * @param id 回答结果主键
     * @return 结果
     */
    @Override
    public int deleteSchoolDcwjAnById(Long id)
    {
        return schoolDcwjAnMapper.deleteSchoolDcwjAnById(id);
    }
}
