package yangtz.cs.liu.campus.service.impl.schoolCurriculum;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolCurriculum.SchoolCurriculum;
import yangtz.cs.liu.campus.mapper.schoolCurriculum.SchoolCurriculumMapper;
import yangtz.cs.liu.campus.service.schoolCurriculum.ISchoolCurriculumService;

@Service
public class SchoolCurriculumServiceImpl extends ServiceImpl<SchoolCurriculumMapper, SchoolCurriculum> implements ISchoolCurriculumService {
    @Autowired
    private SchoolCurriculumMapper schoolCurriculumMapper;

    @Override
    public SchoolCurriculum selectByName(String courseName) {
        LambdaQueryWrapper<SchoolCurriculum> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(SchoolCurriculum::getCourseName,courseName);
        return schoolCurriculumMapper.selectOne(lambdaQueryWrapper);
    }
}
