package yangtz.cs.liu.campus.service.impl.schoolClass;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClassMentor;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGradeMentor;
import yangtz.cs.liu.campus.mapper.schoolClass.SchoolClassMentorMapper;
import yangtz.cs.liu.campus.mapper.schoolgrade.SchoolGradeMentorMapper;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassMentorService;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeMentorService;
import yangtz.cs.liu.campus.vo.schoolClass.SchoolClassMentorVo;
import yangtz.cs.liu.campus.vo.schoolgrade.SchoolGradeMentorVo;

import java.util.List;
import java.util.Map;

@Service
public class SchoolClassMentorImpl extends ServiceImpl<SchoolClassMentorMapper, SchoolClassMentor> implements ISchoolClassMentorService {

    @Autowired
    private SchoolClassMentorMapper schoolClassMentorMapper;

    /**
     * 查询方法
     *
     * @param schoolClassMentorVo
     * @return
     */
    @Override
    public List<SchoolClassMentorVo> selectSchoolClassMentorList(SchoolClassMentorVo schoolClassMentorVo) {
        List<SchoolClassMentorVo> list = schoolClassMentorMapper.selectSchoolClass(schoolClassMentorVo);
        return list;
    }
    /**
     * 查询老师所教的课程
     * @param userId
     * @return
     */
    @Override
    public Map<String,String> selectTeacherGroupMentot(Long userId) {
        return schoolClassMentorMapper.selectTeacherGroupMentot(userId);
    }

    @Override
    public SchoolClassMentorVo selectSchoolClassMentorById(Long id) {
        SchoolClassMentorVo schoolClassMentorVo= schoolClassMentorMapper.selectSchoolClassById(id);
        return schoolClassMentorVo;
    }

    /**
     * 得到老师名字
     *
     * @param schoolClassMentor
     * @return
     */
    @Override
    public String selectTeacherName(SchoolClassMentor schoolClassMentor) {
        String teachername = schoolClassMentorMapper.selectByTeacherName(schoolClassMentor.getTeacherId());
        return teachername;
    }

    @Override
    public SchoolClassMentor selectSchoolClassById(Long id) {
        LambdaQueryWrapper<SchoolClassMentor> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolClassMentor::getId, id);
        SchoolClassMentor schoolClassMentor = schoolClassMentorMapper.selectOne(lqw);
        return schoolClassMentor;
    }


    @Override
    public List<SchoolClassMentorVo> exportByIds(List<Integer> ids,Long classId) {
        return schoolClassMentorMapper.exportByIds(ids,classId);
    }
}

