package yangtz.cs.liu.campus.service.impl.schoolAtt;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolAtt.SchoolAttEa;
import yangtz.cs.liu.campus.mapper.schoolAtt.SchoolAttEaMapper;
import yangtz.cs.liu.campus.service.schoolAtt.ISchoolAttEaService;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;

@Service
public class SchoolAttEaServiceImpl extends ServiceImpl<SchoolAttEaMapper, SchoolAttEa> implements ISchoolAttEaService {

    @Autowired
    private SchoolAttEaMapper eaMapper;

    //根据主表id获取请假详情
    @Override
    public List<SchoolAttEa> getListByAttMonId(Long attMonId) {
        LambdaQueryWrapper<SchoolAttEa> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolAttEa::getAttMonId,attMonId);
        return eaMapper.selectList(lqw);
    }
}
