package yangtz.cs.liu.campus.service.impl.resources;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.resources.SchoolResources;
import yangtz.cs.liu.campus.domain.resources.SchoolResourcesDetails;
import yangtz.cs.liu.campus.mapper.resources.SchoolResourcesDetailsMapper;
import yangtz.cs.liu.campus.service.resources.ISchoolResourcesDetailsService;
import yangtz.cs.liu.campus.vo.resource.SchoolResourcesDetailsVo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

@Service
public class SchoolResourcesDetailsServiceImpl extends ServiceImpl<SchoolResourcesDetailsMapper, SchoolResourcesDetails> implements ISchoolResourcesDetailsService {
    @Autowired
    SchoolResourcesDetailsMapper schoolResourcesDetailsMapper;

    @Override
    public List<SchoolResourcesDetailsVo> queryList(SchoolResourcesDetailsVo schoolResourcesDetailsVo) {
        return schoolResourcesDetailsMapper.queryList(schoolResourcesDetailsVo);
    }

    /**
     * 公众号：更新点赞、收藏、下载
     *
     * @param map
     * @return
     */
    @Override
    public int updateAll(Map map) {
        String clickName = map.get("clickName").toString();
        if (clickName.equals("download")) {      //下载
            return schoolResourcesDetailsMapper.updateDownload(map);
        }
        if (clickName.equals("thumbsUp")) {      //点赞
            return schoolResourcesDetailsMapper.updateThumbsUp(map);
        } else {                                   //收藏
            return schoolResourcesDetailsMapper.updateCollect(map);
        }
    }
}
