package yangtz.cs.liu.campus.service.impl.resources;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.framework.util.UserInfoUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.resources.SchoolResourcesDetailsComment;
import yangtz.cs.liu.campus.mapper.resources.SchoolResourcesDetailsCommentMapper;
import yangtz.cs.liu.campus.service.resources.ISchoolResourcesDetailsCommentService;
import yangtz.cs.liu.wechat.vo.schoolResource.SchoolResourcesDetailsCommentVo;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;

@Service
public class SchoolResourcesDetailsCommentImpl extends ServiceImpl<SchoolResourcesDetailsCommentMapper, SchoolResourcesDetailsComment> implements ISchoolResourcesDetailsCommentService {

    @Autowired
    SchoolResourcesDetailsCommentMapper schoolResourcesDetailsCommentMapper;

    @Override
    public List<SchoolResourcesDetailsComment> querryList(SchoolResourcesDetailsComment schoolResourcesDetailsComment) {
        LambdaQueryWrapper<SchoolResourcesDetailsComment> lwq = new LambdaQueryWrapper<>();
        lwq
                .eq(isNotNull(schoolResourcesDetailsComment.getDetailsId()), SchoolResourcesDetailsComment::getDetailsId, schoolResourcesDetailsComment.getDetailsId())
                .orderByDesc(SchoolResourcesDetailsComment::getCommentTime)
        ;
        return schoolResourcesDetailsCommentMapper.selectList(lwq);
    }


    @Autowired
    private UserInfoUtil userInfoUtil;
    /**
     * 公众号：获取评论列表
     * @param detailsId
     * @return
     */
    @Override
    public List<SchoolResourcesDetailsCommentVo> getComment(Long detailsId) {
        return schoolResourcesDetailsCommentMapper.getComment(detailsId);
    }
}
