package yangtz.cs.liu.campus.service.impl.recruit;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.recruit.SchoolRecruitExam;
import yangtz.cs.liu.campus.domain.recruit.SchoolRecruitProject;
import yangtz.cs.liu.campus.mapper.recruit.SchoolRecruitExamMapper;
import yangtz.cs.liu.campus.mapper.recruit.SchoolRecruitProjectMapper;
import yangtz.cs.liu.campus.service.recruit.ISchoolRecruitProjectService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;


/**
 * 测试项目Service业务层处理
 *
 * @author wengxiulin
 * @date 2023-04-11
 */
@Service
public class SchoolRecruitProjectServiceImpl extends ServiceImpl<SchoolRecruitProjectMapper,SchoolRecruitProject> implements ISchoolRecruitProjectService
{
    @Autowired
    private SchoolRecruitProjectMapper schoolRecruitProjectMapper;

    @Autowired
    private SchoolRecruitExamMapper examMapper;

    /**
     * 查询测试项目列表
     *
     * @param schoolRecruitProject recruit
     * @return recruit
     */
    @Override
    public List<SchoolRecruitProject> selectSchoolRecruitProjectList(SchoolRecruitProject schoolRecruitProject)
    {
        return schoolRecruitProjectMapper.selectSchoolRecruitProjectList(schoolRecruitProject);
    }

    //获取本次考试所能选择的测试项目
    @Override
    public List<SchoolRecruitProject> getProjectList(Long examId,SchoolRecruitProject schoolRecruitProject) {
        SchoolRecruitExam exam = examMapper.selectById(examId);
        String ids = exam.getProjectIds();
        List<String> result = Arrays.asList(ids.split(","));
        List<Long> idList = new ArrayList<>();
        for(String s : result){
            Long l = Long.parseLong(s);
            idList.add(l);
        }
        LambdaQueryWrapper<SchoolRecruitProject> lqw = new LambdaQueryWrapper<>();
        lqw
                .in(SchoolRecruitProject::getId,idList)
                .like(isNotNull(schoolRecruitProject.getProject()),SchoolRecruitProject::getProject,schoolRecruitProject.getProject())
                .orderByAsc(SchoolRecruitProject::getSchoolOrder)
                .orderByDesc(SchoolRecruitProject::getCreateTime);
        return schoolRecruitProjectMapper.selectList(lqw);
    }
}
