package yangtz.cs.liu.campus.service.impl.recruit;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.constant.RecruitExamConstant;
import yangtz.cs.liu.campus.domain.recruit.SchoolRecruitExam;
import yangtz.cs.liu.campus.domain.recruit.SchoolRecruitRelation;
import yangtz.cs.liu.campus.mapper.recruit.SchoolRecruitExamMapper;
import yangtz.cs.liu.campus.mapper.recruit.SchoolRecruitRelationMapper;
import yangtz.cs.liu.campus.service.recruit.ISchoolRecruitExamService;
import yangtz.cs.liu.webpage.vo.WebRecruitExamForStudentVo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;

/**
 * @author xuten
 */
@Service
public class SchoolRecruitExamServiceImpl extends ServiceImpl<SchoolRecruitExamMapper, SchoolRecruitExam> implements ISchoolRecruitExamService {
    @Autowired
    private SchoolRecruitExamMapper recruitExamMapper;

    @Autowired
    private SchoolRecruitRelationMapper relationMapper;

    /**
     * 考务管理-考试管理-列表
     */
    @Override
    public List<SchoolRecruitExam> queryList(SchoolRecruitExam exam) {
        LambdaQueryWrapper<SchoolRecruitExam> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotNull(exam.getExamName()),SchoolRecruitExam::getExamName,exam.getExamName())
                .eq(isNotNull(exam.getStatus()),SchoolRecruitExam::getStatus,exam.getStatus())
                .orderByDesc(SchoolRecruitExam::getCreateTime)
        ;
        return recruitExamMapper.selectList(lqw);
    }

    /**
     * 网页版-考试报名页面处理list
     * */
    @Override
    public List<WebRecruitExamForStudentVo> getRecruitExam(Long studentId) {
        //获取状态是报名状态的考试信息
        LambdaQueryWrapper<SchoolRecruitExam> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolRecruitExam::getStatus, RecruitExamConstant.INFOCHECK)
                .orderByDesc(SchoolRecruitExam::getCreateTime)
        ;
        List<SchoolRecruitExam> examList = recruitExamMapper.selectList(lqw);
        //获取考生报考的考试信息列表
        LambdaQueryWrapper<SchoolRecruitRelation> relaLqw = new LambdaQueryWrapper<>();
        relaLqw
                .eq(SchoolRecruitRelation::getStudentId,studentId)
                .eq(SchoolRecruitRelation::getSubmit,RecruitExamConstant.SUBMIT)
                .orderByDesc(SchoolRecruitRelation::getCreateTime)
        ;
        List<SchoolRecruitRelation> relations = relationMapper.selectList(relaLqw);
        if(StringUtils.isNotNull(relations) && relations.size() > 0){
            List<Long> idList = relations.stream().map(SchoolRecruitRelation::getExamId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper<SchoolRecruitExam> examLqw = new LambdaQueryWrapper<>();
            examLqw.in(SchoolRecruitExam::getId, idList);
            List<SchoolRecruitExam> exams = recruitExamMapper.selectList(examLqw);
            /*//去重
            examList.removeAll(exams);
            //合并list
            examList.addAll(exams);*/
            examList = Stream.of(examList, exams)
                    .flatMap(Collection::stream)
                    .distinct()
                    .collect(Collectors.toList());
        }
        List<WebRecruitExamForStudentVo> list = new ArrayList<>();
        for(SchoolRecruitExam exam : examList){
            WebRecruitExamForStudentVo vo = new WebRecruitExamForStudentVo();
            vo.setId(exam.getId());
            vo.setExamName(exam.getExamName());
            vo.setDeadline(exam.getDeadline());
            /**
             * 当前状态，，，分为未报名和已报名考生（其实也就第二个步骤显示的略有不同）
             * ①当前学生未报名该考试，查不到考试与学生关系，或者可以查到考试与学生关系，提交状态为未提交， 并且考试状态为报名阶段（信息审核）， 则此时当前状态为  报名 ，
             *      若考试状态为其他，则根据考试的状态显示考生可看到的对应的当前状态
             *      例如：考试状态为考场分配，，未报名考生显示报名；
             *      考试状态为成绩发布-未报名考生显示准考证打印；
             *      考试状态为结束-未报名考生显示成绩查询
             * ③用户已完成提交报名，可以查到考试与学生关系，提交状态为已提交，并且此时的考试状态为报名阶段（信息审核），查不到审核状态，  则此时当前状态为  待审核； 如果可以查到审核状态，则显示对应审核状态；
             *      若考试状态为其他，则根据考试的状态显示考生可看到的对应的当前状态
             *      考试状态为考场分配，考生显示审核状态；
             *      考试状态为成绩发布-考生显示准考证打印；
             *      考试状态为结束-考生显示成绩查询
             * */
            SchoolRecruitRelation relation = relationMapper.getRelationByIds(exam.getId(),studentId);
            if(StringUtils.isNull(relation)){
                //未报名，查询不到信息，且考试状态为报名阶段（信息审核）(显示报名)
                if(RecruitExamConstant.INFOCHECK.equals(exam.getStatus())){
                    vo.setCurrentState(RecruitExamConstant.WEBBM);
                } else if (RecruitExamConstant.ADDRESS.equals(exam.getStatus())) {
                    //未报名，查询不到信息，且考试状态为考场分配(显示审核)
                    vo.setCurrentState(RecruitExamConstant.WEBSH);
                } else if (RecruitExamConstant.SCORE.equals(exam.getStatus())) {
                    //未报名，查询不到信息，且考试状态为成绩发布（显示打印准考证）
                    vo.setCurrentState(RecruitExamConstant.WEBZKZDY);
                }else {
                    //未报名，查询不到信息，且考试状态为结束（显示成绩查询）
                    vo.setCurrentState(RecruitExamConstant.WEBCJCX);
                }
            }else {
                //可以查到考生和考试的关系
                //提交状态为未提交，也就是为报名
                if(RecruitExamConstant.NOSUBMIT.equals(relation.getSubmit())){
                    if(RecruitExamConstant.INFOCHECK.equals(exam.getStatus())){
                        //考试处于审核阶段，网页考试状态(显示报名)
                        vo.setCurrentState(RecruitExamConstant.WEBBM);
                    } else if (RecruitExamConstant.ADDRESS.equals(exam.getStatus())) {
                        //未报名，查询不到信息，且考试状态为考场分配(显示审核)
                        vo.setCurrentState(RecruitExamConstant.WEBSH);
                    } else if (RecruitExamConstant.SCORE.equals(exam.getStatus())) {
                        //未报名，查询不到信息，且考试状态为成绩发布（显示打印准考证）
                        vo.setCurrentState(RecruitExamConstant.WEBZKZDY);
                    }else {
                        //未报名，查询不到信息，且考试状态为结束（显示成绩查询）
                        vo.setCurrentState(RecruitExamConstant.WEBCJCX);
                    }
                }else {
                    //已报名
                    if(RecruitExamConstant.INFOCHECK.equals(exam.getStatus())){
                        //在信息审核阶段，显示审核结果
                        /** 审核状态（只存在教育局信息时该字段没有值，0=驳回，1=通过，2 =退回修改,3=待审核） */
                        /**
                         * 考试当前状态（0=报名，1=待审核，2=通过，3=驳回，4=信息修改，5=准考证打印，6=成绩查询，7=审核）
                         * */
                        switch (relation.getAuditStatus()){
                            case "0": vo.setCurrentState(RecruitExamConstant.WEBBH); break;
                            case "1": vo.setCurrentState(RecruitExamConstant.WEBTG); break;
                            case "2": vo.setCurrentState(RecruitExamConstant.WEBXXXG); break;
                            case "3": vo.setCurrentState(RecruitExamConstant.WEBDSH); break;
                        }
                    } else if (RecruitExamConstant.ADDRESS.equals(exam.getStatus())) {
                        //且考试状态为考场分配,显示审核结果
                        switch (relation.getAuditStatus()){
                            case "0": vo.setCurrentState(RecruitExamConstant.WEBBH); break;
                            case "1": vo.setCurrentState(RecruitExamConstant.WEBTG); break;
                            case "2": vo.setCurrentState(RecruitExamConstant.WEBXXXG); break;
                            case "3": vo.setCurrentState(RecruitExamConstant.WEBDSH); break;
                        }
                    } else if (RecruitExamConstant.SCORE.equals(exam.getStatus())) {
                        //考试状态为成绩发布 显示准考证打印
                        vo.setCurrentState(RecruitExamConstant.WEBZKZDY);
                    }else {
                        //未报名，查询不到信息，且考试状态为结束 显示成绩查询
                        vo.setCurrentState(RecruitExamConstant.WEBCJCX);
                    }

                }
            }
            list.add(vo);
        }
        return list;
    }
}
