package yangtz.cs.liu.campus.service.impl.recruit;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.core.utils.StringUtil;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.examination.JuniorHighSchool;
import yangtz.cs.liu.campus.domain.recruit.EduRecruitStudent;
import yangtz.cs.liu.campus.domain.recruit.SchoolRecruitProject;
import yangtz.cs.liu.campus.mapper.examination.JuniorHighSchoolMapper;
import yangtz.cs.liu.campus.mapper.recruit.EduRecruitStudentMapper;
import yangtz.cs.liu.campus.mapper.recruit.SchoolRecruitProjectMapper;
import yangtz.cs.liu.campus.service.recruit.IEduRecruitStudentService;
import yangtz.cs.liu.campus.vo.examination.EduCruitStudentExportVo;
import yangtz.cs.liu.campus.vo.recruit.RecruitEduExportVo;

import java.util.List;

@Service
public class EduRecruitStudentServiceImpl extends ServiceImpl<EduRecruitStudentMapper, EduRecruitStudent> implements IEduRecruitStudentService {
    @Autowired
    private EduRecruitStudentMapper eduRecruitStudentMapper;

    @Autowired
    private SchoolRecruitProjectMapper projectMapper;

    @Autowired
    private JuniorHighSchoolMapper schoolMapper;

    @Override
    public void checkImport(List<EduCruitStudentExportVo> list) {
        //检验是否为空
        if(StringUtils.isNull(list) || list.size() == 0){
            throw new ServiceException("导入数据不能为空");
        }

        // 准备记录日志数据
        int failureNum = 0;
        StringBuilder failureMsg = new StringBuilder();
        for(EduCruitStudentExportVo vo : list){
            if (StringUtils.isEmpty(vo.getEduIdCard())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、身份证号为空,请您重新输入! ");
            }
            if (StringUtils.isEmpty(vo.getEduStudentName())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、姓名为空,请您重新输入! ");
            }
            if (StringUtils.isEmpty(vo.getEduProject())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、测试项目为空,请您重新输入! ");
            }
            if (StringUtils.isEmpty(vo.getEduSex())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、性别为空,请您重新输入! ");
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "很抱歉，导入失败！共 " + failureNum + " 条数据格式不正确，错误如下：");
            throw new ServiceException(failureMsg.toString());
        }
    }

    //数据导入
    @Override
    @Transactional(rollbackFor = Exception.class)
    public String importData(List<EduCruitStudentExportVo> list, Long examId) {
        // 准备记录日志数据
        int successNum = 0;
        StringBuilder successMsg = new StringBuilder();
        int failureNum = 0;
        StringBuilder failureMsg = new StringBuilder();
        for(EduCruitStudentExportVo vo : list){
            LambdaQueryWrapper<EduRecruitStudent> lqw = new LambdaQueryWrapper<>();
            lqw.eq(EduRecruitStudent::getEduIdCard,vo.getEduIdCard()).eq(EduRecruitStudent::getExamId,examId);
            List<EduRecruitStudent> students = eduRecruitStudentMapper.selectList(lqw);
            if(StringUtils.isNotNull(students) && students.size() > 0){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、身份证号" + vo.getEduIdCard() + "重复，请检查！");
            }else{
                EduRecruitStudent student = new EduRecruitStudent();
                student.setExamId(examId);
                //去除空格
                student.setEduIdCard(StringUtil.clearSpace(vo.getEduIdCard()));
                student.setEduStudentName(StringUtil.clearSpace(vo.getEduStudentName()));
                student.setEduProject(StringUtil.clearSpace(vo.getEduProject()));
                student.setEduSex(vo.getEduSex());
                //设置测试项目id
                LambdaQueryWrapper<SchoolRecruitProject> projectLqw = new LambdaQueryWrapper<>();
                projectLqw.eq(SchoolRecruitProject::getProject,StringUtil.clearSpace(vo.getEduProject()));
                List<SchoolRecruitProject> projects = projectMapper.selectList(projectLqw);
                if(StringUtils.isNotNull(projects) && projects.size() > 0){
                    student.setEduTestId(projects.get(0).getId());
                }
                //设置初中学校id
                LambdaQueryWrapper<JuniorHighSchool> schoolLqw = new LambdaQueryWrapper<>();
                List<JuniorHighSchool> schools = schoolMapper.selectList(schoolLqw);
                if(StringUtils.isNotNull(schools) && schools.size() > 0){
                    student.setEduJuniorId(schools.get(0).getId());
                }

                student.insert();
                eduRecruitStudentMapper.insert(student);
                successNum++;
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "很抱歉，导入失败！共 " + failureNum + " 条数据格式不正确，错误如下：");
            throw new ServiceException(failureMsg.toString());
        } else {
            successMsg.insert(0, "恭喜您，数据已全部导入成功！共 " + successNum + " 条");
        }
        return successMsg.toString();
    }
}
