package yangtz.cs.liu.campus.service.impl.patrol;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.system.mapper.SysUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrol;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrolDetails;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.mapper.patrol.SchoolPatrolDetailsMapper;
import yangtz.cs.liu.campus.mapper.patrol.SchoolPatrolMapper;
import yangtz.cs.liu.campus.mapper.schoolgrade.SchoolGradeMapper;
import yangtz.cs.liu.campus.service.patrol.ISchoolPatrolService;
import yangtz.cs.liu.campus.vo.patrol.SchoolPatrolVo;
import yangtz.cs.liu.wechat.vo.patrol.PatrolVo;

import java.util.List;

/**
 * 课堂巡视Service业务层处理
 */
@Service
public class SchoolPatrolServiceImpl extends ServiceImpl<SchoolPatrolMapper, SchoolPatrol> implements ISchoolPatrolService {


    @Autowired
    private SchoolPatrolMapper schoolPatrolMapper;

    @Autowired
    private SchoolPatrolDetailsMapper schoolPatrolDetailsMapper;

    @Autowired
    private SchoolGradeMapper schoolGradeMapper;

    @Autowired
    private SysUserMapper sysUserMapper;

    /**
     * 查询巡视列表
     *
     * @param schoolPatrol
     * @return
     */
    @Override
    public List<SchoolPatrolVo> queryList(SchoolPatrolVo schoolPatrol) {
//        LambdaQueryWrapper<SchoolPatrol> lqw=new LambdaQueryWrapper<>();
//        lqw
//                .eq(isNotNull(schoolPatrol.getGradeValue()),SchoolPatrol::getGradeValue,schoolPatrol.getGradeValue())
//                .eq(isNotNull(schoolPatrol.getClassValue()),SchoolPatrol::getClassValue,schoolPatrol.getClassValue())
//                .like(isNotBlank(schoolPatrol.getRemarks()),SchoolPatrol::getRemarks,schoolPatrol.getRemarks())
//                .eq(isNotNull(schoolPatrol.getPatrolDate()),SchoolPatrol::getPatrolDate,schoolPatrol.getPatrolDate())
//                .like(isNotNull(schoolPatrol.getInspectorId()),SchoolPatrol::getInspectorId,schoolPatrol.getInspectorId())
//                .orderByDesc(SchoolPatrol::getPatrolDate)
//        ;
        List<SchoolPatrolVo> list = schoolPatrolMapper.queryList(schoolPatrol);
        return list;
    }


    /**
     * 重新打分
     *
     * @param patrolId
     * @return
     */
    @Override
    public int rescore(Long patrolId) {
        return schoolPatrolMapper.rescore(patrolId);
    }

    @Override
    public List<SchoolPatrolVo> exportByIds(List<Integer> ids) {
        return schoolPatrolMapper.exportByIds(ids);
    }

    @Override
    public List<PatrolVo> getPatrolList(Long teacherId, Long classId) {
        return schoolPatrolMapper.getPatrolList(teacherId,classId);
    }


}
