package yangtz.cs.liu.campus.service.impl.patrol;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrolRule;
import yangtz.cs.liu.campus.mapper.patrol.SchoolPatrolRuleDetailsMapper;
import yangtz.cs.liu.campus.mapper.patrol.SchoolPatrolRuleMapper;
import yangtz.cs.liu.campus.service.patrol.ISchoolPatrolRuleService;

import java.util.List;

import static org.apache.logging.log4j.util.Strings.isNotBlank;

/**
 * 课堂巡检打分规则业务层
 */
@Service
public class SchoolPatrolRuleServiceImpl extends ServiceImpl<SchoolPatrolRuleMapper, SchoolPatrolRule> implements ISchoolPatrolRuleService {


    @Autowired
    private SchoolPatrolRuleMapper schoolPatrolRuleMapper;


    @Override
    public List<SchoolPatrolRule> queryList(SchoolPatrolRule schoolPatrolRule) {
        LambdaQueryWrapper<SchoolPatrolRule> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotBlank(schoolPatrolRule.getContentType()), SchoolPatrolRule::getContentType, schoolPatrolRule.getContentType())
                .orderByAsc(SchoolPatrolRule::getSort)
        ;
        return schoolPatrolRuleMapper.selectList(lqw);
    }


}
