package yangtz.cs.liu.campus.service.impl.message;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.message.SchoolMessagePushDetails;
import yangtz.cs.liu.campus.mapper.message.SchoolMessagePushDetailsMapper;
import yangtz.cs.liu.campus.service.message.ISchoolMessagePushDetailsService;
import yangtz.cs.liu.campus.vo.message.PushDetailsVO;

import java.util.ArrayList;
import java.util.List;

import static yangtz.cs.liu.campus.constant.MessageConstant.UNREAD;

@Service
public class SchoolMessagePushDetailsServiceImpl extends ServiceImpl<SchoolMessagePushDetailsMapper, SchoolMessagePushDetails> implements ISchoolMessagePushDetailsService {

    @Autowired
    private SchoolMessagePushDetailsMapper detailsMapper;

    //查询某消息推送详情列表
    @Override
    public List<PushDetailsVO> queryList(PushDetailsVO pushDetailsVO) {
        return detailsMapper.queryListByPushId(pushDetailsVO);
    }

    //查询某消息未挂载的用户列表
    @Override
    public List<PushDetailsVO> queryAddList(PushDetailsVO pushDetailsVO) {
        //获取该消息下已有用户id
        List<Long> userIdList = detailsMapper.getUserIdByPushId(pushDetailsVO.getPushId());
        //获取该消息下未挂载的用户信息
        List<PushDetailsVO> list = detailsMapper.selectAddList(userIdList,pushDetailsVO);
        return list;
    }

    //新增，挂载到该消息下
    @Override
    public int addPushDetails(Long pushId, List<Long> userIds) {
        List<SchoolMessagePushDetails> list = new ArrayList<>();
        for(Long userId : userIds){
            SchoolMessagePushDetails details = new SchoolMessagePushDetails();
            details.setPushId(pushId);
            details.setUserId(userId);
            details.setStatus(UNREAD);
            details.insert();
            list.add(details);
        }
        return detailsMapper.insertTeachers(list);
    }
}
