package yangtz.cs.liu.campus.service.impl.message;

import java.util.ArrayList;
import java.util.List;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.message.SchoolMessageParentsPushsDetails;
import yangtz.cs.liu.campus.domain.student.SchoolStudentParent;
import yangtz.cs.liu.campus.mapper.message.SchoolMessageParentsPushsDetailsMapper;
import yangtz.cs.liu.campus.mapper.schoolClass.SchoolClassMapper;
import yangtz.cs.liu.campus.mapper.student.SchoolStudentParentMapper;
import yangtz.cs.liu.campus.service.message.ISchoolMessageParentsPushsDetailsService;
import yangtz.cs.liu.campus.vo.message.ParentsPushsDetailsVO;
import yangtz.cs.liu.campus.vo.message.PushParentVO;
import yangtz.cs.liu.campus.vo.student.SchoolStudentParentVO;

import static yangtz.cs.liu.campus.constant.MessageConstant.UNREAD;

/**
 * 家长消息推送详情Service业务层处理
 *
 * @author ruoyi
 * @date 2022-10-28
 */
@Service
public class SchoolMessageParentsPushsDetailsServiceImpl extends ServiceImpl<SchoolMessageParentsPushsDetailsMapper, SchoolMessageParentsPushsDetails> implements ISchoolMessageParentsPushsDetailsService {
    @Autowired
    private SchoolMessageParentsPushsDetailsMapper parentsPushsDetailsMapper;
    @Autowired
    private SchoolStudentParentMapper parentMapper;
    @Autowired
    private SchoolClassMapper classMapper;

    @Override
    public List<ParentsPushsDetailsVO> queryList(ParentsPushsDetailsVO detailsVO) {
        return parentsPushsDetailsMapper.queryListByPushId(detailsVO);
    }

    //查询某消息未挂载的家长列表
    @Override
    public List<PushParentVO> queryAddList(ParentsPushsDetailsVO detailsVO) {
        //获取该消息下已有家长id
        List<Long> userIdList = parentsPushsDetailsMapper.getUserIdByPushId(detailsVO.getPushId());
        if (userIdList.size() == 0) {
            return new ArrayList<>();
        } else {
            //获取该消息下未挂载的家长信息
            List<PushParentVO> list = parentsPushsDetailsMapper.selectAddList(userIdList, detailsVO);
            return list;
        }
    }

    //新增，挂载到该消息下
    @Override
    public int addPushDetails(Long pushId, List<Long> userIds) {
        List<SchoolMessageParentsPushsDetails> list = new ArrayList<>();
        for (Long userId : userIds) {
            SchoolMessageParentsPushsDetails details = new SchoolMessageParentsPushsDetails();
            details.setPushId(pushId);
            details.setUserId(userId);
            details.setStatus(UNREAD);
            details.insert();
            list.add(details);
        }
        return parentsPushsDetailsMapper.insertParents(list);
    }

    //新增本级部下的家长信息挂载到本消息下
    @Override
    public void saveDetails(Long pushId, List<SchoolStudentParentVO> list) {
            List<SchoolMessageParentsPushsDetails> details = new ArrayList<>();
            for(SchoolStudentParentVO parent : list){
                SchoolMessageParentsPushsDetails detail = new SchoolMessageParentsPushsDetails();
                SchoolStudentParent p = parentMapper.selectById(parent.getId());
                detail.setPushId(pushId);
                detail.setUserId(p.getUserId());
                detail.setStatus(UNREAD);
                detail.insert();
                details.add(detail);
            }
            parentsPushsDetailsMapper.insertParents(details);

    }
}
