package yangtz.cs.liu.campus.service.impl.introduce;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SchoolTeacher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.mapper.introduce.SchoolIntroduceMapper;
import yangtz.cs.liu.campus.mapper.schoolClass.SchoolClassMapper;
import yangtz.cs.liu.campus.mapper.student.SchoolStudentMapper;
import yangtz.cs.liu.campus.mapper.teacher.SchoolTeacherMapper;
import yangtz.cs.liu.campus.service.introduce.ISchoolIntroduceService;
import yangtz.cs.liu.campus.domain.introduce.SchoolIntroduce;
import yangtz.cs.liu.wechat.vo.introduce.SchoolIntroduceVo;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 学校信息Service业务层处理
 */
@Service
public class SchoolIntroduceServiceImpl extends ServiceImpl<SchoolIntroduceMapper, SchoolIntroduce> implements ISchoolIntroduceService {
    @Autowired
    private SchoolIntroduceMapper schoolIntroduceMapper;

    @Autowired
    private SchoolClassMapper schoolClassMapper;

    @Autowired
    private SchoolStudentMapper schoolStudentMapper;

    @Autowired
    private SchoolTeacherMapper schoolTeacherMapper;

    @Override
    public List<SchoolIntroduce> queryList(SchoolIntroduce schoolIntroduce) {
        LambdaQueryWrapper<SchoolIntroduce> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotBlank(schoolIntroduce.getKindergartenName()), SchoolIntroduce::getKindergartenName, schoolIntroduce.getKindergartenName())
                .orderByDesc(SchoolIntroduce::getCreateTime)
        ;
        return schoolIntroduceMapper.selectList(lqw);
    }


    @Override
    public SchoolIntroduceVo getOther(SchoolIntroduceVo schoolIntroduceVo) {
        LambdaQueryWrapper<SchoolClass> classLqw = new LambdaQueryWrapper<>();
        LambdaQueryWrapper<SchoolStudent> studentLqw = new LambdaQueryWrapper<>();
        LambdaQueryWrapper<SchoolTeacher> teacherLqw = new LambdaQueryWrapper<>();
        schoolIntroduceVo.setClasses(schoolClassMapper.selectCount(classLqw));
        schoolIntroduceVo.setStudents(schoolStudentMapper.selectCount(studentLqw));
        schoolIntroduceVo.setTeachers(schoolTeacherMapper.selectCount(teacherLqw));
        return schoolIntroduceVo;
    }

//
//    /**
//     * 查询学校信息
//     *
//     * @param ${pkColumn.javaField} 学校信息主键
//     * @return 学校信息
//     */
//    @Override
//    public SchoolIntroduce selectSchoolIntroduceBy${pkColumn.capJavaField}(${pkColumn.javaType} ${pkColumn.javaField})
//    {
//        return schoolIntroduceMapper.selectSchoolIntroduceBy${pkColumn.capJavaField}(${pkColumn.javaField});
//    }
//
//    /**
//     * 查询学校信息列表
//     *
//     * @param schoolIntroduce 学校信息
//     * @return 学校信息
//     */
//    @Override
//    public List<SchoolIntroduce> selectSchoolIntroduceList(SchoolIntroduce schoolIntroduce)
//    {
//        return schoolIntroduceMapper.selectSchoolIntroduceList(schoolIntroduce);
//    }
//
//    /**
//     * 新增学校信息
//     *
//     * @param schoolIntroduce 学校信息
//     * @return 结果
//     */
//    @Override
//    public int insertSchoolIntroduce(SchoolIntroduce schoolIntroduce)
//    {
//        return schoolIntroduceMapper.insertSchoolIntroduce(schoolIntroduce);
//    }
//
//    /**
//     * 修改学校信息
//     *
//     * @param schoolIntroduce 学校信息
//     * @return 结果
//     */
//    @Override
//    public int updateSchoolIntroduce(SchoolIntroduce schoolIntroduce)
//    {
//        return schoolIntroduceMapper.updateSchoolIntroduce(schoolIntroduce);
//    }
//
//    /**
//     * 批量删除学校信息
//     *
//     * @param ${pkColumn.javaField}s 需要删除的学校信息主键
//     * @return 结果
//     */
//    @Override
//    public int deleteSchoolIntroduceBy${pkColumn.capJavaField}s(${pkColumn.javaType}[] ${pkColumn.javaField}s)
//    {
//        return schoolIntroduceMapper.deleteSchoolIntroduceBy${pkColumn.capJavaField}s(${pkColumn.javaField}s);
//    }
//
//    /**
//     * 删除学校信息信息
//     *
//     * @param ${pkColumn.javaField} 学校信息主键
//     * @return 结果
//     */
//    @Override
//    public int deleteSchoolIntroduceBy${pkColumn.capJavaField}(${pkColumn.javaType} ${pkColumn.javaField})
//    {
//        return schoolIntroduceMapper.deleteSchoolIntroduceBy${pkColumn.capJavaField}(${pkColumn.javaField});
//    }
}
