package yangtz.cs.liu.campus.service.impl.interest;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClassesDetails;
import yangtz.cs.liu.campus.mapper.interest.SchoolInterestClassesDetailsMapper;
import yangtz.cs.liu.campus.mapper.interest.SchoolInterestClassesMapper;
import yangtz.cs.liu.campus.service.interest.ISchoolInterestClassesDetailsService;
import yangtz.cs.liu.campus.vo.interest.DetailsVO;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 兴趣班详情Service业务层处理
 *
 * @author ruoyi
 * @date 2022-10-04
 */
@Service
public class SchoolInterestClassesDetailsServiceImpl extends ServiceImpl<SchoolInterestClassesDetailsMapper, SchoolInterestClassesDetails> implements ISchoolInterestClassesDetailsService {
    @Autowired
    private SchoolInterestClassesDetailsMapper schoolInterestClassesDetailsMapper;
    @Autowired
    private SchoolInterestClassesMapper classesMapper;

    /**
     * 查询兴趣班详情列表
     *
     * @return 兴趣班详情
     */
    @Override
    public List<DetailsVO> queryList(SchoolInterestClassesDetails details) {
        return schoolInterestClassesDetailsMapper.queryList(details);

    }

    /**
     * 查询微信兴趣班详情列表
     * @return 兴趣班详情
     */
//    @Override
//    public List<DetailsVO> queryWxList(Long interestClassesId) {
//        return null;
//    }
}
