package yangtz.cs.liu.campus.service.impl.fudao;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.fudao.FudaoTeacher;
import yangtz.cs.liu.campus.domain.student.SchoolEducationDetails;
import yangtz.cs.liu.campus.mapper.fudao.FudaoTeacherMapper;
import yangtz.cs.liu.campus.mapper.student.SchoolEducationDetailsMapper;
import yangtz.cs.liu.campus.service.fudao.FudaoTeacherService;
import yangtz.cs.liu.campus.service.student.ISchoolEducationDetailsService;
import yangtz.cs.liu.campus.vo.fudao.FudaoTeacherVo;

import java.util.List;

@Service
public class FudaoTeacherImpl extends ServiceImpl<FudaoTeacherMapper, FudaoTeacher> implements FudaoTeacherService {
    @Autowired
    private FudaoTeacherMapper fudaoTeacherMapper;

    @Override
    public List<FudaoTeacherVo> querylist(FudaoTeacherVo fudaoTeacherVo) {
        return fudaoTeacherMapper.querylist(fudaoTeacherVo);
    }

    @Override
    public FudaoTeacherVo selectTutorAwardById(Long id) {
        return fudaoTeacherMapper.selectTutorAwardById(id);
    }


    @Transactional
    @Override
    public int insert(FudaoTeacher fudaoTeacher) {
        fudaoTeacher.setCreateby(SecurityUtils.getUsername());
        fudaoTeacher.setCreatetime(DateUtils.getNowDate());
        int s=fudaoTeacherMapper.add(fudaoTeacher);
//        insertSchoolAccessory(fudaoTeacher);
        return s;
    }

    @Override
    public int delete(Long[] ids) {
        return fudaoTeacherMapper.deleteByIds(ids);
    }


    @Override
    public int updatefudao(FudaoTeacher fudaoTeacher) {
        fudaoTeacher.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        fudaoTeacher.setUpdateTime(DateUtils.getNowDate());
        return fudaoTeacherMapper.updatefudao(fudaoTeacher);
    }

    @Override
    public int submit(FudaoTeacher fudaoTeacher) {
        return fudaoTeacherMapper.updatefudao(fudaoTeacher);
    }


}
