package yangtz.cs.liu.campus.service.impl.fudao;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.fudao.FudaoStudent;
import yangtz.cs.liu.campus.domain.fudao.FudaoTeacher;
import yangtz.cs.liu.campus.mapper.fudao.FudaoStudentMapper;
import yangtz.cs.liu.campus.mapper.fudao.FudaoTeacherMapper;
import yangtz.cs.liu.campus.service.fudao.FudaoStudentService;
import yangtz.cs.liu.campus.service.fudao.FudaoTeacherService;
import yangtz.cs.liu.campus.vo.fudao.FudaoStudentVo;

import java.util.List;

@Service
public class FudaoStudentImpl extends ServiceImpl<FudaoStudentMapper,FudaoStudent> implements FudaoStudentService {

    @Autowired
    private FudaoStudentMapper fudaoStudentMapper;

    @Override
    public List<FudaoStudentVo> querylist(FudaoStudentVo fudaoStudentVo) {
        return fudaoStudentMapper.querylist(fudaoStudentVo);
    }



    @Override
    public int insert(FudaoStudent fudaoStudent) {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        fudaoStudent.setCreateby(user.getUserName());
        fudaoStudent.setCreatetime(DateUtils.getNowDate());
        int s=fudaoStudentMapper.add(fudaoStudent);
//        insertSchoolAccessory(fudaoTeacher);
        return s;
    }

    @Override
    public int delete(Long[] ids) {
        return fudaoStudentMapper.deleteByIds(ids);
    }

    @Override
    public int updatefudao(FudaoStudent fudaoStudent) {
        fudaoStudent.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        fudaoStudent.setUpdateTime(DateUtils.getNowDate());
        return fudaoStudentMapper.updatefudao(fudaoStudent);
    }

    @Override
    public FudaoStudentVo selectTutorStudentById(Long id) {
        return fudaoStudentMapper.selectTutorStudentById(id);
    }

    @Override
    public int submit(FudaoStudent fudaoStudent) {
        return fudaoStudentMapper.updatefudao(fudaoStudent);
    }

}
