package yangtz.cs.liu.campus.service.impl.area;

import java.util.ArrayList;
import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.constant.UserConstants;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.bean.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.area.SchoolArea;
import yangtz.cs.liu.campus.domain.area.SchoolAreaApply;
import yangtz.cs.liu.campus.domain.area.SchoolAreaDetail;
import yangtz.cs.liu.campus.mapper.area.SchoolAreaApplyMapper;
import yangtz.cs.liu.campus.mapper.area.SchoolAreaDetailMapper;
import yangtz.cs.liu.campus.mapper.area.SchoolAreaMapper;
import yangtz.cs.liu.campus.service.area.ISchoolAreaService;
import yangtz.cs.liu.campus.vo.area.AreaVO;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 场地信息Service业务层处理
 *
 * @author ruoyi
 * @date 2022-09-29
 */
@Service
public class SchoolAreaServiceImpl extends ServiceImpl<SchoolAreaMapper, SchoolArea> implements ISchoolAreaService
{
    @Autowired
    private SchoolAreaMapper schoolAreaMapper;
    @Autowired
    private SchoolAreaDetailMapper schoolAreaDetailMapper;
    @Autowired
    private SchoolAreaApplyMapper schoolAreaApplyMapper;

    @Override
    public List<AreaVO> queryList(SchoolArea schoolArea) {
        List<AreaVO> list = schoolAreaMapper.queryList(schoolArea);
        return list;
    }

    //获取详情
    @Override
    public AreaVO queryInfo(Long id) {
        return schoolAreaMapper.queryInfo(id);
    }

    @Override
    public int deleteByIds(List<Long> ids) {
        // areaDetail删除
        LambdaUpdateWrapper<SchoolAreaDetail> detailLuw = new LambdaUpdateWrapper<>();
        detailLuw.in(SchoolAreaDetail::getAreaId,ids);

        schoolAreaDetailMapper.delete(detailLuw);

        // areaApply删除
        LambdaUpdateWrapper<SchoolAreaApply> applyLuw = new LambdaUpdateWrapper<>();

        applyLuw.in(SchoolAreaApply::getAreaId,ids);

        schoolAreaApplyMapper.delete(applyLuw);


         //area主表删除
        return schoolAreaMapper.deleteBatchIds(ids);
    }

    @Override
    public Boolean checkIsExist(SchoolArea schoolArea) {
        Long id = StringUtils.isNull(schoolArea.getId()) ? -1L : schoolArea.getId();
        //场地编号不能重
        LambdaQueryWrapper<SchoolArea> num = new LambdaQueryWrapper<>();
        num.eq(SchoolArea::getAreaNum,schoolArea.getAreaNum());
        SchoolArea areaNum = schoolAreaMapper.selectOne(num);
        //父目录下子场地名称不能重
        LambdaQueryWrapper<SchoolArea> name = new LambdaQueryWrapper<>();
        name.eq(SchoolArea::getAreaName,schoolArea.getAreaName())
                .eq(SchoolArea::getPid,schoolArea.getPid());
        SchoolArea areaName = schoolAreaMapper.selectOne(name);
        //存在
        if (StringUtils.isNotNull(areaNum) && areaNum.getId().longValue() != id.longValue())
        {
            return true;
        }
        if (StringUtils.isNotNull(areaName) && areaName.getId().longValue() != id.longValue())
        {
            return true;
        }
        return false;
    }

    @Override
    public Long selectIdByName(String areaName) {
        LambdaQueryWrapper<SchoolArea> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(isNotBlank(areaName), SchoolArea::getAreaName, areaName)
                .select(SchoolArea::getId)
        ;
        Long areaId = schoolAreaMapper.selectOne(lqw).getId();
        return areaId;
    }

    //是否存在场地子节点
    @Override
    public boolean hasChildById(Long id) {
        int result = schoolAreaMapper.hasChildById(id);
        return result >0;
    }

    //修改场地
    @Override
    public int updateArea(SchoolArea schoolArea) {
        //获取新的父节点
        AreaVO newParentArea = schoolAreaMapper.queryInfo(schoolArea.getPid());
        //获取未修改前的场地信息
        AreaVO oldArea = schoolAreaMapper.queryInfo(schoolArea.getId());

        if (StringUtils.isNotNull(newParentArea) && StringUtils.isNotNull(oldArea))
        {
            String newAncestors = newParentArea.getAncestors() + "," + newParentArea.getId();
            String oldAncestors = oldArea.getAncestors();
            schoolArea.setAncestors(newAncestors);
            updateDeptChildren(schoolArea.getId(), newAncestors, oldAncestors);
        }
        schoolArea.update();
        int result = schoolAreaMapper.updateById(schoolArea);
        return result;
    }

    /**
     * 修改子元素关系
     *
     * @param id 被修改的场地ID
     * @param newAncestors 新的父ID集合
     * @param oldAncestors 旧的父ID集合
     */
    public void updateDeptChildren(Long id, String newAncestors, String oldAncestors)
    {
        List<SchoolArea> children = schoolAreaMapper.selectChildrenAreaById(id);
        for (SchoolArea child : children)
        {
            child.setAncestors(child.getAncestors().replaceFirst(oldAncestors, newAncestors));
        }
        if (children.size() > 0)
        {
            schoolAreaMapper.updateAreaChildren(children);
        }
    }
}
