package yangtz.cs.liu.campus.service.impl.accessory;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.mapper.accessory.AccessoryMapper;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.service.accessory.IAccessoryService;

/**
 * 附件Service业务层处理
 *
 * @author ruoyi
 * @date 2023-07-24
 */
@Service
public class AccessoryServiceImpl extends ServiceImpl<AccessoryMapper, SchoolAccessory> implements IAccessoryService
{
    @Autowired
    private AccessoryMapper accessoryMapper;

    /**
     * 查询附件
     *
     * @param id 附件主键
     * @return 附件
     */
    @Override
    public SchoolAccessory selectAccessoryById(Long id)
    {
        return accessoryMapper.selectAccessoryById(id);
    }

    /**
     * 查询附件列表
     *
     * @param schoolAccessory 附件
     * @return 附件
     */
    @Override
    public List<SchoolAccessory> selectAccessoryList(SchoolAccessory schoolAccessory)
    {
        return accessoryMapper.selectAccessoryList(schoolAccessory);
    }

    /**
     * 新增附件
     *
     * @param schoolAccessory 附件
     * @return 结果
     */
    @Override
    public int insertAccessory(SchoolAccessory schoolAccessory)
    {
        return accessoryMapper.insertAccessory(schoolAccessory);
    }

    /**
     * 修改附件
     *
     * @param schoolAccessory 附件
     * @return 结果
     */
    @Override
    public int updateAccessory(SchoolAccessory schoolAccessory)
    {
        return accessoryMapper.updateAccessory(schoolAccessory);
    }

    /**
     * 批量删除附件
     *
     * @param ids 需要删除的附件主键
     * @return 结果
     */
    @Override
    public int deleteAccessoryByIds(Long[] ids)
    {
        return accessoryMapper.deleteAccessoryByIds(ids);
    }

    /**
     * 删除附件信息
     *
     * @param id 附件主键
     * @return 结果
     */
    @Override
    public int deleteAccessoryById(Long id)
    {
        return accessoryMapper.deleteAccessoryById(id);
    }
}
