package yangtz.cs.liu.campus.service.impl.SchoolStudentIntegral;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.SchoolStudentIntegral.SchoolStudentIntegral;
import yangtz.cs.liu.campus.mapper.SchoolStudentIntegralMapper.SchoolStudentIntegralMapper;
import yangtz.cs.liu.campus.service.ISchoolStudentIntegra.ISchoolStudentIntegralService;


/**
 * 学生积分Service业务层处理
 *
 * @author hxz
 * @date 2023-02-23
 */
@Service
public class SchoolStudentIntegralServiceImpl  extends ServiceImpl<SchoolStudentIntegralMapper,SchoolStudentIntegral> implements ISchoolStudentIntegralService
{
    @Autowired
    private SchoolStudentIntegralMapper schoolStudentIntegralMapper;
    //惩罚
    public static final String NOREWAER = "0";
    //奖励
    public static final String REWAER = "1";

    /**
     * 查询学生积分
     *
     * @param id 学生积分主键
     * @return 学生积分
     */
    @Override
    public SchoolStudentIntegral selectSchoolStudentIntegralById(Long id)
    {
        return schoolStudentIntegralMapper.selectSchoolStudentIntegralById(id);
    }

    /**
     * 查询学生积分列表
     *
     * @param schoolStudentIntegral 学生积分
     * @return 学生积分
     */
    @Override
    public List<SchoolStudentIntegral> selectSchoolStudentIntegralList(SchoolStudentIntegral schoolStudentIntegral)
    {
        return schoolStudentIntegralMapper.selectSchoolStudentIntegralList(schoolStudentIntegral);
    }

    /**
     * 新增学生积分
     *
     * @param schoolStudentIntegral 学生积分
     * @return 结果
     */
    @Override
    public int insertSchoolStudentIntegral(SchoolStudentIntegral schoolStudentIntegral)
    {
        return schoolStudentIntegralMapper.insertSchoolStudentIntegral(schoolStudentIntegral);
    }

    /**
     * 修改学生积分
     *
     * @param schoolStudentIntegral 学生积分
     * @return 结果
     */
    @Override
    public int updateSchoolStudentIntegral(SchoolStudentIntegral schoolStudentIntegral)
    {
        schoolStudentIntegral.setUpdateTime(DateUtils.getNowDate());
        return schoolStudentIntegralMapper.updateSchoolStudentIntegral(schoolStudentIntegral);
    }

    /**
     * 批量删除学生积分
     *
     * @param ids 需要删除的学生积分主键
     * @return 结果
     */
    @Override
    public int deleteSchoolStudentIntegralByIds(Long[] ids)
    {
        return schoolStudentIntegralMapper.deleteSchoolStudentIntegralByIds(ids);
    }

    /**
     * 删除学生积分信息
     *
     * @param id 学生积分主键
     * @return 结果
     */
    @Override
    public int deleteSchoolStudentIntegralById(Long id)
    {
        return schoolStudentIntegralMapper.deleteSchoolStudentIntegralById(id);
    }

    /**计算学生积分*/
    @Override
    public Double countScore(List<SchoolStudentIntegral> integrals) {
        Double sum = 100.0;
        for(SchoolStudentIntegral integral : integrals){
            if(NOREWAER.equals(integral.getIsReward())){
                sum = sum - integral.getScore();
            } else if (REWAER.equals(integral.getIsReward())) {
                sum = sum + integral.getScore();
            }
        }
        return sum;
    }
}
