package yangtz.cs.liu.campus.service.award;

import java.util.List;
import yangtz.cs.liu.campus.domain.award.Award;

/**
 * 获奖情况Service接口
 *
 * @author ruoyi
 * @date 2023-07-25
 */
public interface IAwardService
{
    /**
     * 查询获奖情况
     *
     * @param id 获奖情况主键
     * @return 获奖情况
     */
    public Award selectAwardById(Long id);

    /**
     * 查询获奖情况列表
     *
     * @param award 获奖情况
     * @return 获奖情况集合
     */
    public List<Award> selectAwardList(Award award);

    /**
     * 新增获奖情况
     *
     * @param award 获奖情况
     * @return 结果
     */
    public int insertAward(Award award);

    /**
     * 修改获奖情况
     *
     * @param award 获奖情况
     * @return 结果
     */
    public int updateAward(Award award);

    /**
     * 批量删除获奖情况
     *
     * @param ids 需要删除的获奖情况主键集合
     * @return 结果
     */
    public int deleteAwardByIds(Long[] ids);

    /**
     * 删除获奖情况信息
     *
     * @param id 获奖情况主键
     * @return 结果
     */
    public int deleteAwardById(Long id);
}
