package yangtz.cs.liu.campus.service.auditorium;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.auditorium.SchoolAuditorium;
import yangtz.cs.liu.campus.vo.auditorium.SchoolAuditoriumVo;

import java.util.List;
import java.util.Map;

/**
 * 学校礼堂预约Service接口
 *
 * @author ruoyi
 * @date 2023-06-14
 */
public interface ISchoolAuditoriumService extends IService<SchoolAuditorium>
{
    /**
     * 查询学校礼堂预约
     *
     * @param id 学校礼堂预约主键
     * @return 学校礼堂预约
     */
    public SchoolAuditoriumVo selectSchoolAuditoriumById(Long id);

    /**
     * 查询全部学校礼堂预约列表
     *
     * @param schoolAuditorium 学校礼堂预约
     * @return 学校礼堂预约集合
     */
    public List<SchoolAuditoriumVo> selectSchoolAuditoriumList(SchoolAuditoriumVo schoolAuditorium);

    /**
     * 新增学校礼堂预约
     *
     * @param schoolAuditorium 学校礼堂预约
     * @return 结果
     */
    public int insertSchoolAuditorium(SchoolAuditorium schoolAuditorium);

    /**
     * 修改学校礼堂预约
     *
     * @param schoolAuditorium 学校礼堂预约
     * @return 结果
     */
    public int updateSchoolAuditorium(SchoolAuditorium schoolAuditorium);

    /**
     * 批量删除学校礼堂预约
     *
     * @param ids 需要删除的学校礼堂预约主键集合
     * @return 结果
     */
    public int deleteSchoolAuditoriumByIds(Long[] ids);

    /**
     * 删除学校礼堂预约信息
     *
     * @param id 学校礼堂预约主键
     * @return 结果
     */
    public int deleteSchoolAuditoriumById(Long id);

    /**
     * 流程定义
     * @param schoolAuditorium
     * @param username
     * @param key
     * @param variables
     */
    public int submitApply(SchoolAuditorium schoolAuditorium , String username, String key, Map<String, Object> variables);

    /**
     * 查询个人学校礼堂预约列表
     * @param schoolAuditorium
     * @return
     */
    List<SchoolAuditoriumVo> selectSchoolAuditoriumListGr(SchoolAuditoriumVo schoolAuditorium);

    /**
     * 待办列表
     *
     * @param entity
     * @param userId
     * @return
     */
    List<SchoolAuditoriumVo> findTodoTasks(String key, SchoolAuditorium entity, String userId);

    /**
     * 已办列表
     * @param key
     * @param entity
     * @param userId
     * @return
     */
    List<SchoolAuditoriumVo> findDoneTasks(String key, SchoolAuditorium entity, String userId);

    /**
     * 发送钉钉审批实例
     * @param schoolAuditorium
     */
    String sendDdInstance(SchoolAuditorium schoolAuditorium);
}
