package yangtz.cs.liu.campus.service.ISchoolStudentIntegra;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.SchoolStudentIntegral.SchoolStudentIntegral;
import yangtz.cs.liu.campus.service.student.ISchoolStudentService;

/**
 * 学生积分Service接口
 *
 * @author hxz
 * @date 2023-02-23
 */
public interface ISchoolStudentIntegralService extends IService<SchoolStudentIntegral>
{
    /**
     * 查询学生积分
     *
     * @param id 学生积分主键
     * @return 学生积分
     */
    public SchoolStudentIntegral selectSchoolStudentIntegralById(Long id);

    /**
     * 查询学生积分列表
     *
     * @param schoolStudentIntegral 学生积分
     * @return 学生积分集合
     */
    public List<SchoolStudentIntegral> selectSchoolStudentIntegralList(SchoolStudentIntegral schoolStudentIntegral);

    /**
     * 新增学生积分
     *
     * @param schoolStudentIntegral 学生积分
     * @return 结果
     */
    public int insertSchoolStudentIntegral(SchoolStudentIntegral schoolStudentIntegral);

    /**
     * 修改学生积分
     *
     * @param schoolStudentIntegral 学生积分
     * @return 结果
     */
    public int updateSchoolStudentIntegral(SchoolStudentIntegral schoolStudentIntegral);

    /**
     * 批量删除学生积分
     *
     * @param ids 需要删除的学生积分主键集合
     * @return 结果
     */
    public int deleteSchoolStudentIntegralByIds(Long[] ids);

    /**
     * 删除学生积分信息
     *
     * @param id 学生积分主键
     * @return 结果
     */
    public int deleteSchoolStudentIntegralById(Long id);

    //计算学生积分
    public Double countScore(List<SchoolStudentIntegral> integrals);
}
