package yangtz.cs.liu.campus.mapper.teacherFiles;

import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesTraining;
import yangtz.cs.liu.campus.domain.training.Training;

import java.util.List;
import java.util.Map;

/**
 * 教师档案培训情况Mapper接口
 * 
 * @author ruoyi
 * @date 2023-09-08
 */
public interface TeacherFilesTrainingMapper 
{
    /**
     * 查询教师档案培训情况
     * 
     * @param id 教师档案培训情况主键
     * @return 教师档案培训情况
     */
    public TeacherFilesTraining selectTeacherFilesTrainingById(Long id);

    /**
     * 查询教师档案培训情况列表
     * 
     * @param teacherFilesTraining 教师档案培训情况
     * @return 教师档案培训情况集合
     */
    public List<TeacherFilesTraining> selectTeacherFilesTrainingList(TeacherFilesTraining teacherFilesTraining);

    public List<TeacherFilesTraining> selectTeacherFilesTrainingListByFilesId(Long filesId);

    /**
     * 新增教师档案培训情况
     * 
     * @param teacherFilesTraining 教师档案培训情况
     * @return 结果
     */
    public int insertTeacherFilesTraining(TeacherFilesTraining teacherFilesTraining);

    /**
     * 修改教师档案培训情况
     * 
     * @param teacherFilesTraining 教师档案培训情况
     * @return 结果
     */
    public int updateTeacherFilesTraining(TeacherFilesTraining teacherFilesTraining);

    /**
     * 删除教师档案培训情况
     * 
     * @param id 教师档案培训情况主键
     * @return 结果
     */
    public int deleteTeacherFilesTrainingById(Long id);

    public int deleteTeacherFilesTrainingByFilesId(Long filesId);

    /**
     * 批量删除教师档案培训情况
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteTeacherFilesTrainingByIds(Long[] ids);

    public List<Training> selectTrainingList(Map map);

}
