package yangtz.cs.liu.campus.mapper.teacherFiles;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFiles;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesNotice;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesNoticeTotal;
import yangtz.cs.liu.campus.vo.teacherFiles.SchoolClassByGradeVo;
import yangtz.cs.liu.campus.vo.teacherFiles.SchoolGradeByClassVo;

import java.util.List;
import java.util.Map;

/**
 * 教师档案通知Mapper接口
 * 
 * @author ruoyi
 * @date 2023-09-06
 */
public interface TeacherFilesNoticeMapper extends BaseMapper<TeacherFilesNotice>
{
    /**
     * 查询教师档案通知
     * 
     * @param id 教师档案通知主键
     * @return 教师档案通知
     */
    public TeacherFilesNotice selectTeacherFilesNoticeById(String id);

    /**
     * 查询教室档案通知列表
     * 
     * @param teacherFilesNotice 教师档案通知
     * @return 教师档案通知集合
     */
    public List<TeacherFilesNoticeTotal> selectTeacherFilesNoticeList(TeacherFilesNotice teacherFilesNotice);

    /**
     * 新增教师档案通知
     * 
     * @param teacherFilesNotice 教师档案通知
     * @return 结果
     */
    public int insertTeacherFilesNotice(TeacherFilesNotice teacherFilesNotice);


    public List<TeacherFilesNotice> selctTeacherByUserId(TeacherFiles teacherFiles);

    /**
     * 修改教师档案通知
     * 
     * @param teacherFilesNotice 教师档案通知
     * @return 结果
     */
    public int updateTeacherFilesNotice(TeacherFilesNotice teacherFilesNotice);

    /**
     * 删除教师档案通知
     * 
     * @param id 教师档案通知主键
     * @return 结果
     */
    public int deleteTeacherFilesNoticeById(String id);

    /**
     * 批量删除教师档案通知
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteTeacherFilesNoticeByIds(String[] ids);


    public List<SchoolClassByGradeVo> getSchoolClassByGrade (Long gradeId);

    List<SchoolGradeByClassVo> selectTeacherByClass(@Param("classId") Long classId);
}
