package yangtz.cs.liu.campus.mapper.teacherFiles;

import yangtz.cs.liu.campus.domain.material.Material;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesMaterial;

import java.util.List;
import java.util.Map;

/**
 * 教师档案课题编写情况Mapper接口
 * 
 * @author ruoyi
 * @date 2023-09-08
 */
public interface TeacherFilesMaterialMapper 
{
    /**
     * 查询教师档案课题编写情况
     * 
     * @param id 教师档案课题编写情况主键
     * @return 教师档案课题编写情况
     */
    public TeacherFilesMaterial selectTeacherFilesMaterialById(Long id);

    /**
     * 查询教师档案课题编写情况列表
     * 
     * @param teacherFilesMaterial 教师档案课题编写情况
     * @return 教师档案课题编写情况集合
     */
    public List<TeacherFilesMaterial> selectTeacherFilesMaterialList(TeacherFilesMaterial teacherFilesMaterial);

    public List<TeacherFilesMaterial> selectTeacherFilesMaterialListByFilesId(Long filesId);

    /**
     * 新增教师档案课题编写情况
     * 
     * @param teacherFilesMaterial 教师档案课题编写情况
     * @return 结果
     */
    public int insertTeacherFilesMaterial(TeacherFilesMaterial teacherFilesMaterial);

    /**
     * 修改教师档案课题编写情况
     * 
     * @param teacherFilesMaterial 教师档案课题编写情况
     * @return 结果
     */
    public int updateTeacherFilesMaterial(TeacherFilesMaterial teacherFilesMaterial);

    /**
     * 删除教师档案课题编写情况
     * 
     * @param id 教师档案课题编写情况主键
     * @return 结果
     */
    public int deleteTeacherFilesMaterialById(Long id);

    public int deleteTeacherFilesMaterialByFilesId(Long filesId);

    /**
     * 批量删除教师档案课题编写情况
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteTeacherFilesMaterialByIds(Long[] ids);

    public List<Material> selectMaterialList(Map map);
}
