package yangtz.cs.liu.campus.mapper.student;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.student.SchoolStudentClassRelation;
import yangtz.cs.liu.campus.vo.schoolClass.StudentClassRelationVo;

import java.util.List;

@Mapper
public interface SchoolStudentClassRelationMapper extends BaseMapper<SchoolStudentClassRelation> {
    //查询学生班级关系列表
    List<StudentClassRelationVo> queryListByStudentId(Long studentId);

    /**
     * 修改学生与班级关系
     * @param updateRelationList
     */
    void updateRelationList(@Param("list") List<SchoolStudentClassRelation> updateRelationList);

    /**
     * 新增学生与班级关系
     * @param addRelationList
     */
    void addRelationList(@Param("list") List<SchoolStudentClassRelation> addRelationList);
}
