package yangtz.cs.liu.campus.mapper.student;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.student.SchoolStudentAward;

/**
 * 学生嘉奖Mapper接口
 *
 * @author ruoyi
 * @date 2024-01-08
 */
public interface SchoolStudentAwardMapper extends BaseMapper<SchoolStudentAward>
{
    /**
     * 查询学生嘉奖
     *
     * @param id 学生嘉奖主键
     * @return 学生嘉奖
     */
    public SchoolStudentAward selectSchoolStudentAwardById(Long id);

    /**
     * 查询学生嘉奖列表
     *
     * @param schoolStudentAward 学生嘉奖
     * @return 学生嘉奖集合
     */
    public List<SchoolStudentAward> selectSchoolStudentAwardList(SchoolStudentAward schoolStudentAward);

    /**
     * 新增学生嘉奖
     *
     * @param schoolStudentAward 学生嘉奖
     * @return 结果
     */
    public int insertSchoolStudentAward(SchoolStudentAward schoolStudentAward);

    /**
     * 修改学生嘉奖
     *
     * @param schoolStudentAward 学生嘉奖
     * @return 结果
     */
    public int updateSchoolStudentAward(SchoolStudentAward schoolStudentAward);

    /**
     * 删除学生嘉奖
     *
     * @param id 学生嘉奖主键
     * @return 结果
     */
    public int deleteSchoolStudentAwardById(Long id);

    /**
     * 批量删除学生嘉奖
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolStudentAwardByIds(Long[] ids);

    /**
     * 查询已通过的学生嘉奖列表
     * @param schoolStudentAward
     * @return
     */
    List<SchoolStudentAward> selectSchoolStudentAwardListTg(SchoolStudentAward schoolStudentAward);
}
