package yangtz.cs.liu.campus.mapper.student;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.student.SchoolStudentAchievement;

/**
 * 学生成绩Mapper接口
 *
 * @author ruoyi
 * @date 2024-01-08
 */
public interface SchoolStudentAchievementMapper extends BaseMapper<SchoolStudentAchievement>
{
    /**
     * 查询学生成绩
     *
     * @param id 学生成绩主键
     * @return 学生成绩
     */
    public SchoolStudentAchievement selectSchoolStudentAchievementById(Long id);

    /**
     * 查询学生成绩列表
     *
     * @param schoolStudentAchievement 学生成绩
     * @return 学生成绩集合
     */
    public List<SchoolStudentAchievement> selectSchoolStudentAchievementList(SchoolStudentAchievement schoolStudentAchievement);

    /**
     * 新增学生成绩
     *
     * @param schoolStudentAchievement 学生成绩
     * @return 结果
     */
    public int insertSchoolStudentAchievement(SchoolStudentAchievement schoolStudentAchievement);

    /**
     * 修改学生成绩
     *
     * @param schoolStudentAchievement 学生成绩
     * @return 结果
     */
    public int updateSchoolStudentAchievement(SchoolStudentAchievement schoolStudentAchievement);

    /**
     * 删除学生成绩
     *
     * @param id 学生成绩主键
     * @return 结果
     */
    public int deleteSchoolStudentAchievementById(Long id);

    /**
     * 批量删除学生成绩
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolStudentAchievementByIds(Long[] ids);
}
