package yangtz.cs.liu.campus.mapper.schoolbudget;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.schoolbudget.SchoolBudget;
import yangtz.cs.liu.campus.vo.schoolbudget.SchoolBudgetVo;

import java.util.List;

/**
 * 预算项目Mapper接口
 *
 * @author wengxiu
 * @date 2023-01-05
 */
public interface SchoolBudgetMapper extends BaseMapper<SchoolBudget>
{
    /**
     * 查询预算项目
     *
     * @param id 预算项目主键
     * @return 预算项目
     */
    public SchoolBudgetVo selectSchoolBudgetById(Long id);

    /**
     * 查询预算项目列表
     *
     * @param schoolBudget 预算项目
     * @return 预算项目集合
     */
    public List<SchoolBudgetVo> selectSchoolBudgetList(SchoolBudget schoolBudget);




    List<SchoolBudgetVo> selectExportList(SchoolBudget schoolBudget);

    int insertSchoolBudget(SchoolBudgetVo schoolBudgetVo);
}
